/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormLoginConfigType
extends ConfigBeanNode {
    String formLoginPage;
    String formErrorPage;

    public FormLoginConfigType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("form-login-config");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("form-login-page")) {
                    this.formLoginPage = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("form-error-page")) continue;
                this.formErrorPage = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "form-login-config");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "form-login-page", this.formLoginPage);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "form-error-page", this.formErrorPage);
        XMLUtils.writeTagEnd(out, indentation, "form-login-config");
    }

    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }
}

