/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.PropertyComponent;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.PropertyDescriptorComparator;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.GenericConfigBeanArrayEditor;
import oracle.oc4j.admin.deploy.spi.xml.GenericConfigBeanEditor;
import oracle.oc4j.admin.deploy.spi.xml.MethodParamType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;

public class GenericArrayEditorPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
FocusListener {
    private static Logger logger_ = TraceLogger.getLogger((Class)ListSelectionListener.class);
    private PropertyEditorSupport _editor;
    private ConfigBeanNode _parent;
    private Method _defaultMethod;
    private PropertyDescriptor[] _descriptors;
    private Class[] _propEdClass;
    private Class[] _propertyType;
    private Method[] _defaultMethods;
    private Class _beanClass;
    private int _cols;
    private int _currentFocus;
    private JButton _addButton;
    private JPanel _gridPane;
    private GridBagLayout _gridLayout;
    private GridBagConstraints _c;
    private int _y;
    private Vector _comps;
    private JScrollPane _sp = null;

    public GenericArrayEditorPanel(PropertyEditorSupport editor) {
        this._editor = editor;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        try {
            ConfigBeanNode[] bean = (ConfigBeanNode[])this._editor.getValue();
            if (bean == null || bean.length == 0 || bean[0] == null) {
                return;
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(bean[0].getClass());
            this._beanClass = bean[0].getClass();
            this._parent = bean[0].getConfigParent();
            this._descriptors = beanInfo.getPropertyDescriptors();
            if (this._descriptors.length == 0) {
                return;
            }
            Arrays.sort(this._descriptors, new PropertyDescriptorComparator());
            this._cols = this._descriptors.length;
            this._propEdClass = new Class[this._descriptors.length];
            this._propertyType = new Class[this._descriptors.length];
            this._defaultMethods = new Method[this._descriptors.length];
            this._gridPane = new JPanel();
            this._gridPane.setBackground(Deployer.ConfigPanelBackgroundColor);
            this._gridLayout = new GridBagLayout();
            this._gridPane.setLayout(this._gridLayout);
            this._c = new GridBagConstraints();
            this._c.fill = 2;
            this._c.ipady = 4;
            this._comps = new Vector();
            for (int v = 0; v < bean.length; ++v) {
                this._comps.add(new Vector());
            }
            for (int i = 0; i < this._descriptors.length; ++i) {
                this._y = 0;
                JLabel label = new JLabel(this._descriptors[i].getDisplayName() + " ", 0);
                label.setBackground(Deployer.EditableValueLabelBackgroundColor);
                label.setForeground(Deployer.LabelForegroundColor);
                label.setOpaque(true);
                this._c.gridy = this._y;
                this._c.gridx = i;
                this._c.weightx = 1.0;
                this._c.weighty = 1.0;
                this._gridLayout.setConstraints(label, this._c);
                this._gridPane.add(label);
                Method readMethod = this._descriptors[i].getReadMethod();
                PropertyEditor attrEditor = null;
                PropertyEditor defaultEditor = null;
                this._propEdClass[i] = this._descriptors[i].getPropertyEditorClass();
                this._propertyType[i] = this._descriptors[i].getPropertyType();
                Method getDefaultObjectMethod = null;
                try {
                    StringBuffer buf = new StringBuffer(this._descriptors[i].getName());
                    buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
                    String methodName = "default" + buf;
                    getDefaultObjectMethod = this._beanClass.getMethod(methodName, null);
                }
                catch (NoSuchMethodException ex) {
                    if (!logger_.isLoggable(Level.SEVERE)) continue;
                    logger_.log(Level.SEVERE, ex.getMessage(), ex);
                    continue;
                }
                this._defaultMethods[i] = getDefaultObjectMethod;
                for (int v = 0; v < bean.length; ++v) {
                    PropertyComponent propComp;
                    this._c.gridy = ++this._y;
                    if (this._propEdClass[i] != null) {
                        attrEditor = (PropertyEditor)this._propEdClass[i].newInstance();
                        defaultEditor = (PropertyEditor)this._propEdClass[i].newInstance();
                    } else {
                        this._propertyType[i] = this._descriptors[i].getPropertyType();
                        attrEditor = PropertyEditorManager.findEditor(this._propertyType[i]);
                        defaultEditor = PropertyEditorManager.findEditor(this._propertyType[i]);
                    }
                    Object obj = readMethod.invoke((Object)bean[v], null);
                    if (attrEditor == null) {
                        if (obj instanceof ConfigBeanNode) {
                            attrEditor = new GenericConfigBeanEditor();
                            defaultEditor = new GenericConfigBeanEditor();
                        } else {
                            if (!(obj instanceof ConfigBeanNode[])) continue;
                            attrEditor = new GenericConfigBeanArrayEditor();
                            defaultEditor = new GenericConfigBeanArrayEditor();
                        }
                    }
                    if (attrEditor.supportsCustomEditor()) {
                        label.setBackground(Deployer.CustomValueLabelBackgroundColor);
                    }
                    Object defaultObj = getDefaultObjectMethod.invoke((Object)bean[v], null);
                    defaultEditor.setValue(defaultObj);
                    if (obj != null) {
                        attrEditor.setValue(obj);
                    }
                    if (this._descriptors[i].getWriteMethod() != null) {
                        attrEditor.addPropertyChangeListener(new ChangeListener(bean[v], attrEditor, this._descriptors[i].getWriteMethod()));
                        propComp = new PropertyComponent(this._descriptors[i].getName(), attrEditor, true, defaultEditor);
                    } else {
                        propComp = new PropertyComponent(this._descriptors[i].getName(), attrEditor, false, defaultEditor);
                    }
                    this._gridLayout.setConstraints(propComp, this._c);
                    this._gridPane.add(propComp);
                    ((Vector)this._comps.elementAt(v)).add(propComp);
                }
            }
            JLabel label = new JLabel("      ", 0);
            this._c.gridy = 0;
            this._c.gridx = this._descriptors.length;
            this._gridLayout.setConstraints(label, this._c);
            this._gridPane.add(label);
            for (int v = 0; v < bean.length; ++v) {
                JButton removeButton = new JButton("Remove");
                this._c.gridy = v + 1;
                this._c.gridx = this._descriptors.length;
                this._gridLayout.setConstraints(removeButton, this._c);
                this._gridPane.add(removeButton);
                removeButton.addActionListener(this);
                ((Vector)this._comps.elementAt(v)).add(removeButton);
            }
            this._sp = new JScrollPane(this._gridPane);
            this.add((Component)this._sp, "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setOpaque(false);
            this._addButton = new JButton("Add");
            this._addButton.addActionListener(this);
            buttonPanel.add((Component)this._addButton, "West");
            this.add((Component)buttonPanel, "South");
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object eventObj = event.getSource();
        if (eventObj == this._addButton) {
            ConfigBeanNode newBean = null;
            try {
                Constructor beanConst = this._beanClass.getConstructor(ConfigBeanNode.class);
                newBean = (ConfigBeanNode)beanConst.newInstance(this._parent);
            }
            catch (Throwable ex) {
                throw new ExtendedRuntimeException(ex);
            }
            ++this._y;
            this._c.gridy = this._y;
            ConfigBeanNode[] beans = (ConfigBeanNode[])this._editor.getValue();
            ConfigBeanNode[] newBeans = new ConfigBeanNode[beans.length + 1];
            for (int v = 0; v < beans.length; ++v) {
                newBeans[v] = beans[v];
            }
            newBeans[beans.length] = newBean;
            this._editor.setValue(newBeans);
            this._comps.add(new Vector());
            for (int i = 0; i < this._cols; ++i) {
                try {
                    Object obj = this._defaultMethods[i].invoke((Object)newBean, null);
                    PropertyEditor attrEditor = null;
                    if (this._propEdClass[i] != null) {
                        attrEditor = (PropertyEditor)this._propEdClass[i].newInstance();
                    } else {
                        this._propertyType[i] = this._descriptors[i].getPropertyType();
                        attrEditor = PropertyEditorManager.findEditor(this._propertyType[i]);
                    }
                    if (attrEditor == null) {
                        if (obj instanceof ConfigBeanNode) {
                            attrEditor = new GenericConfigBeanEditor();
                        } else {
                            if (!(obj instanceof ConfigBeanNode[])) continue;
                            attrEditor = new GenericConfigBeanArrayEditor();
                        }
                    }
                    attrEditor.setValue(obj);
                    if (this._descriptors[i].getWriteMethod() != null) {
                        this._descriptors[i].getWriteMethod().invoke((Object)newBean, obj);
                    }
                    attrEditor.addPropertyChangeListener(new ChangeListener(newBean, attrEditor, this._descriptors[i].getWriteMethod()));
                    PropertyComponent propComp = new PropertyComponent(this._descriptors[i].getName(), attrEditor, true);
                    this._c.gridx = i;
                    this._gridLayout.setConstraints(propComp, this._c);
                    this._gridPane.add(propComp);
                    ((Vector)this._comps.elementAt(beans.length)).add(propComp);
                    continue;
                }
                catch (Throwable ex) {
                    throw new ExtendedRuntimeException(ex);
                }
            }
            JButton removeButton = new JButton("Remove");
            this._c.gridx = this._cols;
            this._gridLayout.setConstraints(removeButton, this._c);
            this._gridPane.add(removeButton);
            removeButton.addActionListener(this);
            ((Vector)this._comps.elementAt(beans.length)).add(removeButton);
            this._editor.firePropertyChange();
            this._gridPane.revalidate();
        } else {
            int selRow = -1;
            for (int row = 0; row < this._y; ++row) {
                Object obj = ((Vector)this._comps.elementAt(row)).elementAt(this._cols);
                if (obj == null || !(obj instanceof JButton) || !((JButton)eventObj).equals((JButton)obj)) continue;
                selRow = row;
                break;
            }
            if (selRow >= 0) {
                Vector v = (Vector)this._comps.elementAt(selRow);
                for (int n = 0; n < v.size() - 1; ++n) {
                    PropertyComponent p = (PropertyComponent)v.elementAt(n);
                    this._gridPane.remove(p);
                }
                this._gridPane.remove((JButton)eventObj);
                this._gridPane.revalidate();
                this._sp.setViewportView(this._gridPane);
                this._sp.revalidate();
                this._comps.removeElementAt(selRow);
                ConfigBeanNode[] beans = (ConfigBeanNode[])this._editor.getValue();
                ConfigBeanNode[] newBeans = new ConfigBeanNode[beans.length - 1];
                int newBean = 0;
                for (int oldBean = 0; oldBean < beans.length; ++oldBean) {
                    if (oldBean == selRow) continue;
                    newBeans[newBean++] = beans[oldBean];
                }
                this._editor.setValue(newBeans);
                --this._y;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    class ChangeListener
    implements PropertyChangeListener {
        Object _bean;
        PropertyEditor _editor;
        Method _writeMethod;

        public ChangeListener(Object bean, PropertyEditor editor, Method writeMethod) {
            this._bean = bean;
            this._editor = editor;
            this._writeMethod = writeMethod;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            block15: {
                try {
                    if (this._editor.getValue() instanceof Object[]) {
                        Object[] args = (Object[])this._editor.getValue();
                        Object[] parm = new Object[]{args};
                        if (args == null || args.length == 0) {
                            parm[0] = null;
                            this._writeMethod.invoke(this._bean, parm);
                        } else if (args[0] instanceof MethodParamType) {
                            MethodParamType[] paramArgs = new MethodParamType[args.length];
                            for (int n = 0; n < args.length; ++n) {
                                paramArgs[n] = (MethodParamType)args[n];
                            }
                            parm[0] = paramArgs;
                            this._writeMethod.invoke(this._bean, parm);
                        } else if (args[0] instanceof PropertyConfigBean) {
                            PropertyConfigBean[] paramArgs = new PropertyConfigBean[args.length];
                            for (int n = 0; n < args.length; ++n) {
                                paramArgs[n] = (PropertyConfigBean)args[n];
                            }
                            parm[0] = paramArgs;
                            this._writeMethod.invoke(this._bean, parm);
                        } else if (args[0] instanceof ConfigPropertyType) {
                            ConfigPropertyType[] paramArgs = new ConfigPropertyType[args.length];
                            for (int n = 0; n < args.length; ++n) {
                                paramArgs[n] = (ConfigPropertyType)args[n];
                            }
                            parm[0] = paramArgs;
                            this._writeMethod.invoke(this._bean, parm);
                        } else {
                            this._writeMethod.invoke(this._bean, parm);
                        }
                    } else {
                        this._writeMethod.invoke(this._bean, this._editor.getValue());
                    }
                }
                catch (Exception ex) {
                    GuiUtil.errDialog(ex.getMessage());
                    if (!logger_.isLoggable(Level.SEVERE)) break block15;
                    logger_.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    private class Coord {
        int _x;
        int _y;

        Coord(int x, int y) {
            this._x = x;
            this._y = y;
        }
    }
}

