/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.LoginModuleType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaznLoginConfigType
extends ConfigBeanNode {
    String _key = null;
    LoginModuleType[] _loginModules = null;

    public JaznLoginConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public String getKey() {
        return this._key;
    }

    public String defaultKey() {
        return "name";
    }

    public String getName() {
        return this.determineRoot().getApplicationId();
    }

    public String defaultName() {
        return this.determineRoot().defaultApplicationId();
    }

    public void setLoginModules(LoginModuleType[] loginModules) throws ConfigurationException {
        LoginModuleType[] oldValue = this._loginModules;
        this._loginModules = loginModules;
        this.firePropertyChange("loginModules", oldValue, this._loginModules);
    }

    public LoginModuleType[] getLoginModules() {
        return this._loginModules;
    }

    public LoginModuleType[] defaultLoginModules() {
        return new LoginModuleType[0];
    }

    public void addLoginModules() throws ConfigurationException {
        if (this._loginModules != null) {
            return;
        }
        LoginModuleType[] loginModules = new LoginModuleType[]{new LoginModuleType(this, null)};
        this.setLoginModules(loginModules);
    }

    public void removeLoginModules() throws ConfigurationException {
        if (this._loginModules == null) {
            return;
        }
        this.setLoginModules(null);
    }

    public void addLoginModule(LoginModuleType loginModule) throws ConfigurationException {
        loginModule.setParent(this);
        int existingLoginModulesCnt = 0;
        if (this._loginModules != null) {
            existingLoginModulesCnt = this._loginModules.length;
        }
        LoginModuleType[] newLoginModules = new LoginModuleType[existingLoginModulesCnt + 1];
        for (int n = 0; n < existingLoginModulesCnt; ++n) {
            newLoginModules[n] = this._loginModules[n];
        }
        newLoginModules[existingLoginModulesCnt] = loginModule;
        LoginModuleType[] oldValue = this._loginModules;
        this._loginModules = newLoginModules;
        this.firePropertyChange("loginModules", oldValue, this._loginModules);
    }

    public void removeLoginModule(LoginModuleType loginModule) throws ConfigurationException {
        int existingLoginModulesCnt = 0;
        if (this._loginModules != null) {
            existingLoginModulesCnt = this._loginModules.length;
        }
        LoginModuleType[] newLoginModules = new LoginModuleType[existingLoginModulesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingLoginModulesCnt; ++n) {
            if (loginModule.equals(this._loginModules[n])) continue;
            newLoginModules[newIndex++] = this._loginModules[n];
        }
        if (newLoginModules.length == 0) {
            newLoginModules = null;
        }
        LoginModuleType[] oldValue = this._loginModules;
        this._loginModules = newLoginModules;
        this.firePropertyChange("loginModules", oldValue, this._loginModules);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "jazn-loginconfig");
        XMLUtils.writeTagAttributeEnd(out, indentation, "jazn-loginconfig");
        XMLUtils.writeTagAttributeStart(out, indentation + "\t", "application");
        XMLUtils.writeAttribute(out, indentation + "\t", "Key", this._key);
        XMLUtils.writeTagAttributeEnd(out, indentation + "\t", "application");
        XMLUtils.writeTag(out, indentation + "\t\t", "name", this.determineRoot().getApplicationId());
        this.writeLoginModulesXML(out, indentation + "\t\t");
        XMLUtils.writeTagEnd(out, indentation + "\t", "application");
        XMLUtils.writeTagEnd(out, indentation, "jazn-loginconfig");
    }

    public void writeLoginModulesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        LoginModuleType.writeXML(out, indentation, this._loginModules);
    }

    private void init() throws ConfigurationException {
        this.setXpath("jazn-loginconfig");
        Vector<LoginModuleType> loginModules = new Vector<LoginModuleType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("application")) continue;
                NodeList applicationNodes = node.getChildNodes();
                for (int a = 0; a < applicationNodes.getLength(); ++a) {
                    node = applicationNodes.item(a);
                    name = node.getNodeName();
                    if (!name.equals("login-modules")) continue;
                    NodeList moduleNodes = node.getChildNodes();
                    for (int m = 0; m < moduleNodes.getLength(); ++m) {
                        node = moduleNodes.item(m);
                        name = node.getNodeName();
                        if (!name.equals("login-module")) continue;
                        LoginModuleType configBean = new LoginModuleType(this, node);
                        loginModules.add(configBean);
                    }
                }
            }
        }
        this._key = this.defaultKey();
        if (loginModules.size() > 0) {
            this.setLoginModules(loginModules.toArray(new LoginModuleType[0]));
        }
    }
}

