/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.AttributesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JmxMBeanType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class JmxMBeanTreeNode
extends ConfigTreeNode
implements ActionListener {
    private JmxMBeanType _bean;
    private static final String REMOVE_JMX_MBEAN_MENU_STRING = "Remove JMX MBean";
    private JMenuItem _removeJmxMBeanMenuItem;

    public JmxMBeanTreeNode(ConfigTreeNode rootNode, JmxMBeanType jmxMBean) {
        super(jmxMBean);
        this.setRootNode(rootNode);
        this._bean = jmxMBean;
        this._removeJmxMBeanMenuItem = new JMenuItem(REMOVE_JMX_MBEAN_MENU_STRING);
        this._removeJmxMBeanMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeJmxMBeanMenuItem.setFont(JmxMBeanTreeNode.getFont());
        this._removeJmxMBeanMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeJmxMBeanMenuItem);
    }

    public String viewHeaderString() {
        return "JMX MBean";
    }

    public String toString() {
        return this._bean.getObjectName();
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = JmxMBeanType.class.getMethod("writeAttributesXML", PrintWriter.class, String.class);
            AttributesTreeNode attributesTreeNode = new AttributesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(attributesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_JMX_MBEAN_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

