/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.FileType;
import oracle.oc4j.admin.deploy.spi.xml.MailType;
import oracle.oc4j.admin.deploy.spi.xml.OdlType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogType
extends ConfigBeanNode {
    FileType[] _files = null;
    MailType[] _mail = null;
    OdlType[] _odls = null;

    public LogType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public LogType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setFiles(FileType[] files) {
        this._files = files;
    }

    public FileType[] getFiles() {
        return this._files;
    }

    public FileType[] defaultFiles() {
        return new FileType[0];
    }

    public void addFiles() {
        if (this._files != null) {
            return;
        }
        FileType[] files = new FileType[]{new FileType(this, null)};
        this.setFiles(files);
    }

    public void removeFiles() {
        if (this._files == null) {
            return;
        }
        this.setFiles(null);
    }

    public void addFile(FileType file) {
        file.setParent(this);
        int existingFilesCnt = 0;
        if (this._files != null) {
            existingFilesCnt = this._files.length;
        }
        FileType[] newFiles = new FileType[existingFilesCnt + 1];
        for (int n = 0; n < existingFilesCnt; ++n) {
            newFiles[n] = this._files[n];
        }
        newFiles[existingFilesCnt] = file;
        FileType[] oldValue = this._files;
        this._files = newFiles;
        this.firePropertyChange("files", oldValue, this._files);
    }

    public void removeFile(FileType file) {
        int existingFilesCnt = 0;
        if (this._files != null) {
            existingFilesCnt = this._files.length;
        }
        FileType[] newFiles = new FileType[existingFilesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingFilesCnt; ++n) {
            if (file.equals(this._files[n])) continue;
            newFiles[newIndex++] = this._files[n];
        }
        FileType[] oldValue = this._files;
        this._files = newFiles;
        this.firePropertyChange("files", oldValue, this._files);
    }

    public void setMail(MailType[] mail) {
        this._mail = mail;
    }

    public MailType[] getMail() {
        return this._mail;
    }

    public MailType[] defaultMail() {
        return new MailType[0];
    }

    public void addMail() {
        if (this._mail != null) {
            return;
        }
        MailType[] mail = new MailType[]{new MailType(this, null)};
        this.setMail(mail);
    }

    public void removeMail() {
        if (this._mail == null) {
            return;
        }
        this.setMail(null);
    }

    public void addMail(MailType mail) {
        mail.setParent(this);
        int existingMailCnt = 0;
        if (this._mail != null) {
            existingMailCnt = this._mail.length;
        }
        MailType[] newMail = new MailType[existingMailCnt + 1];
        for (int n = 0; n < existingMailCnt; ++n) {
            newMail[n] = this._mail[n];
        }
        newMail[existingMailCnt] = mail;
        MailType[] oldValue = this._mail;
        this._mail = newMail;
        this.firePropertyChange("mail", oldValue, this._mail);
    }

    public void removeMail(MailType mail) {
        int existingMailCnt = 0;
        if (this._mail != null) {
            existingMailCnt = this._mail.length;
        }
        MailType[] newMail = new MailType[existingMailCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingMailCnt; ++n) {
            if (mail.equals(this._mail[n])) continue;
            newMail[newIndex++] = this._mail[n];
        }
        MailType[] oldValue = this._mail;
        this._mail = newMail;
        this.firePropertyChange("mail", oldValue, this._mail);
    }

    public void setOdls(OdlType[] odls) {
        this._odls = odls;
    }

    public OdlType[] getOdls() {
        return this._odls;
    }

    public OdlType[] defaultOdls() {
        return new OdlType[0];
    }

    public void addOdls() throws ConfigurationException {
        if (this._odls != null) {
            return;
        }
        OdlType[] odls = new OdlType[]{new OdlType(this, null)};
        this.setOdls(odls);
    }

    public void removeOdls() {
        if (this._odls == null) {
            return;
        }
        this.setOdls(null);
    }

    public void addOdl(OdlType odl) {
        odl.setParent(this);
        int existingOdlsCnt = 0;
        if (this._odls != null) {
            existingOdlsCnt = this._odls.length;
        }
        OdlType[] newOdls = new OdlType[existingOdlsCnt + 1];
        for (int n = 0; n < existingOdlsCnt; ++n) {
            newOdls[n] = this._odls[n];
        }
        newOdls[existingOdlsCnt] = odl;
        OdlType[] oldValue = this._odls;
        this._odls = newOdls;
        this.firePropertyChange("odls", oldValue, this._odls);
    }

    public void removeOdl(OdlType odl) {
        int existingOdlsCnt = 0;
        if (this._odls != null) {
            existingOdlsCnt = this._odls.length;
        }
        OdlType[] newOdls = new OdlType[existingOdlsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingOdlsCnt; ++n) {
            if (odl.equals(this._odls[n])) continue;
            newOdls[newIndex++] = this._odls[n];
        }
        OdlType[] oldValue = this._odls;
        this._odls = newOdls;
        this.firePropertyChange("odls", oldValue, this._odls);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "log");
        XMLUtils.writeTagAttributeEnd(out, indentation, "log");
        LogType.writeXML(out, indentation + "\t", this._files);
        LogType.writeXML(out, indentation + "\t", this._mail);
        LogType.writeXML(out, indentation + "\t", this._odls);
        XMLUtils.writeTagEnd(out, indentation, "log");
    }

    private void init() throws ConfigurationException {
        this.setXpath("log");
        Vector<FileType> files = new Vector<FileType>();
        Vector<FileType> mail = new Vector<FileType>();
        Vector<FileType> odls = new Vector<FileType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                ConfigBeanNode configBean;
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("file")) {
                    configBean = new FileType(this, node);
                    files.add((FileType)configBean);
                    continue;
                }
                if (name.equals("mail")) {
                    configBean = new MailType(this, node);
                    mail.add((FileType)configBean);
                    continue;
                }
                if (!name.equals("odl")) continue;
                configBean = new OdlType(this, node);
                odls.add((FileType)configBean);
            }
        }
        if (files.size() > 0) {
            this._files = files.toArray(new FileType[0]);
        }
        if (mail.size() > 0) {
            this._mail = mail.toArray(new MailType[0]);
        }
        if (odls.size() > 0) {
            this._odls = odls.toArray(new OdlType[0]);
        }
    }
}

