/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MDBConfigPropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MDBConfigPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class MDBConfigPropertiesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_CONFIG_PROPERTY_MENU_STRING = "Add Config Property";
    private JMenuItem _addConfigPropertyMenuItem;
    private MDBConfigPropertyType[] configPropertiesType = new MDBConfigPropertyType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public MDBConfigPropertiesTreeNode(ConfigTreeNode rootNode, MultipleType configProperties) {
        super(configProperties);
        this.setRootNode(rootNode);
        this._parentBean = configProperties.getConfigParent();
        this._addConfigPropertyMenuItem = new JMenuItem(ADD_CONFIG_PROPERTY_MENU_STRING);
        this._addConfigPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addConfigPropertyMenuItem.setFont(MDBConfigPropertiesTreeNode.getFont());
        this._addConfigPropertyMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addConfigPropertyMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getConfigProperties", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addConfigProperty", MDBConfigPropertyType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeConfigProperty", MDBConfigPropertyType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Config Properties";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            MDBConfigPropertyType[] configProperties = (MDBConfigPropertyType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (configProperties != null) {
                for (int i = 0; i < configProperties.length; ++i) {
                    MDBConfigPropertyType configProperty = configProperties[i];
                    if (configProperty == null) continue;
                    MDBConfigPropertyTreeNode configPropertyTreeNode = new MDBConfigPropertyTreeNode(this.getRootNode(), configProperty);
                    this.addChild(configPropertyTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            MDBConfigPropertyType newConfigProperty;
            if (event.getActionCommand().equals(ADD_CONFIG_PROPERTY_MENU_STRING) && this.showAddDialog(newConfigProperty = new MDBConfigPropertyType(this._parentBean), ADD_CONFIG_PROPERTY_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newConfigProperty);
                MDBConfigPropertyTreeNode newNode = new MDBConfigPropertyTreeNode(this, newConfigProperty);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof MDBConfigPropertyTreeNode) {
            try {
                MDBConfigPropertyType configProperty = (MDBConfigPropertyType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, configProperty);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

