/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.OptionNameType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OptionType
extends ConfigBeanNode {
    String _key = null;
    OptionNameType _name = null;
    String _value = null;

    public OptionType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public OptionType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public String getKey() {
        return this._key;
    }

    public String defaultKey() {
        return "name value";
    }

    public void setName(OptionNameType name) {
        OptionNameType oldName = this._name;
        this._name = name;
        this.firePropertyChange("name", oldName, this._name);
    }

    public OptionNameType defaultName() {
        return new OptionNameType(this);
    }

    public OptionNameType getName() {
        return this._name;
    }

    public void setValue(String value) {
        String oldValue = this._value;
        this._value = value;
        this.firePropertyChange("value", oldValue, this._value);
    }

    public String defaultValue() {
        return "";
    }

    public String getValue() {
        return this._value;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._name != null && this._name.getValue() != null && this._name.getValue().length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation, "option");
            XMLUtils.writeAttribute(out, indentation + "\t", "Key", this._key);
            XMLUtils.writeTagAttributeEnd(out, indentation, "option");
            XMLUtils.writeTag(out, indentation + "\t", "name", this._name);
            XMLUtils.writeTag(out, indentation + "\t", "value", this._value);
            XMLUtils.writeTagEnd(out, indentation, "option");
        }
    }

    public static void writeXML(PrintWriter out, String indentation, OptionType[] options) throws ExtendedRuntimeException {
        if (options == null) {
            return;
        }
        XMLUtils.writeTagAttributeStart(out, indentation, "options");
        XMLUtils.writeTagAttributeEnd(out, indentation, "options");
        for (int n = 0; n < options.length; ++n) {
            options[n].writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "options");
    }

    private void init() {
        this.setXpath("options/option");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("name")) {
                    this._name = new OptionNameType(this);
                    this._name.setValue(XMLUtils.getValue(node));
                    continue;
                }
                if (!name.equals("value")) continue;
                this._value = XMLUtils.getValue(node);
            }
        }
        this._key = this.defaultKey();
    }
}

