/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptConfigType;
import oracle.oc4j.admin.deploy.spi.xml.EncryptTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OutboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SamlTokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SamlTokenTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignatureConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.UsernameTokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.UsernameTokenTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.X509TokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.X509TokenTreeNode;

public class OutboundTreeNode
extends ConfigTreeNode
implements ActionListener {
    private OutboundConfigType _bean;
    private static final String ADD_USERNAME_TOKEN_MENU_STRING = "Add Username Token";
    private static final String ADD_X509_TOKEN_MENU_STRING = "Add X509 Token";
    private static final String ADD_SAML_TOKEN_MENU_STRING = "Add Saml Token";
    private static final String ADD_SIGNATURE_MENU_STRING = "Add Signature";
    private static final String ADD_ENCRYPT_MENU_STRING = "Add Encrypt";
    private static final String REMOVE_OUTBOUND_MENU_STRING = "Remove Outbound";
    private JMenuItem _addUsernameTokenMenuItem;
    private JMenuItem _addX509TokenMenuItem;
    private JMenuItem _addSamlTokenMenuItem;
    private JMenuItem _addSignatureMenuItem;
    private JMenuItem _addEncryptMenuItem;
    private JMenuItem _removeOutboundMenuItem;

    public OutboundTreeNode(ConfigTreeNode rootNode, OutboundConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addUsernameTokenMenuItem = new JMenuItem(ADD_USERNAME_TOKEN_MENU_STRING);
        this._addUsernameTokenMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addUsernameTokenMenuItem.setFont(OutboundTreeNode.getFont());
        this._addUsernameTokenMenuItem.addActionListener(this);
        if (this._bean.getUsernameToken() != null) {
            this._addUsernameTokenMenuItem.setEnabled(false);
        } else if (this._bean.getX509Token() != null || this._bean.getSamlToken() != null) {
            this._addUsernameTokenMenuItem.setEnabled(false);
        }
        this._addX509TokenMenuItem = new JMenuItem(ADD_X509_TOKEN_MENU_STRING);
        this._addX509TokenMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addX509TokenMenuItem.setFont(OutboundTreeNode.getFont());
        this._addX509TokenMenuItem.addActionListener(this);
        if (this._bean.getX509Token() != null) {
            this._addX509TokenMenuItem.setEnabled(false);
        } else if (this._bean.getUsernameToken() != null || this._bean.getSamlToken() != null) {
            this._addX509TokenMenuItem.setEnabled(false);
        }
        this._addSamlTokenMenuItem = new JMenuItem(ADD_SAML_TOKEN_MENU_STRING);
        this._addSamlTokenMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSamlTokenMenuItem.setFont(OutboundTreeNode.getFont());
        this._addSamlTokenMenuItem.addActionListener(this);
        if (this._bean.getSamlToken() != null) {
            this._addSamlTokenMenuItem.setEnabled(false);
        } else if (this._bean.getUsernameToken() != null || this._bean.getX509Token() != null) {
            this._addSamlTokenMenuItem.setEnabled(false);
        }
        this._addSignatureMenuItem = new JMenuItem(ADD_SIGNATURE_MENU_STRING);
        this._addSignatureMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSignatureMenuItem.setFont(OutboundTreeNode.getFont());
        this._addSignatureMenuItem.addActionListener(this);
        if (this._bean.getSignature() != null) {
            this._addSignatureMenuItem.setEnabled(false);
        }
        this._addEncryptMenuItem = new JMenuItem(ADD_ENCRYPT_MENU_STRING);
        this._addEncryptMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEncryptMenuItem.setFont(OutboundTreeNode.getFont());
        this._addEncryptMenuItem.addActionListener(this);
        if (this._bean.getEncrypt() != null) {
            this._addEncryptMenuItem.setEnabled(false);
        }
        this._removeOutboundMenuItem = new JMenuItem(REMOVE_OUTBOUND_MENU_STRING);
        this._removeOutboundMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeOutboundMenuItem.setFont(OutboundTreeNode.getFont());
        this._removeOutboundMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addUsernameTokenMenuItem);
        this._popup.add(this._addX509TokenMenuItem);
        this._popup.add(this._addSamlTokenMenuItem);
        this._popup.add(this._addSignatureMenuItem);
        this._popup.add(this._addEncryptMenuItem);
        this._popup.add(this._removeOutboundMenuItem);
    }

    public String viewHeaderString() {
        return "Outbound";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        EncryptConfigType encrypt;
        SignatureConfigType signature;
        SamlTokenConfigType SamlToken;
        X509TokenConfigType X509Token;
        UsernameTokenConfigType usernameToken = this._bean.getUsernameToken();
        if (usernameToken != null) {
            UsernameTokenTreeNode usernameTokenTreeNode = new UsernameTokenTreeNode(this.getRootNode(), usernameToken);
            this.addChild(usernameTokenTreeNode);
        }
        if ((X509Token = this._bean.getX509Token()) != null) {
            X509TokenTreeNode X509TokenTreeNode2 = new X509TokenTreeNode(this.getRootNode(), X509Token);
            this.addChild(X509TokenTreeNode2);
        }
        if ((SamlToken = this._bean.getSamlToken()) != null) {
            SamlTokenTreeNode SamlTokenTreeNode2 = new SamlTokenTreeNode(this.getRootNode(), SamlToken);
            this.addChild(SamlTokenTreeNode2);
        }
        if ((signature = this._bean.getSignature()) != null) {
            SignatureTreeNode signatureTreeNode = new SignatureTreeNode(this.getRootNode(), signature);
            this.addChild(signatureTreeNode);
        }
        if ((encrypt = this._bean.getEncrypt()) != null) {
            EncryptTreeNode encryptTreeNode = new EncryptTreeNode(this.getRootNode(), encrypt);
            this.addChild(encryptTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_USERNAME_TOKEN_MENU_STRING)) {
                UsernameTokenConfigType newUsernameToken = this._bean.defaultUsernameToken();
                if (this.showAddDialog(newUsernameToken, ADD_USERNAME_TOKEN_MENU_STRING)) {
                    this._bean.setUsernameToken(newUsernameToken);
                    UsernameTokenTreeNode newNode = new UsernameTokenTreeNode(this, newUsernameToken);
                    this.insertNode(newNode);
                    this._addUsernameTokenMenuItem.setEnabled(false);
                    this._addX509TokenMenuItem.setEnabled(false);
                    this._addSamlTokenMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_X509_TOKEN_MENU_STRING)) {
                X509TokenConfigType newX509Token = this._bean.defaultX509Token();
                if (this.showAddDialog(newX509Token, ADD_X509_TOKEN_MENU_STRING)) {
                    this._bean.setX509Token(newX509Token);
                    X509TokenTreeNode newNode = new X509TokenTreeNode(this, newX509Token);
                    this.insertNode(newNode);
                    this._addUsernameTokenMenuItem.setEnabled(false);
                    this._addX509TokenMenuItem.setEnabled(false);
                    this._addSamlTokenMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SAML_TOKEN_MENU_STRING)) {
                SamlTokenConfigType newSamlToken = this._bean.defaultSamlToken();
                if (this.showAddDialog(newSamlToken, ADD_SAML_TOKEN_MENU_STRING)) {
                    this._bean.setSamlToken(newSamlToken);
                    SamlTokenTreeNode newNode = new SamlTokenTreeNode(this, newSamlToken);
                    this.insertNode(newNode);
                    this._addUsernameTokenMenuItem.setEnabled(false);
                    this._addX509TokenMenuItem.setEnabled(false);
                    this._addSamlTokenMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SIGNATURE_MENU_STRING)) {
                if (this._bean.getSignature() == null) {
                    this._bean.addSignature();
                    SignatureTreeNode newNode = new SignatureTreeNode(this, this._bean.getSignature());
                    this.insertNode(newNode);
                    this._addSignatureMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_ENCRYPT_MENU_STRING)) {
                EncryptConfigType newEncrypt = this._bean.defaultEncrypt();
                if (this.showAddDialog(newEncrypt, ADD_ENCRYPT_MENU_STRING)) {
                    this._bean.setEncrypt(newEncrypt);
                    EncryptTreeNode newNode = new EncryptTreeNode(this, newEncrypt);
                    this.insertNode(newNode);
                    this._addEncryptMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_OUTBOUND_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof UsernameTokenTreeNode) {
            this._bean.removeUsernameToken();
            this.removeNode(node);
            this._addUsernameTokenMenuItem.setEnabled(true);
            this._addX509TokenMenuItem.setEnabled(true);
            this._addSamlTokenMenuItem.setEnabled(true);
        } else if (node instanceof X509TokenTreeNode) {
            this._bean.removeX509Token();
            this.removeNode(node);
            this._addUsernameTokenMenuItem.setEnabled(true);
            this._addX509TokenMenuItem.setEnabled(true);
            this._addSamlTokenMenuItem.setEnabled(true);
        } else if (node instanceof SamlTokenTreeNode) {
            this._bean.removeSamlToken();
            this.removeNode(node);
            this._addUsernameTokenMenuItem.setEnabled(true);
            this._addX509TokenMenuItem.setEnabled(true);
            this._addSamlTokenMenuItem.setEnabled(true);
        } else if (node instanceof SignatureTreeNode) {
            this._bean.removeSignature();
            this.removeNode(node);
            this._addSignatureMenuItem.setEnabled(true);
        } else if (node instanceof EncryptTreeNode) {
            this._bean.removeEncrypt();
            this.removeNode(node);
            this._addEncryptMenuItem.setEnabled(true);
        }
    }
}

