/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ParamTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ParamType;

public class ParamsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_PARAM_MENU_STRING = "Add Param";
    private JMenuItem _addParamMenuItem;
    private ParamType[] paramsType = new ParamType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ParamsTreeNode(ConfigTreeNode rootNode, MultipleType params) {
        super(params);
        this.setRootNode(rootNode);
        this._parentBean = params.getConfigParent();
        this._addParamMenuItem = new JMenuItem(ADD_PARAM_MENU_STRING);
        this._addParamMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addParamMenuItem.setFont(ParamsTreeNode.getFont());
        this._addParamMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addParamMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getParams", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addParam", ParamType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeParam", ParamType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Params";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ParamType[] params = (ParamType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ParamType param = params[i];
                    if (param == null) continue;
                    ParamTreeNode paramTreeNode = new ParamTreeNode(this.getRootNode(), param);
                    this.addChild(paramTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ParamType newParam;
            if (event.getActionCommand().equals(ADD_PARAM_MENU_STRING) && this.showAddDialog(newParam = new ParamType(this._parentBean), ADD_PARAM_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newParam);
                ParamTreeNode newNode = new ParamTreeNode(this, newParam);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ParamTreeNode) {
            try {
                ParamType param = (ParamType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, param);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

