/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EjbTransportSecurityConstraintTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EjbTransportSecurityConstraintType;
import oracle.oc4j.admin.deploy.spi.xml.JmsAddressTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JmsAddressType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentDeploymentTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentDeploymentType;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentImplementorTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentImplementorType;
import oracle.oc4j.admin.deploy.spi.xml.ServerOperationsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServerPortRuntimeTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServerPortRuntimeType;

public class PortComponentTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PortComponentConfigBean _bean;
    private static final String ADD_PORT_COMPONENT_DEPLOYMENT_MENU_STRING = "Add Deployment";
    private static final String ADD_PORT_COMPONENT_IMPLEMENTOR_MENU_STRING = "Add Implementor";
    private static final String ADD_EJB_TRANSPORT_SECURITY_CONSTRAINT_MENU_STRING = "Add Ejb Transport Security Constraint";
    private static final String ADD_RUNTIME_MENU_STRING = "Add Runtime";
    private static final String ADD_JMS_ADDRESS_MENU_STRING = "Add Jms Address";
    private JMenuItem _addPortComponentDeploymentMenuItem;
    private JMenuItem _addPortComponentImplementorMenuItem;
    private JMenuItem _addRuntimeMenuItem;
    private JMenuItem _addJmsAddressMenuItem;
    private JMenuItem _addEjbTransportSecurityConstraintMenuItem;

    public PortComponentTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (PortComponentConfigBean)bean;
        this._addPortComponentDeploymentMenuItem = new JMenuItem(ADD_PORT_COMPONENT_DEPLOYMENT_MENU_STRING);
        this._addPortComponentDeploymentMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPortComponentDeploymentMenuItem.setFont(PortComponentTreeNode.getFont());
        this._addPortComponentDeploymentMenuItem.addActionListener(this);
        if (this._bean.getPortComponentDeployment() != null) {
            this._addPortComponentDeploymentMenuItem.setEnabled(false);
        }
        this._addPortComponentImplementorMenuItem = new JMenuItem(ADD_PORT_COMPONENT_IMPLEMENTOR_MENU_STRING);
        this._addPortComponentImplementorMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPortComponentImplementorMenuItem.setFont(PortComponentTreeNode.getFont());
        this._addPortComponentImplementorMenuItem.addActionListener(this);
        if (this._bean.getPortComponentImplementor() != null) {
            this._addPortComponentImplementorMenuItem.setEnabled(false);
        }
        this._addRuntimeMenuItem = new JMenuItem(ADD_RUNTIME_MENU_STRING);
        this._addRuntimeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRuntimeMenuItem.setFont(PortComponentTreeNode.getFont());
        this._addRuntimeMenuItem.addActionListener(this);
        if (this._bean.getRuntime() != null) {
            this._addRuntimeMenuItem.setEnabled(false);
        }
        this._addJmsAddressMenuItem = new JMenuItem(ADD_JMS_ADDRESS_MENU_STRING);
        this._addJmsAddressMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJmsAddressMenuItem.setFont(PortComponentTreeNode.getFont());
        this._addJmsAddressMenuItem.addActionListener(this);
        if (this._bean.getJmsAddress() != null) {
            this._addJmsAddressMenuItem.setEnabled(false);
        }
        this._addEjbTransportSecurityConstraintMenuItem = new JMenuItem(ADD_EJB_TRANSPORT_SECURITY_CONSTRAINT_MENU_STRING);
        this._addEjbTransportSecurityConstraintMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEjbTransportSecurityConstraintMenuItem.setFont(PortComponentTreeNode.getFont());
        this._addEjbTransportSecurityConstraintMenuItem.addActionListener(this);
        if (this._bean.getEjbTransportSecurityConstraint() != null) {
            this._addEjbTransportSecurityConstraintMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addPortComponentDeploymentMenuItem);
        this._popup.add(this._addPortComponentImplementorMenuItem);
        this._popup.add(this._addRuntimeMenuItem);
        this._popup.add(this._addJmsAddressMenuItem);
        this._popup.add(this._addEjbTransportSecurityConstraintMenuItem);
    }

    public String viewHeaderString() {
        return "Port Component Mappings";
    }

    public String toString() {
        return this._bean.getName();
    }

    protected void buildChildJTree() {
        EjbTransportSecurityConstraintType ejbTransportSecurityConstraint;
        JmsAddressType jmsAddress;
        ServerPortRuntimeType runtime;
        PortComponentImplementorType portComponentImplementor;
        PortComponentDeploymentType portComponentDeployment = this._bean.getPortComponentDeployment();
        if (portComponentDeployment != null) {
            PortComponentDeploymentTreeNode portComponentDeploymentTreeNode = new PortComponentDeploymentTreeNode(this.getRootNode(), portComponentDeployment);
            this.addChild(portComponentDeploymentTreeNode);
        }
        if ((portComponentImplementor = this._bean.getPortComponentImplementor()) != null) {
            PortComponentImplementorTreeNode portComponentImplementorTreeNode = new PortComponentImplementorTreeNode(this.getRootNode(), portComponentImplementor);
            this.addChild(portComponentImplementorTreeNode);
        }
        if ((runtime = this._bean.getRuntime()) != null) {
            ServerPortRuntimeTreeNode serverPortRuntimeTreeNode = new ServerPortRuntimeTreeNode(this.getRootNode(), runtime);
            this.addChild(serverPortRuntimeTreeNode);
        }
        if ((jmsAddress = this._bean.getJmsAddress()) != null) {
            JmsAddressTreeNode jmsAddressTreeNode = new JmsAddressTreeNode(this.getRootNode(), jmsAddress);
            this.addChild(jmsAddressTreeNode);
        }
        if ((ejbTransportSecurityConstraint = this._bean.getEjbTransportSecurityConstraint()) != null) {
            EjbTransportSecurityConstraintTreeNode ejbTransportSecurityConstraintTreeNode = new EjbTransportSecurityConstraintTreeNode(this.getRootNode(), ejbTransportSecurityConstraint);
            this.addChild(ejbTransportSecurityConstraintTreeNode);
        }
        try {
            Method xmlMethod = PortComponentConfigBean.class.getMethod("writeServerOperationsXML", PrintWriter.class, String.class);
            ServerOperationsTreeNode serverOperationsTreeNode = new ServerOperationsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(serverOperationsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            EjbTransportSecurityConstraintType newEjbTransportSecurityConstraint;
            if (event.getActionCommand().equals(ADD_PORT_COMPONENT_DEPLOYMENT_MENU_STRING)) {
                PortComponentDeploymentType newPortComponentDeployment = this._bean.defaultPortComponentDeployment();
                if (this.showAddDialog(newPortComponentDeployment, ADD_PORT_COMPONENT_DEPLOYMENT_MENU_STRING)) {
                    this._bean.setPortComponentDeployment(newPortComponentDeployment);
                    PortComponentDeploymentTreeNode newNode = new PortComponentDeploymentTreeNode(this, newPortComponentDeployment);
                    this.insertNode(newNode);
                    this._addPortComponentDeploymentMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PORT_COMPONENT_IMPLEMENTOR_MENU_STRING)) {
                PortComponentImplementorType newPortComponentImplementor = this._bean.defaultPortComponentImplementor();
                if (this.showAddDialog(newPortComponentImplementor, ADD_PORT_COMPONENT_IMPLEMENTOR_MENU_STRING)) {
                    this._bean.setPortComponentImplementor(newPortComponentImplementor);
                    PortComponentImplementorTreeNode newNode = new PortComponentImplementorTreeNode(this, newPortComponentImplementor);
                    this.insertNode(newNode);
                    this._addPortComponentImplementorMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_RUNTIME_MENU_STRING)) {
                ServerPortRuntimeType newRuntime = this._bean.defaultRuntime();
                if (this.showAddDialog(newRuntime, ADD_RUNTIME_MENU_STRING)) {
                    this._bean.setRuntime(newRuntime);
                    ServerPortRuntimeTreeNode newNode = new ServerPortRuntimeTreeNode(this, newRuntime);
                    this.insertNode(newNode);
                    this._addRuntimeMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_JMS_ADDRESS_MENU_STRING)) {
                JmsAddressType newJmsAddress = this._bean.defaultJmsAddress();
                if (this.showAddDialog(newJmsAddress, ADD_JMS_ADDRESS_MENU_STRING)) {
                    this._bean.setJmsAddress(newJmsAddress);
                    JmsAddressTreeNode newNode = new JmsAddressTreeNode(this, newJmsAddress);
                    this.insertNode(newNode);
                    this._addJmsAddressMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_EJB_TRANSPORT_SECURITY_CONSTRAINT_MENU_STRING) && this.showAddDialog(newEjbTransportSecurityConstraint = this._bean.defaultEjbTransportSecurityConstraint(), ADD_EJB_TRANSPORT_SECURITY_CONSTRAINT_MENU_STRING)) {
                this._bean.setEjbTransportSecurityConstraint(newEjbTransportSecurityConstraint);
                EjbTransportSecurityConstraintTreeNode newNode = new EjbTransportSecurityConstraintTreeNode(this, newEjbTransportSecurityConstraint);
                this.insertNode(newNode);
                this._addEjbTransportSecurityConstraintMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PortComponentDeploymentTreeNode) {
            this._bean.removePortComponentDeployment();
            this.removeNode(node);
            this._addPortComponentDeploymentMenuItem.setEnabled(true);
        } else if (node instanceof PortComponentImplementorTreeNode) {
            this._bean.removePortComponentImplementor();
            this.removeNode(node);
            this._addPortComponentImplementorMenuItem.setEnabled(true);
        } else if (node instanceof ServerPortRuntimeTreeNode) {
            this._bean.removeRuntime();
            this.removeNode(node);
            this._addRuntimeMenuItem.setEnabled(true);
        } else if (node instanceof JmsAddressTreeNode) {
            this._bean.removeJmsAddress();
            this.removeNode(node);
            this._addJmsAddressMenuItem.setEnabled(true);
        } else if (node instanceof EjbTransportSecurityConstraintTreeNode) {
            this._bean.removeEjbTransportSecurityConstraint();
            this.removeNode(node);
            this._addEjbTransportSecurityConstraintMenuItem.setEnabled(true);
        }
    }
}

