/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrincipalMappingInterfaceType
extends ConfigBeanNode {
    String _implClass = null;
    PropertyConfigBean[] _properties = null;

    public PrincipalMappingInterfaceType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public PrincipalMappingInterfaceType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setImplClass(String implClass) throws ConfigurationException {
        String oldValue = this._implClass;
        this._implClass = implClass;
        this.firePropertyChange("implClass", oldValue, this._implClass);
    }

    public String getImplClass() {
        return this._implClass;
    }

    public String defaultImplClass() {
        return "";
    }

    public void setProperties(PropertyConfigBean[] properties) {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        return properties;
    }

    public void addProperties() {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "principal-mapping-interface");
        XMLUtils.writeTagAttributeEnd(out, indentation, "principal-mapping-interface");
        if (this._implClass != null && this._implClass.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "impl-class", this._implClass);
        }
        if (this._properties != null && this._properties.length > 0) {
            PrincipalMappingInterfaceType.writeXML(out, indentation + "\t", this._properties);
        }
        XMLUtils.writeTagEnd(out, indentation, "principal-mapping-interface");
    }

    private void init() {
        this.setXpath("principal-mapping-interface");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("impl-class")) {
                    this._implClass = XMLUtils.getValue(node);
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean property = new PropertyConfigBean(this, node);
                properties.add(property);
            }
        }
        this._properties = properties.toArray(new PropertyConfigBean[0]);
    }
}

