/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPortType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPropertiesTreeNode;

public class ProviderPortTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ProviderPortType _bean;
    private static final String REMOVE_PROVIDER_PORT_MENU_STRING = "Remove Provider Port";
    private JMenuItem _removeProviderPortMenuItem;

    public ProviderPortTreeNode(ConfigTreeNode rootNode, ProviderPortType providerPort) {
        super(providerPort);
        this.setRootNode(rootNode);
        this._bean = providerPort;
        this._removeProviderPortMenuItem = new JMenuItem(REMOVE_PROVIDER_PORT_MENU_STRING);
        this._removeProviderPortMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeProviderPortMenuItem.setFont(ProviderPortTreeNode.getFont());
        this._removeProviderPortMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeProviderPortMenuItem);
    }

    public String viewHeaderString() {
        return "Provider Port";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = ProviderPortType.class.getMethod("writePropertiesXML", PrintWriter.class, String.class);
            ProviderPropertiesTreeNode providerPropertiesTreeNode = new ProviderPropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(providerPropertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_PROVIDER_PORT_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

