/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.model.xml.SecurityPermissionBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.DeplManager;
import oracle.oc4j.admin.deploy.spi.xml.AdminObjectType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanRootNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.RarModuleConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.RarModuleSAConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RarDepXml
extends ConfigBeanRootNode {
    static final int UNDEFINED_STARTORDER = Integer.MAX_VALUE;
    private String path;
    private String name;
    private String nativeLibraryPath;
    private int startOrder = Integer.MAX_VALUE;
    private List securityPermissions;
    private List configurationProperties;
    private List adminObjectInstances;

    public RarDepXml(String moduleId, DDBean stdBean, DeplManager mgr, ConfigBeanRootNode rootParent) {
        super(moduleId, stdBean, mgr, rootParent);
    }

    public RarDepXml(String moduleId, Node node, DeplManager mgr, ConfigBeanRootNode rootParent) {
        super(moduleId, null, node, mgr, rootParent);
    }

    public void writeConfig(PrintWriter out) throws ExtendedRuntimeException {
        if (this._module != null && !this.dontSaveConfiguration()) {
            out.println("moduleID=" + this._moduleId);
            out.println("doctype=oc4j-connector-factories");
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writeXML(out, "");
            if (this.path != null) {
                out.println("moduleID=oc4j-connectors");
                out.println("doctype=connector");
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.writeConnectorXML(out, "");
            }
        }
    }

    public String getDepXmlPath() {
        return "META-INF/oc4j-ra.xml";
    }

    public void init() throws ConfigurationException {
        this.setXpath("/");
        this._xpaths = new String[1];
        this._xpaths[0] = "connector";
        this._configXpaths = new String[1];
        this._configXpaths[0] = "oc4j-connector-factories";
        Vector<ConfigBeanNode> v = new Vector<ConfigBeanNode>(1);
        if (this.getNode() != null) {
            Node factories = XMLUtils.getChild(this.getNode(), "oc4j-connector-factories");
            if (factories == null && this.getNode().getNodeName().equals("oc4j-connector-factories")) {
                factories = this.getNode();
            }
            this._module = this.isEmbedded() ? new RarModuleConfigBean(this, factories) : new RarModuleSAConfigBean(this, factories);
            Node connector = XMLUtils.getChild(this.getNode(), "connector");
            this.initConnectorAttributes(connector);
        } else {
            this._module = this.isEmbedded() ? new RarModuleConfigBean(this, null) : new RarModuleSAConfigBean(this, null);
        }
        v.add(this._module);
        this.recordXpathForBeans("oc4j-connector-factories", v);
    }

    private void initConnectorAttributes(Node parent) {
        if (parent == null) {
            return;
        }
        this.path = XMLUtils.getAttribute(parent, "path");
        this.name = XMLUtils.getAttribute(parent, "name");
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.equals("native-library")) {
                    this.nativeLibraryPath = XMLUtils.getValue(node);
                    continue;
                }
                if (nodeName.equals("security-permission")) {
                    this.addSecurityPermission(new SecurityPermissionBean(node, this.getDDBean()));
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addConfigurationProperty(new ConfigPropertyType(this, node));
                    continue;
                }
                if (nodeName.equals("adminobject-config")) {
                    this.addAdminObjectInstance(new AdminObjectType(this, node));
                    continue;
                }
                if (!nodeName.equals("start-order")) continue;
                this.startOrder = Integer.parseInt(XMLUtils.getValue(node));
            }
        }
    }

    private void writeConnectorXML(PrintWriter out, String indention) {
        Iterator iter;
        XMLUtils.writeTagAttributeStart(out, indention, "connector");
        if (this.name != null) {
            XMLUtils.writeAttribute(out, indention, "name", this.name);
        }
        if (this.path != null) {
            XMLUtils.writeAttribute(out, indention, "path", this.path);
        }
        XMLUtils.writeTagAttributeEnd(out, indention, "connector");
        if (this.startOrder != Integer.MAX_VALUE) {
            XMLUtils.writeTag(out, indention + "\t", "start-order", Integer.toString(this.startOrder));
        }
        if (this.nativeLibraryPath != null) {
            XMLUtils.writeTag(out, indention + "\t", "native-library", XMLUtils.encode(this.nativeLibraryPath));
        }
        if (this.securityPermissions != null) {
            iter = this.securityPermissions.iterator();
            while (iter.hasNext()) {
                SecurityPermissionBean permission = (SecurityPermissionBean)iter.next();
                permission.writeXML(out, indention + "\t");
            }
        }
        if (this.configurationProperties != null) {
            iter = this.configurationProperties.iterator();
            while (iter.hasNext()) {
                ConfigPropertyType config = (ConfigPropertyType)iter.next();
                config.writeXML(out, indention + "\t");
            }
            if (this.adminObjectInstances != null) {
                iter = this.adminObjectInstances.iterator();
                while (iter.hasNext()) {
                    AdminObjectType adm = (AdminObjectType)iter.next();
                    adm.writeXML(out, indention + "\t");
                }
            }
        }
        XMLUtils.writeTagEnd(out, indention, "connector");
    }

    private void addSecurityPermission(SecurityPermissionBean permission) {
        if (this.securityPermissions == null) {
            this.securityPermissions = new ArrayList();
        }
        this.securityPermissions.add(permission);
    }

    private void addConfigurationProperty(ConfigPropertyType property) {
        if (this.configurationProperties == null) {
            this.configurationProperties = new ArrayList();
        }
        this.configurationProperties.add(property);
    }

    private void addAdminObjectInstance(AdminObjectType adm) {
        if (this.adminObjectInstances == null) {
            this.adminObjectInstances = new ArrayList();
        }
        this.adminObjectInstances.add(adm);
    }
}

