/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.InitParamsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.SerializerType;

public class SerializerTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SerializerType _bean;
    private static final String REMOVE_SERIALIZER_MENU_STRING = "Remove Serializer";
    private JMenuItem _removeSerializerMenuItem;

    public SerializerTreeNode(ConfigTreeNode rootNode, SerializerType serializer) {
        super(serializer);
        this.setRootNode(rootNode);
        this._bean = serializer;
        this._removeSerializerMenuItem = new JMenuItem(REMOVE_SERIALIZER_MENU_STRING);
        this._removeSerializerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSerializerMenuItem.setFont(SerializerTreeNode.getFont());
        this._removeSerializerMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeSerializerMenuItem);
    }

    public String viewHeaderString() {
        return "Serializer";
    }

    public String toString() {
        return this._bean.getClassName();
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = SerializerType.class.getMethod("writeInitParamsXML", PrintWriter.class, String.class);
            InitParamsTreeNode initParamsTreeNode = new InitParamsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(initParamsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_SERIALIZER_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

