/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignatureConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TimestampConfigType;
import oracle.oc4j.admin.deploy.spi.xml.TimestampTreeNode;

public class SignatureTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SignatureConfigType _bean;
    private static final String ADD_SIGNATURE_METHOD_MENU_STRING = "Add Signature Method";
    private static final String ADD_TBS_ELEMENTS_MENU_STRING = "Add Tbs Elements";
    private static final String ADD_TIMESTAMP_TEXT = "Add Timestamp";
    private static final String ADD_ADD_TIMESTAMP_MENU_STRING = "Add Add Timestamp";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_SIGNATURE_MENU_STRING = "Remove Signature";
    private JMenuItem _addSignatureMethodMenuItem;
    private JMenuItem _addTbsElementsMenuItem;
    private JMenuItem _addAddTimestampMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeSignatureMenuItem;

    public SignatureTreeNode(ConfigTreeNode rootNode, SignatureConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addSignatureMethodMenuItem = new JMenuItem(ADD_SIGNATURE_METHOD_MENU_STRING);
        this._addSignatureMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSignatureMethodMenuItem.setFont(SignatureTreeNode.getFont());
        this._addSignatureMethodMenuItem.addActionListener(this);
        if (this._bean.getSignatureMethod() != null) {
            this._addSignatureMethodMenuItem.setEnabled(false);
        }
        this._addTbsElementsMenuItem = new JMenuItem(ADD_TBS_ELEMENTS_MENU_STRING);
        this._addTbsElementsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTbsElementsMenuItem.setFont(SignatureTreeNode.getFont());
        this._addTbsElementsMenuItem.addActionListener(this);
        if (this._bean.getTbsElements() != null) {
            this._addTbsElementsMenuItem.setEnabled(false);
        }
        this._addAddTimestampMenuItem = new JMenuItem(ADD_ADD_TIMESTAMP_MENU_STRING);
        this._addAddTimestampMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addAddTimestampMenuItem.setFont(SignatureTreeNode.getFont());
        this._addAddTimestampMenuItem.addActionListener(this);
        if (this._bean.getAddTimestamp() != null) {
            this._addAddTimestampMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(SignatureTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeSignatureMenuItem = new JMenuItem(REMOVE_SIGNATURE_MENU_STRING);
        this._removeSignatureMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSignatureMenuItem.setFont(SignatureTreeNode.getFont());
        this._removeSignatureMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addSignatureMethodMenuItem);
        this._popup.add(this._addTbsElementsMenuItem);
        this._popup.add(this._addAddTimestampMenuItem);
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeSignatureMenuItem);
    }

    public String viewHeaderString() {
        return "Signature";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties;
        TimestampConfigType addTimestamp;
        SignElementsConfigType tbsElements;
        SignatureMethodConfigType signatureMethod = this._bean.getSignatureMethod();
        if (signatureMethod != null) {
            SignatureMethodTreeNode signatureMethodTreeNode = new SignatureMethodTreeNode(this.getRootNode(), signatureMethod);
            this.addChild(signatureMethodTreeNode);
        }
        if ((tbsElements = this._bean.getTbsElements()) != null) {
            SignElementsTreeNode tbsElementsTreeNode = new SignElementsTreeNode(this.getRootNode(), tbsElements);
            this.addChild(tbsElementsTreeNode);
        }
        if ((addTimestamp = this._bean.getAddTimestamp()) != null) {
            TimestampTreeNode addTimestampTreeNode = new TimestampTreeNode(this.getRootNode(), addTimestamp, ADD_TIMESTAMP_TEXT);
            this.addChild(addTimestampTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SIGNATURE_METHOD_MENU_STRING)) {
                SignatureMethodConfigType newSignatureMethod = this._bean.defaultSignatureMethod();
                if (this.showAddDialog(newSignatureMethod, ADD_SIGNATURE_METHOD_MENU_STRING)) {
                    this._bean.setSignatureMethod(newSignatureMethod);
                    SignatureMethodTreeNode newNode = new SignatureMethodTreeNode(this, newSignatureMethod);
                    this.insertNode(newNode);
                    this._addSignatureMethodMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_TBS_ELEMENTS_MENU_STRING)) {
                if (this._bean.getTbsElements() == null) {
                    this._bean.addTbsElements();
                    SignElementsTreeNode newNode = new SignElementsTreeNode(this, this._bean.getTbsElements());
                    this.insertNode(newNode);
                    this._addTbsElementsMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_ADD_TIMESTAMP_MENU_STRING)) {
                TimestampConfigType newAddTimestamp = this._bean.defaultAddTimestamp();
                if (this.showAddDialog(newAddTimestamp, ADD_ADD_TIMESTAMP_MENU_STRING)) {
                    this._bean.setAddTimestamp(newAddTimestamp);
                    TimestampTreeNode newNode = new TimestampTreeNode(this, newAddTimestamp, ADD_TIMESTAMP_TEXT);
                    this.insertNode(newNode);
                    this._addAddTimestampMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_SIGNATURE_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SignatureMethodTreeNode) {
            this._bean.removeSignatureMethod();
            this.removeNode(node);
            this._addSignatureMethodMenuItem.setEnabled(true);
        } else if (node instanceof SignElementsTreeNode) {
            this._bean.removeTbsElements();
            this.removeNode(node);
            this._addTbsElementsMenuItem.setEnabled(true);
        } else if (node instanceof TimestampTreeNode) {
            this._bean.removeAddTimestamp();
            this.removeNode(node);
            this._addAddTimestampMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

