/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagLibType
extends ConfigBeanNode {
    String taglibUri;
    String taglibLocation;

    public TagLibType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("taglib");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("taglib-uri")) {
                    this.taglibUri = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("taglib-location")) continue;
                this.taglibLocation = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "taglib");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "taglib-uri", this.taglibUri);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "taglib-location", this.taglibLocation);
        XMLUtils.writeTagEnd(out, indentation, "taglib");
    }

    public String getTaglibLocation() {
        return this.taglibLocation;
    }

    public String getTaglibUri() {
        return this.taglibUri;
    }
}

