/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransportConfigType
extends ConfigBeanNode {
    StringType _integrity = null;
    StringType _oldIntegrity = null;
    StringType _confidentiality = null;
    StringType _oldConfidentiality = null;
    StringType _establishTrustInTarget = null;
    StringType _oldEstablishTrustInTarget = null;
    StringType _establishTrustInClient = null;
    StringType _oldEstablishTrustInClient = null;

    public TransportConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public TransportConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setIntegrity(StringType integrity) {
        this._integrity = integrity;
        this.firePropertyChange("integrity", this._oldIntegrity, this._integrity);
        if (this._integrity != null) {
            if (this._oldIntegrity == null) {
                this._oldIntegrity = this.defaultIntegrity();
            }
            this._oldIntegrity.setValue(this._integrity.getValue());
        } else {
            this._oldIntegrity = null;
        }
    }

    public StringType getIntegrity() {
        return this._integrity;
    }

    public StringType defaultIntegrity() {
        String[] tags = new String[]{"none", "supported", "required"};
        return new StringType(this, tags, "supported");
    }

    public void setConfidentiality(StringType confidentiality) {
        this._confidentiality = confidentiality;
        this.firePropertyChange("confidentiality", this._oldConfidentiality, this._confidentiality);
        if (this._confidentiality != null) {
            if (this._oldConfidentiality == null) {
                this._oldConfidentiality = this.defaultConfidentiality();
            }
            this._oldConfidentiality.setValue(this._confidentiality.getValue());
        } else {
            this._oldConfidentiality = null;
        }
    }

    public StringType getConfidentiality() {
        return this._confidentiality;
    }

    public StringType defaultConfidentiality() {
        String[] tags = new String[]{"none", "supported", "required"};
        return new StringType(this, tags, "supported");
    }

    public void setEstablishTrustInTarget(StringType establishTrustInTarget) {
        this._establishTrustInTarget = establishTrustInTarget;
        this.firePropertyChange("establishTrustInTarget", this._oldEstablishTrustInTarget, this._establishTrustInTarget);
        if (this._establishTrustInTarget != null) {
            if (this._oldEstablishTrustInTarget == null) {
                this._oldEstablishTrustInTarget = this.defaultEstablishTrustInTarget();
            }
            this._oldEstablishTrustInTarget.setValue(this._establishTrustInTarget.getValue());
        } else {
            this._oldEstablishTrustInTarget = null;
        }
    }

    public StringType getEstablishTrustInTarget() {
        return this._establishTrustInTarget;
    }

    public StringType defaultEstablishTrustInTarget() {
        String[] tags = new String[]{"none", "supported"};
        return new StringType(this, tags, "supported");
    }

    public void setEstablishTrustInClient(StringType establishTrustInClient) {
        this._establishTrustInClient = establishTrustInClient;
        this.firePropertyChange("establishTrustInClient", this._oldEstablishTrustInClient, this._establishTrustInClient);
        if (this._establishTrustInClient != null) {
            if (this._oldEstablishTrustInClient == null) {
                this._oldEstablishTrustInClient = this.defaultEstablishTrustInClient();
            }
            this._oldEstablishTrustInClient.setValue(this._establishTrustInClient.getValue());
        } else {
            this._oldEstablishTrustInClient = null;
        }
    }

    public StringType getEstablishTrustInClient() {
        return this._establishTrustInClient;
    }

    public StringType defaultEstablishTrustInClient() {
        String[] tags = new String[]{"none", "supported", "required"};
        return new StringType(this, tags, "supported");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "transport-config");
        XMLUtils.writeTagAttributeEnd(out, indentation, "transport-config");
        if (this._integrity != null && this._integrity.getValue() != null && this._integrity.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "integrity", this._integrity);
        }
        if (this._confidentiality != null && this._confidentiality.getValue() != null && this._confidentiality.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "confidentiality", this._confidentiality);
        }
        if (this._establishTrustInTarget != null && this._establishTrustInTarget.getValue() != null && this._establishTrustInTarget.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "establish-trust-in-target", this._establishTrustInTarget);
        }
        if (this._establishTrustInClient != null && this._establishTrustInClient.getValue() != null && this._establishTrustInClient.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "establish-trust-in-client", this._establishTrustInClient);
        }
        XMLUtils.writeTagEnd(out, indentation, "transport-config");
    }

    private void init() throws ConfigurationException {
        this.setXpath("transport-config");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("integrity")) {
                    StringType integrity = this.defaultIntegrity();
                    integrity.setValue(XMLUtils.getValue(node));
                    this.setIntegrity(integrity);
                    continue;
                }
                if (name.equals("confidentiality")) {
                    StringType confidentiality = this.defaultConfidentiality();
                    confidentiality.setValue(XMLUtils.getValue(node));
                    this.setConfidentiality(confidentiality);
                    continue;
                }
                if (name.equals("establish-trust-in-target")) {
                    StringType establishTrustInTarget = this.defaultEstablishTrustInTarget();
                    establishTrustInTarget.setValue(XMLUtils.getValue(node));
                    this.setEstablishTrustInTarget(establishTrustInTarget);
                    continue;
                }
                if (!name.equals("establish-trust-in-client")) continue;
                StringType establishTrustInClient = this.defaultEstablishTrustInClient();
                establishTrustInClient.setValue(XMLUtils.getValue(node));
                this.setEstablishTrustInClient(establishTrustInClient);
            }
        }
    }
}

