/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserManagerConfigBean
extends ConfigBeanNode {
    String _className = null;
    String _displayName = null;
    String _description = null;
    PropertyConfigBean[] _properties = null;

    public UserManagerConfigBean(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setClassName(String className) throws ConfigurationException {
        String oldValue = this._className;
        this._className = className;
        this.firePropertyChange("className", oldValue, this._className);
    }

    public String getClassName() {
        return this._className;
    }

    public String defaultClassName() {
        return "";
    }

    public void setDisplayName(String displayName) throws ConfigurationException {
        String oldValue = this._displayName;
        this._displayName = displayName;
        this.firePropertyChange("displayName", oldValue, this._displayName);
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String defaultDisplayName() {
        return "";
    }

    public void setDescription(String description) throws ConfigurationException {
        String oldValue = this._description;
        this._description = description;
        this.firePropertyChange("description", oldValue, this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public String defaultDescription() {
        return "";
    }

    public void setProperties(PropertyConfigBean[] properties) {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("className") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "user-manager");
        XMLUtils.writeAttribute(out, indentation, "class", this._className);
        XMLUtils.writeAttribute(out, indentation, "display-name", this._displayName);
        XMLUtils.writeTagAttributeEnd(out, indentation, "user-manager");
        XMLUtils.writeTag(out, indentation + "\t", "description", this._description);
        UserManagerConfigBean.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "user-manager");
    }

    private void init() {
        this.setXpath("user-manager");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "class");
            if (val != null && !val.trim().equals("")) {
                this._className = val;
            }
            if ((val = XMLUtils.getAttribute(node, "display-name")) != null && !val.trim().equals("")) {
                this._displayName = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("description")) {
                    val = XMLUtils.getValue(node);
                    if (val == null || val.trim().equals("")) continue;
                    this._description = val;
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this._properties = properties.toArray(new PropertyConfigBean[0]);
        }
    }
}

