/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ValueTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ValueType;

public class ValuesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_VALUE_MENU_STRING = "Add Value";
    private JMenuItem _addValueMenuItem;
    private ValueType[] valuesType = new ValueType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ValuesTreeNode(ConfigTreeNode rootNode, MultipleType values) {
        super(values);
        this.setRootNode(rootNode);
        this._parentBean = values.getConfigParent();
        this._addValueMenuItem = new JMenuItem(ADD_VALUE_MENU_STRING);
        this._addValueMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addValueMenuItem.setFont(ValuesTreeNode.getFont());
        this._addValueMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addValueMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getValues", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addValue", ValueType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeValue", ValueType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Values";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ValueType[] values = (ValueType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    ValueType value = values[i];
                    if (value == null) continue;
                    ValueTreeNode valueTreeNode = new ValueTreeNode(this.getRootNode(), value);
                    this.addChild(valueTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ValueType newValue;
            if (event.getActionCommand().equals(ADD_VALUE_MENU_STRING) && this.showAddDialog(newValue = new ValueType(this._parentBean), ADD_VALUE_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newValue);
                ValueTreeNode newNode = new ValueTreeNode(this, newValue);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ValueTreeNode) {
            try {
                ValueType value = (ValueType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, value);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

