/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebInitParamType
extends ConfigBeanNode {
    String description;
    String paramName;
    String paramValue;

    public WebInitParamType(ConfigBeanNode parent, Node node) {
        this(null, parent, node);
    }

    public WebInitParamType(DDBean stdBean, ConfigBeanNode parent, Node node) {
        super(stdBean, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("init-param");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("param-name")) {
                    this.paramName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("param-value")) continue;
                this.paramValue = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "init-param");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "param-name", this.paramName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "param-value", this.paramValue);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagEnd(out, indentation, "init-param");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }
}

