/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebResourceCollectionType
extends ConfigBeanNode {
    String webResourceName;
    String description;
    String urlPattern;
    String httpMethod;

    public WebResourceCollectionType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("web-resource-collection");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("web-resource-name")) {
                    this.webResourceName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("url-pattern")) {
                    this.urlPattern = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("http-method")) continue;
                this.httpMethod = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "web-resource-collection");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "web-resource-name", this.webResourceName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "url-pattern", this.urlPattern);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "http-method", this.httpMethod);
        XMLUtils.writeTagEnd(out, indentation + "\t", "web-resource-collection");
    }

    public String getDescription() {
        return this.description;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public String getWebResourceName() {
        return this.webResourceName;
    }
}

