/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.ArrayList;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WelcomeFileListType
extends ConfigBeanNode {
    String[] welcomeFiles;

    public WelcomeFileListType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("welcome-file-list");
        Node node = this.getNode();
        ArrayList<String> welcomeFileList = new ArrayList<String>();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (!nodeName.equals("welcome-file")) continue;
                welcomeFileList.add(XMLUtils.getValue(childNodes.item(i)));
            }
        }
        if (welcomeFileList.size() != 0) {
            this.welcomeFiles = welcomeFileList.toArray(new String[0]);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this.welcomeFiles != null && this.welcomeFiles.length != 0) {
            XMLUtils.writeTagStart(out, indentation, "welcome-file-list");
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                XMLUtils.writeTagWithValue(out, indentation + "\t", "welcome-file", this.welcomeFiles[i]);
            }
            XMLUtils.writeTagEnd(out, indentation, "welcome-file-list");
        }
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }
}

