/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PasswordCredentialType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XaRecoveryConfigType
extends ConfigBeanNode {
    PasswordCredentialType[] _passwordCredentials = null;

    public XaRecoveryConfigType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public XaRecoveryConfigType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setPasswordCredentials(PasswordCredentialType[] passwordCredentials) {
        this._passwordCredentials = passwordCredentials;
    }

    public PasswordCredentialType[] getPasswordCredentials() {
        return this._passwordCredentials;
    }

    public PasswordCredentialType[] defaultPasswordCredentials() {
        PasswordCredentialType[] passwordCredentials = new PasswordCredentialType[]{new PasswordCredentialType(this, null)};
        return passwordCredentials;
    }

    public void addPasswordCredentials() {
        if (this._passwordCredentials != null) {
            return;
        }
        PasswordCredentialType[] passwordCredentials = new PasswordCredentialType[]{new PasswordCredentialType(this, null)};
        this.setPasswordCredentials(passwordCredentials);
    }

    public void removePasswordCredentials() {
        if (this._passwordCredentials == null) {
            return;
        }
        this.setPasswordCredentials(null);
    }

    public void addPasswordCredential(PasswordCredentialType passwordCredential) {
        passwordCredential.setParent(this);
        int existingPasswordCredentialsCnt = 0;
        if (this._passwordCredentials != null) {
            existingPasswordCredentialsCnt = this._passwordCredentials.length;
        }
        PasswordCredentialType[] newPasswordCredentials = new PasswordCredentialType[existingPasswordCredentialsCnt + 1];
        for (int n = 0; n < existingPasswordCredentialsCnt; ++n) {
            newPasswordCredentials[n] = this._passwordCredentials[n];
        }
        newPasswordCredentials[existingPasswordCredentialsCnt] = passwordCredential;
        PasswordCredentialType[] oldValue = this._passwordCredentials;
        this._passwordCredentials = newPasswordCredentials;
        this.firePropertyChange("passwordCredentials", oldValue, this._passwordCredentials);
    }

    public void removePasswordCredential(PasswordCredentialType passwordCredential) {
        int existingPasswordCredentialsCnt = 0;
        if (this._passwordCredentials != null) {
            existingPasswordCredentialsCnt = this._passwordCredentials.length;
        }
        PasswordCredentialType[] newPasswordCredentials = new PasswordCredentialType[existingPasswordCredentialsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPasswordCredentialsCnt; ++n) {
            if (passwordCredential.equals(this._passwordCredentials[n])) continue;
            newPasswordCredentials[newIndex++] = this._passwordCredentials[n];
        }
        if (newPasswordCredentials.length == 0) {
            newPasswordCredentials = null;
        }
        PasswordCredentialType[] oldValue = this._passwordCredentials;
        this._passwordCredentials = newPasswordCredentials;
        this.firePropertyChange("passwordCredentials", oldValue, this._passwordCredentials);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "xa-recovery-config");
        XMLUtils.writeTagAttributeEnd(out, indentation, "xa-recovery-config");
        XaRecoveryConfigType.writeXML(out, indentation + "\t", this._passwordCredentials);
        XMLUtils.writeTagEnd(out, indentation, "xa-recovery-config");
    }

    public void writePasswordCredentialsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XaRecoveryConfigType.writeXML(out, indentation + "\t", this._passwordCredentials);
    }

    private void init() {
        this.setXpath("xa-recovery-config");
        Vector<PasswordCredentialType> passwordCredentials = new Vector<PasswordCredentialType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("password-credential")) continue;
                PasswordCredentialType configBean = new PasswordCredentialType(this, node);
                passwordCredentials.add(configBean);
            }
        }
        if (passwordCredentials.size() > 0) {
            this._passwordCredentials = passwordCredentials.toArray(new PasswordCredentialType[0]);
        }
    }
}

