/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import com.evermind.server.ApplicationContext;
import com.evermind.server.rmi.RMIConnectionException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.client.EventManager;
import oracle.oc4j.admin.jmx.client.HeartBeatListener;
import oracle.oc4j.admin.jmx.client.HeartBeatManager;
import oracle.oc4j.admin.jmx.client.ListenerIdManager;
import oracle.oc4j.admin.jmx.client.MBeanServerEjbRemoteSynchronizer;
import oracle.oc4j.admin.jmx.ejb.MBeanServerEjbHome;
import oracle.oc4j.admin.jmx.ejb.MBeanServerEjbRemote;
import oracle.oc4j.admin.jmx.remote.api.JMXConnectorConstant;
import oracle.oc4j.admin.jmx.shared.Oc4jRmiDomain;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;
import oracle.oc4j.admin.jmx.shared.RmiDomain;
import oracle.oc4j.admin.jmx.shared.exceptions.InternalException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class CoreRemoteMBeanServer {
    private static Logger logger_ = TraceLogger.getLogger((Class)CoreRemoteMBeanServer.class);
    private MBeanServerEjbRemote MBeanServerEjbRemote_ = null;
    private Context remoteOc4jContext_ = null;
    private RmiDomain domain_ = null;
    private EventManager eventManager_ = null;
    private HeartBeatManager heartBeatManager_ = null;
    private static final String application_client_xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE application-client PUBLIC '-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN' 'http://java.sun.com/dtd/application-client_1_3.dtd'>\n\n<application-client>\n<display-name>JSR 77/88/JMX application client</display-name>\n<description>provide a naming context to access admin EJBs</description>\n\n<ejb-ref>\n<ejb-ref-name>MBeanServerEjb</ejb-ref-name>\n<ejb-ref-type>Session</ejb-ref-type>\n<home>oracle.oc4j.admin.jmx.ejb.MBeanServerEjbHome</home>\n<remote>oracle.oc4j.admin.jmx.ejb.MBeanServerEjbRemote</remote>\n<ejb-link>MBeanServerEjb</ejb-link>\n</ejb-ref>\n\n<ejb-ref>\n<ejb-ref-name>MBeanServerUserEjb</ejb-ref-name><ejb-ref-type>Session</ejb-ref-type>\n<home>oracle.oc4j.admin.jmx.ejb.MBeanServerEjbHome</home>\n<remote>oracle.oc4j.admin.jmx.ejb.MBeanServerEjbRemote</remote>\n<ejb-link>MBeanServerUserEjb</ejb-link></ejb-ref>\n</application-client>";
    private int portInUse_ = -1;
    private Throwable failedConnection_ = null;

    protected CoreRemoteMBeanServer(RmiDomain domain) {
        this.domain_ = domain;
        this.fetchMBeanServerEjbRemote();
        this.heartBeatManager_ = new HeartBeatManager(this);
    }

    protected CoreRemoteMBeanServer(Context ctx) {
        this.domain_ = new Oc4jRmiDomain("localhost", 0);
        this.fetchLocalMBeanServerEjbRemote(ctx);
        this.heartBeatManager_ = new HeartBeatManager(this);
    }

    public void release() {
        block10: {
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("call release on CoreRemoteMBeanServer: " + this);
            }
            try {
                if (this.heartBeatManager_.isStarted()) {
                    this.heartBeatManager_.stop();
                }
                if (this.heartBeatManager_.isConnectionAlive()) {
                    if (this.eventManager_ != null && this.eventManager_.isStarted()) {
                        this.eventManager_.stopAndWait();
                        this.eventManager_ = null;
                    }
                    if (this.MBeanServerEjbRemote_ != null) {
                        if (logger_.isLoggable(Level.FINE)) {
                            logger_.fine("Call remove on MBeanServer EJB");
                        }
                        this.MBeanServerEjbRemote_.remove();
                        this.MBeanServerEjbRemote_ = null;
                    }
                    if (this.remoteOc4jContext_ != null) {
                        if (logger_.isLoggable(Level.FINE)) {
                            logger_.fine("Call close on RMI Context: " + this.remoteOc4jContext_);
                        }
                        this.remoteOc4jContext_.close();
                        this.remoteOc4jContext_ = null;
                    }
                }
            }
            catch (Exception ex) {
                if (!logger_.isLoggable(Level.FINE)) break block10;
                logger_.log(Level.FINE, ex.getMessage(), ex);
            }
        }
    }

    public final RmiDomain getDomain() {
        return this.domain_;
    }

    protected final MBeanServerEjbRemote getMBeanServerProxy() {
        if (this.MBeanServerEjbRemote_ == null && logger_.isLoggable(Level.SEVERE)) {
            logger_.severe("Attempt being made to retrieve MBeanServer proxy after connection is closed.");
        }
        return this.MBeanServerEjbRemote_;
    }

    private final MBeanServerEjbRemote accessMBeanServerProxy() {
        return this.MBeanServerEjbRemote_;
    }

    protected final synchronized RemoteListenerId registerListener(NotificationListener listener) {
        RemoteListenerId id = ListenerIdManager.registerListener(listener, this.getDomain());
        if (this.eventManager_ == null) {
            this.eventManager_ = new EventManager(this);
            this.eventManager_.start();
        }
        return id;
    }

    public RemoteListenerId getListenerId(NotificationListener listener) {
        return ListenerIdManager.getListenerId(listener, this.getDomain());
    }

    protected final synchronized void unregisterListener(NotificationListener listener) {
        ListenerIdManager.unregisterListener(listener, this.getDomain());
        if (ListenerIdManager.getListenerCount(this.getDomain()) == 0 && this.eventManager_ != null) {
            this.eventManager_.stop();
            this.eventManager_ = null;
        }
    }

    public final List getEvents() {
        try {
            if (this.accessMBeanServerProxy() != null) {
                return this.accessMBeanServerProxy().getEvents();
            }
            return new ArrayList();
        }
        catch (RMIConnectionException e) {
            this.failedConnection_ = e;
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, "Could not retrieve remote events: " + e.getMessage(), e);
            }
            if (this.eventManager_ != null) {
                this.eventManager_.stop();
                this.eventManager_ = null;
            }
            return new ArrayList();
        }
        catch (RemoteException re) {
            this.failedConnection_ = re;
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, "Could not retrieve remote events: " + re.getMessage(), re);
            }
            if (this.eventManager_ != null) {
                this.eventManager_.stop();
                this.eventManager_ = null;
            }
            return new ArrayList();
        }
        catch (InternalException e) {
            this.failedConnection_ = e;
            throw new JMXRuntimeException(e.getOriginalException());
        }
    }

    public final void fireEvent(RemoteListenerId listenerId, Notification jmxEvent, Object handBack) {
        NotificationListener localListener;
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Dispatching event type: " + jmxEvent.getType() + " and message: " + jmxEvent.getMessage() + " to listener with id: " + listenerId + " on MBeanServer proxy: " + this);
        }
        if ((localListener = ListenerIdManager.getNotificationListener(listenerId, this.getDomain())) != null) {
            localListener.handleNotification(jmxEvent, handBack);
        }
    }

    public void ping() throws RemoteException {
        this.getMBeanServerProxy().ping();
    }

    public void setupTestEnvironment() throws RemoteException {
        this.getMBeanServerProxy().test();
    }

    public void addHeartBeatListener(HeartBeatListener listener) {
        this.heartBeatManager_.addHeartBeatListener(listener);
    }

    public void removeHeartBeatListener(HeartBeatListener listener) {
        this.heartBeatManager_.removeHeartBeatListener(listener);
    }

    private void fetchMBeanServerEjbRemote() {
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Getting remote RMI context for domain: " + this.domain_);
        }
        Hashtable<String, String> environment = new Hashtable<String, String>();
        String url = null;
        this.portInUse_ = this.domain_.getRmiPort();
        url = CoreRemoteMBeanServer.getOrmiUrl(this.domain_);
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("CoreRemoteMBeanServer url: " + url);
        }
        environment.put("java.naming.provider.url", url);
        if (this.domain_.getPrincipal() != null && this.domain_.getCredential() != null) {
            environment.put("java.naming.security.principal", this.domain_.getPrincipal());
            environment.put("java.naming.security.credentials", this.domain_.getCredential());
        }
        environment.put("java.naming.factory.initial", "com.evermind.server.ApplicationClientInitialContextFactory");
        environment.put("application-client.xml", application_client_xml);
        this.copyProperties(environment, this.domain_, JMXConnectorConstant.RMI_PROPERTIES);
        try {
            this.remoteOc4jContext_ = new InitialContext(environment);
            this.remoteOc4jContext_.removeFromEnvironment("java.naming.factory.url.pkgs");
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("JNDI root ctx: " + this.remoteOc4jContext_);
                logger_.fine("Getting MBeanServer EJB Home interface");
            }
            String ejbJNDIName = "java:comp/env/ejb/" + this.domain_.getEjbName();
            Object ejbHome = this.remoteOc4jContext_.lookup(ejbJNDIName);
            MBeanServerEjbHome home = (MBeanServerEjbHome)PortableRemoteObject.narrow((Object)ejbHome, (Class)MBeanServerEjbHome.class);
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Getting MBeanServer EJB Remote interface");
            }
            MBeanServerEjbRemote remote = home.create(this.domain_);
            MBeanServerEjbRemote ejbRemote = (MBeanServerEjbRemote)PortableRemoteObject.narrow((Object)remote, (Class)MBeanServerEjbRemote.class);
            this.MBeanServerEjbRemote_ = new MBeanServerEjbRemoteSynchronizer(ejbRemote);
        }
        catch (Throwable ex) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, ex.getMessage() + " for URL: " + url, ex);
            }
            throw new JMXRuntimeException(ex, "Error while getting remote MBeanServer for url: " + url);
        }
    }

    private void copyProperties(Hashtable environment, RmiDomain domain, String[] propertyNames) {
        if (propertyNames != null) {
            int propertyCount = propertyNames.length;
            for (int i = 0; i < propertyCount; ++i) {
                String propertyValue = (String)domain.getProperty(propertyNames[i]);
                if (propertyValue == null) continue;
                environment.put(propertyNames[i], propertyValue);
            }
        }
    }

    static String getOrmiUrl(RmiDomain domain) {
        String wireProtocol = (String)domain.getProperty("com.oracle.jmx.remote.oc4j.wireprotocol");
        if (domain.getHttpTunnelingPath() != null) {
            if ("https".equals(wireProtocol)) {
                String url = "ormi:https://" + domain.getHost() + ':' + domain.getRmiPort() + '/' + domain.getApplication();
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.warning("ORMI over HTTPS not currently supported as JMX connector protocol: " + url);
                }
                throw new JMXRuntimeException("ORMI over HTTPS not currently supported as JMX connector protocol: " + url);
            }
            return "ormi:http://" + domain.getHost() + ':' + domain.getRmiPort() + '/' + domain.getApplication();
        }
        if ("ormis".equals(wireProtocol)) {
            return "ormis://" + domain.getHost() + ':' + domain.getRmiPort() + "/" + domain.getApplication();
        }
        return "ormi://" + domain.getHost() + ':' + domain.getRmiPort() + "/" + domain.getApplication();
    }

    private void fetchLocalMBeanServerEjbRemote(Context ctx) {
        try {
            String ejbJNDIName = "ejb/" + this.domain_.getEjbName();
            if (ctx instanceof ApplicationContext) {
                ejbJNDIName = this.domain_.getEjbName();
            }
            Object ejbHome = ctx.lookup(ejbJNDIName);
            MBeanServerEjbHome home = (MBeanServerEjbHome)PortableRemoteObject.narrow((Object)ejbHome, (Class)MBeanServerEjbHome.class);
            MBeanServerEjbRemote remote = home.create(this.domain_);
            MBeanServerEjbRemote ejbRemote = (MBeanServerEjbRemote)PortableRemoteObject.narrow((Object)remote, (Class)MBeanServerEjbRemote.class);
            this.MBeanServerEjbRemote_ = new MBeanServerEjbRemoteSynchronizer(ejbRemote);
        }
        catch (Exception ex) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, ex.getMessage(), ex);
            }
            throw new JMXRuntimeException(ex, "Error while getting local MBeanServer EJB");
        }
    }

    protected final Serializable[] checkParametersAreSerializable(Object[] params) {
        if (params == null) {
            return null;
        }
        Serializable[] s = new Serializable[params.length];
        for (int i = 0; i < params.length; ++i) {
            try {
                s[i] = (Serializable)params[i];
                continue;
            }
            catch (ClassCastException ce) {
                throw new ClassCastException("Parameter number: " + i + " of type: " + params[i].getClass() + " does not implement the Serializable interface");
            }
        }
        return s;
    }

    public int portInUse() {
        return this.portInUse_;
    }

    public Throwable getFailedConnection() {
        return this.failedConnection_;
    }
}

