/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.oc4j.admin.jmx.client.ConfigurableThread;
import oracle.oc4j.admin.jmx.client.CoreRemoteMBeanServer;
import oracle.oc4j.admin.jmx.client.HeartBeatEvent;
import oracle.oc4j.admin.jmx.client.HeartBeatListener;
import oracle.oc4j.admin.jmx.client.ThreadPool;
import oracle.oc4j.admin.jmx.shared.Domain;

public class HeartBeatManager
implements Runnable {
    public static int interval_ = Integer.getInteger("oc4j.jmx.heartbeat.interval") != null ? Integer.getInteger("oc4j.jmx.heartbeat.interval") : 2000;
    private ConfigurableThread thread_ = null;
    private boolean stop_ = false;
    private boolean connectionAlive_ = true;
    private CoreRemoteMBeanServer coreMBeanServer_ = null;
    private List listeners_ = null;

    public HeartBeatManager(CoreRemoteMBeanServer coreMBeanServer) {
        this.coreMBeanServer_ = coreMBeanServer;
        this.listeners_ = new ArrayList();
    }

    public final Domain getDomain() {
        return this.coreMBeanServer_.getDomain();
    }

    public final boolean isConnectionAlive() {
        return this.connectionAlive_;
    }

    public final synchronized void start() {
        this.thread_ = ThreadPool.getThread();
        this.thread_.start(this);
        this.stop_ = false;
    }

    public final synchronized void stop() {
        if (this.thread_ != null) {
            this.stop_ = true;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.thread_ != null) {
                this.thread_.interruptCurrentRunnable();
                this.thread_ = null;
            }
        }
    }

    public final synchronized boolean isStarted() {
        return this.thread_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeartBeatListener(HeartBeatListener listener) {
        List list = this.listeners_;
        synchronized (list) {
            this.listeners_.add(listener);
            if (this.thread_ == null) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeartBeatListener(HeartBeatListener listener) {
        List list = this.listeners_;
        synchronized (list) {
            this.listeners_.remove(listener);
            if (this.listeners_.size() == 0 && this.thread_ != null) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setName("HeartBeatManager::" + this.getDomain().toString());
        try {
            while (!this.stop_) {
                this.coreMBeanServer_.ping();
                Thread.sleep(interval_);
                Thread.yield();
            }
        }
        catch (InterruptedException iex) {
        }
        catch (RemoteException re) {
            this.connectionAlive_ = false;
            HeartBeatEvent event = new HeartBeatEvent(this.getDomain());
            List list = this.listeners_;
            synchronized (list) {
                Iterator iter = this.listeners_.iterator();
                while (iter.hasNext()) {
                    HeartBeatListener listener = (HeartBeatListener)iter.next();
                    listener.handleEvent(event);
                }
            }
        }
        finally {
            this.thread_ = null;
            this.stop_ = false;
        }
    }
}

