/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebSiteBindings {
    public static Hashtable parseWebSiteBindings(String webSiteBindings) {
        String[] moduleBindings;
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        if (webSiteBindings != null && webSiteBindings.trim().length() > 0 && (moduleBindings = webSiteBindings.split(";")).length > 0) {
            for (int n = 0; n < moduleBindings.length; ++n) {
                if (moduleBindings[n] == null) continue;
                String[] moduleBinding = moduleBindings[n].split(":");
                String moduleName = null;
                String[] webSiteNames = null;
                if (moduleBinding[0] != null) {
                    moduleName = moduleBinding[0].trim();
                }
                if (moduleBinding.length > 1 && moduleBinding[1].trim().length() > 0) {
                    webSiteNames = moduleBinding[1].split(",");
                }
                if (moduleName == null || webSiteNames.length <= 0) continue;
                ret.put(moduleName, webSiteNames);
            }
        }
        return ret;
    }

    public static Hashtable translateWebSites(Map webSiteMap) {
        if (webSiteMap == null) {
            return null;
        }
        Hashtable<String, String[]> ret = new Hashtable<String, String[]>();
        Hashtable<String, ArrayList> invert = new Hashtable<String, ArrayList>();
        Set webSiteEntrySet = webSiteMap.entrySet();
        Iterator webSiteIt = webSiteEntrySet.iterator();
        while (webSiteIt.hasNext()) {
            Map.Entry webSiteEntry = webSiteIt.next();
            String webSiteName = (String)webSiteEntry.getKey();
            Map webModuleBindings = (Map)webSiteEntry.getValue();
            Set webModuleBindingsEntrySet = webModuleBindings.entrySet();
            Iterator webModuleBindingsIterator = webModuleBindingsEntrySet.iterator();
            while (webModuleBindingsIterator.hasNext()) {
                Map.Entry webModuleBindingEntry = webModuleBindingsIterator.next();
                String webModuleName = (String)webModuleBindingEntry.getKey();
                if (invert.get(webModuleName) == null) {
                    invert.put(webModuleName, new ArrayList());
                }
                ArrayList webSiteList = (ArrayList)invert.get(webModuleName);
                webSiteList.add(webSiteName);
                invert.put(webModuleName, webSiteList);
            }
        }
        Set invertEntrySet = invert.entrySet();
        Iterator invertIt = invertEntrySet.iterator();
        while (invertIt.hasNext()) {
            Map.Entry invertEntry = invertIt.next();
            String webModuleName = (String)invertEntry.getKey();
            ArrayList webSiteList = (ArrayList)invertEntry.getValue();
            String[] webSites = webSiteList.toArray(new String[0]);
            ret.put(webModuleName, webSites);
        }
        return ret;
    }

    public static String formatWebSiteBindings(Hashtable webSiteBindingNames) {
        StringBuffer buf = new StringBuffer();
        if (webSiteBindingNames != null) {
            Set values = webSiteBindingNames.entrySet();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String moduleName = (String)entry.getKey();
                String[] sites = (String[])entry.getValue();
                String moduleNameWithoutExt = moduleName.equals(".") ? "." : (moduleName.indexOf(".") > 0 ? moduleName.substring(0, moduleName.indexOf(".")) : moduleName);
                buf.append(moduleNameWithoutExt + ":");
                if (sites != null) {
                    for (int n = 0; n < sites.length; ++n) {
                        buf.append(sites[n]);
                        if (sites.length <= 1 || n >= sites.length - 1) continue;
                        buf.append(",");
                    }
                }
                if (!it.hasNext()) continue;
                buf.append(";");
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

