/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic;

import java.util.Date;
import java.util.Locale;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.StateIntf;
import oracle.dms.spy.Spy;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolMetricCallBackIf;
import oracle.oc4j.admin.management.shared.statistic.BoundedRangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSRangeStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSTimeStatistic;

public class JCAConnectionPoolStatsImpl
extends DMSStatsImpl
implements JCAConnectionPoolStats {
    static final long serialVersionUID = 111424095583982648L;
    private transient StatsLocalizationHelper statsLocalizationHelper_ = null;
    private transient JCAConnectionPoolMetricCallBackIf cback_ = null;
    private ObjectName cf_ = null;
    private ObjectName mcf_ = null;

    public JCAConnectionPoolStatsImpl(Locale loc, JCAConnectionPoolMetricCallBackIf cback, ObjectName cf, ObjectName mcf) {
        this.statsLocalizationHelper_ = new StatsLocalizationHelper(loc);
        this.cback_ = cback;
        this.cf_ = cf;
        this.mcf_ = mcf;
        if (this.cback_ != null) {
            DMSStatistic[] dmsStats = new DMSStatistic[]{new DMSTimeStatistic(new DMSMetric((Sensor)((PhaseEvent)this.cback_.getWaitTimeEvent()), "WaitTime", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_waitTime"), "MILLISECONDS")), new DMSTimeStatistic(new DMSMetric((Sensor)((PhaseEvent)this.cback_.getUseTimeEvent()), "UseTime", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_useTime"), "MILLISECONDS")), new DMSCountStatistic(new DMSMetric((Sensor)((Event)this.cback_.getCloseCount()), 2, "CloseCount", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_closecount"), "CONNECTIONS")), new DMSCountStatistic(new DMSMetric((Sensor)((Event)this.cback_.getCreateCount()), 2, "CreateCount", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_createcount"), "CONNECTIONS")), new DMSRangeStatistic(new DMSMetric((Sensor)((PhaseEvent)this.cback_.getWaitingThreadCountEvent()), 64, "WaitingThreadCount", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_waitingThreadCount"), "THREADS", null, null, null, null)), new DMSCountStatistic(new DMSMetric((Sensor)((Event)this.cback_.getErrorCount()), 2, "ErrorCount", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_errorcount"), "CONNECTIONS"))};
            this.addDMSStats(dmsStats);
            Statistic[] jsr77Stats = new Statistic[]{this.getFreePoolSize(), this.getPoolSize()};
            this.addJSR77Stats(jsr77Stats);
            this.initStats();
        }
    }

    public String getConnectionFactory() {
        return this.cf_.toString();
    }

    public String getManagedConnectionFactory() {
        return this.mcf_.toString();
    }

    public BoundedRangeStatistic getFreePoolSize() {
        StateIntf freePoolSize = this.cback_.getFreePoolSizeState();
        long startTime = 0L;
        long lastSampleTime = 0L;
        Long highWaterMark = this.getLong(freePoolSize.getValue(8));
        Long lowWaterMark = this.getLong(freePoolSize.getValue(4));
        Long current = this.getLong(freePoolSize.getValue(2));
        long upperBound = this.cback_.getMaxConnections();
        long lowerBound = 0L;
        long upTime = 0L;
        Object val = Spy.getMetricValue((String)"/JVM/upTime.value");
        if (val != null && val instanceof Long) {
            upTime = (Long)val;
        }
        lastSampleTime = new Date().getTime();
        startTime = lastSampleTime - upTime;
        return new BoundedRangeStatisticImpl("FreePoolSize", "CONNECTIONS", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_freePoolSize"), startTime, lastSampleTime, highWaterMark, lowWaterMark, current, upperBound, lowerBound);
    }

    public BoundedRangeStatistic getPoolSize() {
        StateIntf poolSize = this.cback_.getPoolSizeState();
        Long highWaterMark = this.getLong(poolSize.getValue(8));
        Long lowWaterMark = this.getLong(poolSize.getValue(4));
        Long current = this.getLong(poolSize.getValue(2));
        long upperBound = this.cback_.getMaxConnections();
        long lowerBound = this.cback_.getMinConnections();
        long upTime = 0L;
        Object val = Spy.getMetricValue((String)"/JVM/upTime.value");
        if (val != null && val instanceof Long) {
            upTime = (Long)val;
        }
        long lastSampleTime = new Date().getTime();
        long startTime = lastSampleTime - upTime;
        return new BoundedRangeStatisticImpl("PoolSize", "CONNECTIONS", this.statsLocalizationHelper_.getLocalizedMessage("stats_jcaconnectionpool_poolSize"), startTime, lastSampleTime, highWaterMark, lowWaterMark, current, upperBound, lowerBound);
    }

    private Long getLong(Object obj) {
        if (obj != null && obj instanceof Long) {
            return (Long)obj;
        }
        return new Long(0L);
    }

    public TimeStatistic getUseTime() {
        return (TimeStatistic)this.getStatistic("UseTime");
    }

    public TimeStatistic getWaitTime() {
        return (TimeStatistic)this.getStatistic("WaitTime");
    }

    public CountStatistic getCloseCount() {
        return (CountStatistic)this.getStatistic("CloseCount");
    }

    public CountStatistic getCreateCount() {
        return (CountStatistic)this.getStatistic("CreateCount");
    }

    public RangeStatistic getWaitingThreadCount() {
        return (RangeStatistic)this.getStatistic("WaitingThreadCount");
    }
}

