/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JMSConsumerStats;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.management.j2ee.statistics.JMSProducerStats;
import javax.management.j2ee.statistics.JMSSessionStats;
import javax.management.j2ee.statistics.TimeStatistic;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSTimeStatistic;

public class JMSSessionStatsImpl
extends DMSStatsImpl
implements JMSSessionStats {
    private Set m_consumers = new HashSet();
    private Set m_producers = new HashSet();
    static final long serialVersionUID = 827452345875814939L;

    public JMSSessionStatsImpl(String metricPath) {
        this(Locale.getDefault(), metricPath, null);
    }

    public JMSSessionStatsImpl(Locale loc, String metricPath, JMSSessionStatsImpl copyStats) {
        if (copyStats != null) {
            this.m_consumers = copyStats.m_consumers;
            this.m_producers = copyStats.m_producers;
        }
        StatsLocalizationHelper localizer = new StatsLocalizationHelper(loc);
        this.addDMSStats(new DMSStatistic[]{new DMSCountStatistic(new DMSMetric(metricPath + "/" + "durableSubscriptionCount", 1, "durableSubscriptionCount", localizer.getLocalizedMessage("stats_jmssessionstatsimpl_durablesubscribercount"), "Durable Subscribers")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "expiredMessageCount", 2, "expiredMessageCount", localizer.getLocalizedMessage("stats_jmssessionstatsimpl_expiredmessagecount"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "messageCount", 2, "messageCount", localizer.getLocalizedMessage("stats_jmssessionstatsimpl_messagecount"), "Messages")), new DMSCountStatistic(new DMSMetric(metricPath + "/" + "pendingMessageCount", 2, "pendingMessageCount", localizer.getLocalizedMessage("stats_jmssessionstatsimpl_pendingmessagecount"), "Messages")), new DMSTimeStatistic(new DMSMetric(metricPath + "/" + "messageWaitTime", "messageWaitTime", localizer.getLocalizedMessage("stats_jmssessionstatsimpl_messagewaittime"), "Milliseconds"))});
        this.initStats();
    }

    public final JMSConsumerStats[] getConsumers() {
        return this.m_consumers.toArray(new JMSConsumerStats[0]);
    }

    public final CountStatistic getDurableSubscriptionCount() {
        return (CountStatistic)this.getStatistic("durableSubscriptionCount");
    }

    public final CountStatistic getExpiredMessageCount() {
        return (CountStatistic)this.getStatistic("expiredMessageCount");
    }

    public final CountStatistic getMessageCount() {
        return (CountStatistic)this.getStatistic("messageCount");
    }

    public final TimeStatistic getMessageWaitTime() {
        return (TimeStatistic)this.getStatistic("messageWaitTime");
    }

    public final CountStatistic getPendingMessageCount() {
        return (CountStatistic)this.getStatistic("pendingMessageCount");
    }

    public final JMSProducerStats[] getProducers() {
        return this.m_producers.toArray(new JMSProducerStats[0]);
    }

    public void add(JMSEndpointStats endpoint) {
        if (endpoint instanceof JMSConsumerStats) {
            this.m_consumers.add(endpoint);
        } else if (endpoint instanceof JMSProducerStats) {
            this.m_producers.add(endpoint);
        }
    }

    public void remove(JMSEndpointStats endpoint) {
        this.m_consumers.remove(endpoint);
        this.m_producers.remove(endpoint);
    }
}

