/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared.statistic;

import java.util.Date;
import java.util.Locale;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.MessageDrivenBeanStats;
import javax.management.j2ee.statistics.Statistic;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.Sensor;
import oracle.dms.spy.Spy;
import oracle.oc4j.admin.management.callbackinterfaces.MessageDrivenBeanCallBackIf;
import oracle.oc4j.admin.management.shared.statistic.CountStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.EJBStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;

public class MessageDrivenBeanStatsImpl
extends EJBStatsImpl
implements MessageDrivenBeanStats {
    static final long serialVersionUID = 6287221637807407414L;
    private transient MessageDrivenBeanCallBackIf cback_ = null;

    public MessageDrivenBeanStatsImpl(String applicationName, String moduleName, String ejbName, Locale loc, MessageDrivenBeanCallBackIf cback) {
        super(applicationName, moduleName, ejbName, loc);
        this.cback_ = cback;
        Statistic[] jsr77Stats = this.getStats();
        this.removeStats();
        this.addJSR77Stats(jsr77Stats);
        this.initStats();
    }

    public CountStatistic getCreateCount() {
        return (CountStatistic)this.getStatistic("CreateCount");
    }

    public CountStatistic getRemoveCount() {
        return (CountStatistic)this.getStatistic("RemoveCount");
    }

    public CountStatistic getMessageCount() {
        return (CountStatistic)this.getStatistic("MessageCount");
    }

    protected Statistic[] getStats() {
        DMSStatsImpl stats = new DMSStatsImpl();
        Statistic[] derivedJSR77Stats = super.getStats();
        stats.addJSR77Stats(derivedJSR77Stats);
        stats.removeStat("CreateCount");
        stats.removeStat("RemoveCount");
        stats.removeStat("PooledCount");
        stats.removeStat("ReadyCount");
        if (this.cback_ != null) {
            PhaseEventIntf phaseEvent = this.cback_.getMsgDeliveryCountPhaseEvent();
            EventIntf event = this.cback_.getFailedDeliveryCountEvent();
            DMSStatistic[] dmsStats = new DMSStatistic[]{new DMSCountStatistic(new DMSMetric((Sensor)((PhaseEvent)phaseEvent), 2, "MessageCount", this.statsLocalizationHelper_.getLocalizedMessage("messagedrivenbean_messageDelivery"), "MESSAGES")), new DMSCountStatistic(new DMSMetric((Sensor)((Event)event), 2, "RolledBackMessageCount", this.statsLocalizationHelper_.getLocalizedMessage("messagedrivenbean_failedMessageDeliveryCount"), "MESSAGES"))};
            stats.addDMSStats(dmsStats);
        }
        long lastSampleTime = new Date().getTime();
        long upTime = 0L;
        Object val = Spy.getMetricValue((String)"/JVM/upTime.value");
        if (val != null && val instanceof Long) {
            upTime = (Long)val;
        }
        long startTime = lastSampleTime - upTime;
        Statistic[] jsr77Stats = new Statistic[4];
        int count = 0;
        if (this.cback_ != null) {
            count = this.cback_.getCreateCount();
        }
        jsr77Stats[0] = new CountStatisticImpl("CreateCount", "COUNT", this.statsLocalizationHelper_.getLocalizedMessage("messagedrivenbean_CreateCount"), startTime, lastSampleTime, count);
        count = 0;
        if (this.cback_ != null) {
            count = this.cback_.getRemoveCount();
        }
        jsr77Stats[1] = new CountStatisticImpl("RemoveCount", "COUNT", this.statsLocalizationHelper_.getLocalizedMessage("messagedrivenbean_RemoveCount"), startTime, lastSampleTime, count);
        count = 0;
        if (this.cback_ != null) {
            count = this.cback_.getPooledCount();
        }
        jsr77Stats[2] = new CountStatisticImpl("PooledCount", "COUNT", this.statsLocalizationHelper_.getLocalizedMessage("messagedrivenbean_PooledCount"), startTime, lastSampleTime, count);
        count = 0;
        if (this.cback_ != null) {
            count = this.cback_.getActiveInstances();
        }
        jsr77Stats[3] = new CountStatisticImpl("ReadyCount", "COUNT", this.statsLocalizationHelper_.getLocalizedMessage("messagedrivenbean_ReadyCount"), startTime, lastSampleTime, count);
        stats.addJSR77Stats(jsr77Stats);
        stats.initStats();
        return stats.getStatistics();
    }
}

