/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.JavaAgentCommunicator;
import com.eg.jtm.UPDManager;
import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class JTMServer
extends Thread {
    ServerSocket serverSocket = null;
    int numTimeouts = 0;

    public void run() {
        int port = UPDManager.getJTMPort();
        while (port == -1) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            port = UPDManager.getJTMPort();
            JTMLog.logger.info("Port not yet initialized. Waiting for 1 more second ....");
        }
        JTMLog.logger.debug("port is " + port + " and useDesigAgtOnly is " + UPDManager.isUseDesigAgtOnly() + " and desigAgtInetAddr is " + UPDManager.getDesigAgtInetAddr());
        while (true) {
            Socket socket = null;
            if (UPDManager.getPortChanged()) {
                if (!this.createSrvrSock()) {
                    JTMLog.logger.info("Unable to recreate server socket with new port. Retrying...");
                    continue;
                }
                UPDManager.resetPortChanged();
            }
            if (UPDManager.getMeasPeriodChanged() && this.resetWaitTimeout()) {
                UPDManager.resetMeasPeriodChanged();
            }
            try {
                socket = this.serverSocket.accept();
                this.numTimeouts = 0;
            }
            catch (SocketTimeoutException ste) {
                JTMLog.logger.debug("JTM Server timed-out. Waiting again....");
                ++this.numTimeouts;
                if (this.numTimeouts > 4) {
                    JTMLog.logger.debug("JTM Server timed-out 5 times in a row. Will now wait indefinitely");
                    this.resetWaitTimeout(0);
                }
                this.closeCliSock(socket);
                continue;
            }
            catch (Exception e) {
                JTMLog.logger.error("Exception while accepting connection from Test. Ignoring connection request..", e);
                this.closeCliSock(socket);
                continue;
            }
            InetAddress currAgtInetAddr = socket.getInetAddress();
            ArrayList<Object> allAgtInetAddr = new ArrayList<Object>();
            allAgtInetAddr.add(currAgtInetAddr);
            try {
                InetAddress[] allAgentIps = InetAddress.getAllByName(currAgtInetAddr.getCanonicalHostName());
                if (allAgentIps != null && allAgentIps.length > 1) {
                    int i = 0;
                    while (i < allAgentIps.length) {
                        InetAddress thisIp = allAgentIps[i];
                        if (thisIp != null && (thisIp instanceof Inet6Address || thisIp instanceof Inet4Address)) {
                            allAgtInetAddr.add("/" + allAgentIps[i].getHostAddress());
                        }
                        ++i;
                    }
                }
            }
            catch (UnknownHostException allAgentIps) {
            }
            catch (SecurityException allAgentIps) {
                // empty catch block
            }
            boolean clientIPMatchesDesignatedIP = false;
            try {
                if (UPDManager.isUseDesigAgtOnly()) {
                    InetAddress designatedAgentIpAddress = UPDManager.getDesigAgtInetAddr();
                    InetAddress clientIpAddress = socket.getInetAddress();
                    if (designatedAgentIpAddress != null) {
                        if (designatedAgentIpAddress.equals(clientIpAddress)) {
                            clientIPMatchesDesignatedIP = true;
                        } else {
                            JTMLog.logger.warn("Client IPAddress :" + clientIpAddress + " doesn't match with Designated Agent IPAddress:" + designatedAgentIpAddress);
                            JTMLog.logger.warn("So,Rejecting Request from Client IPAddress : " + clientIpAddress);
                        }
                    }
                } else {
                    clientIPMatchesDesignatedIP = true;
                }
            }
            catch (Exception e) {
                JTMLog.logger.warn("Exception Occured during Designated IPAddress validation");
                clientIPMatchesDesignatedIP = false;
            }
            if (!clientIPMatchesDesignatedIP) continue;
            JavaAgentCommunicator javaAgentCommunicator = new JavaAgentCommunicator();
            javaAgentCommunicator.assignClientSock(socket);
            new Thread((Runnable)javaAgentCommunicator, "JTM Test Handler").start();
        }
    }

    private void closeCliSock(Socket cliSock) {
        if (cliSock != null) {
            try {
                cliSock.close();
            }
            catch (IOException ioe) {
                JTMLog.logger.warn("Error closing client socket " + cliSock.toString(), ioe);
            }
        }
    }

    public boolean createSrvrSock() {
        int prevPort = UPDManager.getPrevJTMPort();
        int port = UPDManager.getJTMPort();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ioe) {
                JTMLog.logger.warn("Exception while closing server on port " + prevPort, ioe);
            }
        }
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                JTMLog.logger.error("Unable to start JTM Server on port " + port + ". Port may already be in use.", e);
            } else {
                JTMLog.logger.error("Unable to start JTM Server due to Exception.", e);
            }
            return false;
        }
        this.resetWaitTimeout();
        JTMLog.logger.info("JTM listening to eG agents on port " + port);
        return true;
    }

    public boolean resetWaitTimeout() {
        try {
            this.serverSocket.setSoTimeout((int)(UPDManager.getEgMeasPeriod() * 2L));
            return true;
        }
        catch (SocketException se) {
            JTMLog.logger.error("Unable to set timeout for JTM Server socket due to Exception.", se);
            return false;
        }
    }

    public boolean resetWaitTimeout(int timeoutVal) {
        try {
            this.serverSocket.setSoTimeout(timeoutVal);
            return true;
        }
        catch (SocketException se) {
            JTMLog.logger.error("Unable to set timeout for JTM Server socket due to Exception.", se);
            return false;
        }
    }
}

