/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.ch.qos.logback.classic.Level;
import com.eg.jtm.JTMLog;
import com.eg.jtm.LogbackFileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class LogbackManager {
    private static final String defaultJtmLogFileName = "JTMLog.log";
    private static final Level defaultJtmLogLevel = Level.OFF;
    private static final int defaultJtmLogFileMaxCount = 5;
    private static final int defaultJtmLogFileLimit = 10;
    private static final int defaultQueueSize = 500;
    private static final int defaultDiscardThresholdLimit = 0;
    private static final String LOG_LEVEL = "LOG_LEVEL";
    private static final String LOG_FILE_COUNT = "LOG_FILE_COUNT";
    private static final String LOG_FILE_SIZE = "LOG_FILE_SIZE";
    private static final String LOG_FILE_NAME = "LOG_FILE_NAME";
    private static final String QUEUE_SIZE = "QUEUE_SIZE";
    private static final String DISCARDING_THRESHOLD = "DISCARDING_THRESHOLD";
    private static boolean isModified = false;

    public static void initLogProperties(String jtmHome) {
        String logFolderHome = System.getProperty("EG_LOG_HOME");
        if (logFolderHome != null && logFolderHome.length() > 0) {
            if (logFolderHome.equalsIgnoreCase("none")) {
                JTMLog.isNone = true;
                System.out.println("EG_LOG_HOMEis None. Applying default logging properties");
                LogbackManager.setDefaultLogging();
            } else {
                try {
                    String logPropsFileName = String.valueOf(jtmHome) + File.separatorChar + "jtmLogging.props";
                    File logPropsFile = new File(logPropsFileName);
                    Properties logProps = new Properties();
                    logProps.load(new BufferedInputStream(new FileInputStream(logPropsFile)));
                    String logLevel = logProps.getProperty(LOG_LEVEL);
                    String logFileCount = logProps.getProperty(LOG_FILE_COUNT);
                    String logFileSize = logProps.getProperty(LOG_FILE_SIZE);
                    String logFileName = logProps.getProperty(LOG_FILE_NAME);
                    String qSize = logProps.getProperty(QUEUE_SIZE);
                    int queue_size = 500;
                    if (qSize != null && qSize.length() > 0) {
                        queue_size = Integer.parseInt(qSize);
                    }
                    String discardThresholdString = logProps.getProperty(DISCARDING_THRESHOLD);
                    int threshold = 0;
                    if (discardThresholdString != null && discardThresholdString.length() > 0) {
                        threshold = Integer.parseInt(discardThresholdString);
                    }
                    LogbackManager.setLogLevel(logLevel);
                    LogbackManager.setLogFileCount(logFileCount);
                    LogbackManager.setLogFileSize(logFileSize);
                    LogbackManager.setLogFileName(logFileName);
                    LogbackManager.setQueueSize(queue_size);
                    LogbackManager.setDiscardThreshold(threshold);
                }
                catch (Exception e) {
                    System.out.println("Exception Occured while Reading logging properties from jtmLogging.props");
                    System.out.println("eG JTM proceeds with default logging properties ");
                    LogbackManager.setDefaultLogging();
                }
                LogbackFileUtils.reset();
                LogbackFileUtils.start(logFolderHome);
            }
        }
    }

    private static void updateLogLevel(String logLevel) {
        Level nowLevel;
        Level newLevel = LogbackManager.getLevelFromProps(logLevel);
        if (newLevel != null && !newLevel.equals(nowLevel = LogbackFileUtils.getJtmLogLevel())) {
            LogbackFileUtils.setLogbackLevel(newLevel);
        }
    }

    private static void updateLogFileSize(String logFileSize) {
        try {
            int newSize = Integer.parseInt(logFileSize);
            int nowSize = LogbackFileUtils.getJtmLogFileLimit();
            if (newSize > 0 && newSize != nowSize) {
                isModified = true;
                LogbackFileUtils.setJtmLogFileLimit(newSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void updateLogFileCount(String logFileCount) {
        try {
            int newCount = Integer.parseInt(logFileCount);
            int nowCount = LogbackFileUtils.getJtmLogFileMaxCount();
            if (newCount > 0 && newCount != nowCount) {
                isModified = true;
                LogbackFileUtils.setJtmLogFileMaxCount(newCount);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void updateLogFileName(String newFileName) {
        try {
            String nowFileName = LogbackFileUtils.getJtmLogFileName();
            if (!newFileName.equalsIgnoreCase(nowFileName)) {
                LogbackFileUtils.setJtmLogFileName(newFileName);
                isModified = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void updateQSize(String qSize) {
        int currentQSize;
        int queue_size = 500;
        queue_size = Integer.parseInt(qSize);
        if (queue_size != (currentQSize = LogbackFileUtils.getQsize()) && queue_size > 0) {
            isModified = true;
            LogbackManager.setQueueSize(queue_size);
        }
    }

    private static void updateThreshold(String discardThresholdString) {
        int currentThreshold;
        int threshold = 0;
        if (discardThresholdString != null && discardThresholdString.length() > 0) {
            threshold = Integer.parseInt(discardThresholdString);
        }
        if ((currentThreshold = LogbackFileUtils.getThreshold()) != threshold && threshold >= 0) {
            isModified = true;
            LogbackManager.setDiscardThreshold(threshold);
        }
    }

    public static void updateLogProps(Properties logProps) {
        String logLevel = logProps.getProperty(LOG_LEVEL);
        String logFileCount = logProps.getProperty(LOG_FILE_COUNT);
        String logFileSize = logProps.getProperty(LOG_FILE_SIZE);
        String logFileName = logProps.getProperty(LOG_FILE_NAME);
        String qSize = logProps.getProperty(QUEUE_SIZE);
        String discardThresholdString = logProps.getProperty(DISCARDING_THRESHOLD);
        if (logLevel != null && logLevel.length() > 0) {
            LogbackManager.updateLogLevel(logLevel);
        }
        if (logFileCount != null && logFileCount.length() > 0) {
            LogbackManager.updateLogFileCount(logFileCount);
        }
        if (logFileSize != null && logFileSize.length() > 0) {
            LogbackManager.updateLogFileSize(logFileSize);
        }
        if (logFileName != null && logFileName.length() > 0) {
            LogbackManager.updateLogFileName(logFileName);
        }
        if (qSize != null && qSize.length() > 0) {
            LogbackManager.updateQSize(qSize);
        }
        if (discardThresholdString != null && discardThresholdString.length() > 0) {
            LogbackManager.updateThreshold(discardThresholdString);
        }
        if (isModified) {
            LogbackFileUtils.reInitializeJTMLogger();
            isModified = false;
        }
    }

    private static Level getLevelFromProps(String logLevel) {
        Level resultLevel = null;
        String lowerCaseLevel = logLevel.toLowerCase();
        if (lowerCaseLevel.equals("all")) {
            resultLevel = Level.ALL;
        } else if (lowerCaseLevel.equals("off")) {
            resultLevel = Level.OFF;
        } else if (lowerCaseLevel.equals("info")) {
            resultLevel = Level.INFO;
        } else if (lowerCaseLevel.equals("warn")) {
            resultLevel = Level.WARN;
        } else if (lowerCaseLevel.equals("debug")) {
            resultLevel = Level.DEBUG;
        } else if (lowerCaseLevel.equals("trace")) {
            resultLevel = Level.TRACE;
        } else if (lowerCaseLevel.equals("error")) {
            resultLevel = Level.ERROR;
        }
        return resultLevel;
    }

    private static void setDefaultLogging() {
        LogbackFileUtils.setJtmLogFileName(defaultJtmLogFileName);
        LogbackFileUtils.setJtmLogFileLimit(10);
        LogbackFileUtils.setJtmLogLevel(defaultJtmLogLevel);
        LogbackFileUtils.setJtmLogFileMaxCount(5);
        LogbackManager.setQueueSize(500);
        LogbackManager.setDiscardThreshold(0);
    }

    private static void setLogFileName(String logFileName) {
        if (logFileName != null && logFileName.length() > 0) {
            LogbackFileUtils.setJtmLogFileName(logFileName);
        } else {
            LogbackFileUtils.setJtmLogFileName(LogbackManager.getDefaultJtmLogFileName());
        }
    }

    private static void setLogFileSize(String logFileSize) {
        if (logFileSize != null && logFileSize.length() > 0) {
            int fileSize = 0;
            try {
                fileSize = Integer.parseInt(logFileSize);
                if (fileSize <= 0) {
                    fileSize = LogbackManager.getDefaultJtmLogFileLimit();
                }
            }
            catch (Exception e) {
                fileSize = LogbackManager.getDefaultJtmLogFileLimit();
            }
            LogbackFileUtils.setJtmLogFileLimit(fileSize);
        } else {
            LogbackFileUtils.setJtmLogFileLimit(LogbackManager.getDefaultJtmLogFileLimit());
        }
    }

    private static void setLogFileCount(String logFileCount) {
        if (logFileCount != null) {
            int fileCount = 0;
            try {
                fileCount = Integer.parseInt(logFileCount);
                if (fileCount <= 0) {
                    fileCount = LogbackManager.getDefaultJtmLogFileMaxCount();
                }
            }
            catch (Exception e) {
                fileCount = LogbackManager.getDefaultJtmLogFileMaxCount();
            }
            LogbackFileUtils.setJtmLogFileMaxCount(fileCount);
        } else {
            LogbackFileUtils.setJtmLogFileMaxCount(LogbackManager.getDefaultJtmLogFileMaxCount());
        }
    }

    private static void setLogLevel(String logLevel) {
        if (logLevel != null && logLevel.length() > 0) {
            String lowerCaseLevel = logLevel.toLowerCase();
            if (lowerCaseLevel.equals("all")) {
                LogbackFileUtils.setJtmLogLevel(Level.ALL);
            } else if (lowerCaseLevel.equals("off")) {
                LogbackFileUtils.setJtmLogLevel(Level.OFF);
            } else if (lowerCaseLevel.equals("info")) {
                LogbackFileUtils.setJtmLogLevel(Level.INFO);
            } else if (lowerCaseLevel.equals("warn")) {
                LogbackFileUtils.setJtmLogLevel(Level.WARN);
            } else if (lowerCaseLevel.equals("debug")) {
                LogbackFileUtils.setJtmLogLevel(Level.DEBUG);
            } else if (lowerCaseLevel.equals("trace")) {
                LogbackFileUtils.setJtmLogLevel(Level.TRACE);
            } else if (lowerCaseLevel.equals("error")) {
                LogbackFileUtils.setJtmLogLevel(Level.ERROR);
            } else {
                LogbackFileUtils.setJtmLogLevel(LogbackManager.getDefaultJtmLogLevel());
            }
        } else {
            LogbackFileUtils.setJtmLogLevel(LogbackManager.getDefaultJtmLogLevel());
        }
    }

    private static void setQueueSize(int qSize) {
        if (qSize > 0) {
            LogbackFileUtils.setAsyncQueueSize(qSize);
        } else {
            LogbackFileUtils.setAsyncQueueSize(500);
        }
    }

    private static void setDiscardThreshold(int threshold) {
        if (threshold >= 0) {
            LogbackFileUtils.setDiscardThreshold(threshold);
        } else {
            LogbackFileUtils.setDiscardThreshold(0);
        }
    }

    public static String getDefaultJtmLogFileName() {
        return defaultJtmLogFileName;
    }

    public static Level getDefaultJtmLogLevel() {
        return defaultJtmLogLevel;
    }

    public static int getDefaultJtmLogFileMaxCount() {
        return 5;
    }

    public static int getDefaultJtmLogFileLimit() {
        return 10;
    }
}

