/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm;

import com.eg.org.objectweb.asm.ByteVector;
import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.ClassWriter;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.SymbolTable;

public class Attribute {
    public final String type;
    private byte[] content;
    Attribute nextAttribute;

    protected Attribute(String string) {
        this.type = string;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return new Label[0];
    }

    protected Attribute read(ClassReader classReader, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        Attribute attribute = new Attribute(this.type);
        attribute.content = new byte[n3];
        System.arraycopy(classReader.b, n2, attribute.content, 0, n3);
        return attribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        return new ByteVector(this.content);
    }

    final int getAttributeCount() {
        int n2 = 0;
        Attribute attribute = this;
        while (attribute != null) {
            ++n2;
            attribute = attribute.nextAttribute;
        }
        return n2;
    }

    final int computeAttributesSize(SymbolTable symbolTable) {
        byte[] byArray = null;
        return this.computeAttributesSize(symbolTable, byArray, 0, -1, -1);
    }

    final int computeAttributesSize(SymbolTable symbolTable, byte[] byArray, int n2, int n3, int n4) {
        ClassWriter classWriter = symbolTable.classWriter;
        int n5 = 0;
        Attribute attribute = this;
        while (attribute != null) {
            symbolTable.addConstantUtf8(attribute.type);
            n5 += 6 + attribute.write((ClassWriter)classWriter, (byte[])byArray, (int)n2, (int)n3, (int)n4).length;
            attribute = attribute.nextAttribute;
        }
        return n5;
    }

    final void putAttributes(SymbolTable symbolTable, ByteVector byteVector) {
        byte[] byArray = null;
        this.putAttributes(symbolTable, byArray, 0, -1, -1, byteVector);
    }

    final void putAttributes(SymbolTable symbolTable, byte[] byArray, int n2, int n3, int n4, ByteVector byteVector) {
        ClassWriter classWriter = symbolTable.classWriter;
        Attribute attribute = this;
        while (attribute != null) {
            ByteVector byteVector2 = attribute.write(classWriter, byArray, n2, n3, n4);
            byteVector.putShort(symbolTable.addConstantUtf8(attribute.type)).putInt(byteVector2.length);
            byteVector.putByteArray(byteVector2.data, 0, byteVector2.length);
            attribute = attribute.nextAttribute;
        }
    }

    static final class Set {
        private static final int SIZE_INCREMENT = 6;
        private int size;
        private Attribute[] data = new Attribute[6];

        Set() {
        }

        void addAttributes(Attribute attribute) {
            Attribute attribute2 = attribute;
            while (attribute2 != null) {
                if (!this.contains(attribute2)) {
                    this.add(attribute2);
                }
                attribute2 = attribute2.nextAttribute;
            }
        }

        Attribute[] toArray() {
            Attribute[] attributeArray = new Attribute[this.size];
            System.arraycopy(this.data, 0, attributeArray, 0, this.size);
            return attributeArray;
        }

        private boolean contains(Attribute attribute) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!this.data[i2].type.equals(attribute.type)) continue;
                return true;
            }
            return false;
        }

        private void add(Attribute attribute) {
            if (this.size >= this.data.length) {
                Attribute[] attributeArray = new Attribute[this.data.length + 6];
                System.arraycopy(this.data, 0, attributeArray, 0, this.size);
                this.data = attributeArray;
            }
            this.data[this.size++] = attribute;
        }
    }
}

