/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.Connection;
import com.thinweb.tds.Lob;
import com.thinweb.tds.PacketOutputParamResult;
import com.thinweb.tds.PacketResult;
import com.thinweb.tds.PreparedStatement;
import com.thinweb.tds.Statement;
import com.thinweb.tds.Tds;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public final class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private String procedureName = null;
    static final int OUTPUT = 1;
    protected boolean lastParamWasNull;
    private int numOutputParams;

    public CallableStatement(Connection connection, Tds tds, String string) throws SQLException {
        super(connection, tds, string);
        this.outParams = new Vector();
        this.procedureName = "";
        int n = 0;
        while (n < string.length() && !Character.isLetterOrDigit(string.charAt(n)) && string.charAt(n) != '#') {
            ++n;
        }
        while (n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '#' || string.charAt(n) == '_')) {
            this.procedureName = this.procedureName + string.charAt(n);
            ++n;
        }
        if (this.procedureName.length() == 0) {
            throw new SQLException("Did not find name in sql string");
        }
    }

    public int executeUpdate() throws SQLException {
        this.closeAllResults();
        if (this.execute()) {
            this.closeResults();
            this.processOutParams();
        }
        return this.getUpdateCount();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return null;
        }
        this.lastParamWasNull = false;
        BigDecimal bigDecimal = null;
        try {
            if (object instanceof byte[]) {
                bigDecimal = new BigDecimal(new String((byte[])object));
            }
            if (object instanceof Date) {
                bigDecimal = new BigDecimal(((Date)object).toString());
            }
            if (object instanceof Time) {
                bigDecimal = new BigDecimal(((Time)object).toString());
            }
            if (object instanceof Integer) {
                bigDecimal = new BigDecimal(((Integer)object).toString());
            }
            if (object instanceof Timestamp) {
                bigDecimal = new BigDecimal(((Timestamp)object).toString());
            }
            if (object instanceof Short) {
                bigDecimal = new BigDecimal(((Short)object).toString());
            }
            if (object instanceof Byte) {
                bigDecimal = new BigDecimal(((Byte)object).toString());
            }
            if (object instanceof Long) {
                bigDecimal = new BigDecimal(((Long)object).toString());
            }
            if (object instanceof Double) {
                bigDecimal = new BigDecimal((Double)object);
            }
            if (object instanceof Float) {
                bigDecimal = new BigDecimal(((Float)object).floatValue());
            }
            if (object instanceof BigDecimal) {
                bigDecimal = (BigDecimal)object;
            }
            if (object instanceof String) {
                bigDecimal = new BigDecimal(object.toString());
            }
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (bl) {
                    bigDecimal = new BigDecimal(1.0);
                } else if (!bl) {
                    bigDecimal = new BigDecimal(0.0);
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error retreiving BigDecimal value. Cannot convert " + object.getClass().getName() + " to BigDecimal.");
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal.setScale(n2);
        }
        return bigDecimal;
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return false;
        }
        this.lastParamWasNull = false;
        try {
            byte by = (byte)this.getLong(n);
            if (by >= 1) {
                return true;
            }
            if (by == 0) {
                return false;
            }
            throw new SQLException();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error retreiving boolean value. Cannot convert " + object.getClass().getName() + " to boolean.");
        }
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return 0;
        }
        this.lastParamWasNull = false;
        try {
            return (byte)this.getLong(n);
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error retreiving byte value. Cannot convert " + object.getClass().getName() + " to byte.");
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return null;
        }
        this.lastParamWasNull = false;
        try {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object == null) {
                return null;
            }
            throw new SQLException();
        }
        catch (Exception exception) {
            throw new SQLException("Error retreiving bytes. Cannot convert " + object.getClass().getName() + " to bytes.");
        }
    }

    public Date getDate(int n) throws SQLException {
        Timestamp timestamp = null;
        try {
            timestamp = this.getTimestamp(n);
            if (timestamp == null) {
                this.lastParamWasNull = true;
                return null;
            }
            this.lastParamWasNull = false;
            return new Date(((java.util.Date)timestamp).getTime());
        }
        catch (Exception exception) {
            throw new SQLException("Error retreiving Date value. Cannot convert " + timestamp.getClass().getName() + " to Date");
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return 0.0;
        }
        this.lastParamWasNull = false;
        try {
            return this.getBigDecimal(n).doubleValue();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error retreiving double value. Cannot convert " + object.getClass().getName() + " to double.");
        }
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return 0.0f;
        }
        this.lastParamWasNull = false;
        try {
            return this.getBigDecimal(n).floatValue();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error retreiving float value. Cannot convert " + object.getClass().getName() + " to float.");
        }
    }

    public int getInt(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return 0;
        }
        this.lastParamWasNull = false;
        try {
            return (int)this.getLong(n);
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error retreiving int value. Cannot convert " + object.getClass().getName() + " to int.");
        }
    }

    public long getLong(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return 0L;
        }
        this.lastParamWasNull = false;
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).longValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof String) {
            return new Byte((String)object).longValue();
        }
        if (object instanceof Time) {
            return new Long(((Time)object).toString());
        }
        if (object instanceof Timestamp) {
            return new Long(((Timestamp)object).toString());
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (bl) {
                return 1L;
            }
            if (!bl) {
                return 0L;
            }
        }
        throw new SQLException("Error retreiving long value. Cannot convert " + object.getClass().getName() + " to long.");
    }

    public Object getObject(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return null;
        }
        this.lastParamWasNull = false;
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SQLException("Error retreiving Object value. Cannot convert " + object.getClass().getName() + " to an Object.");
    }

    public short getShort(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return 0;
        }
        this.lastParamWasNull = false;
        try {
            return (short)this.getLong(n);
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error retreiving short value. Cannot convert " + object.getClass().getName() + " to short.");
        }
    }

    public String getString(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return null;
        }
        this.lastParamWasNull = false;
        if (object instanceof Integer) {
            return ((Integer)object).toString();
        }
        if (object instanceof Short) {
            return ((Short)object).toString();
        }
        if (object instanceof Long) {
            return ((Long)object).toString();
        }
        if (object instanceof Double) {
            return ((Double)object).toString();
        }
        if (object instanceof Float) {
            return ((Float)object).toString();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString();
        }
        if (object instanceof String) {
            return ((String)object).toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof Byte) {
            return ((Byte)object).toString();
        }
        if (object instanceof Date) {
            return ((Date)object).toString();
        }
        if (object instanceof Time) {
            return ((Time)object).toString();
        }
        if (object instanceof Timestamp) {
            return ((Timestamp)object).toString();
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (bl) {
                return "1";
            }
            if (!bl) {
                return "0";
            }
        }
        throw new SQLException("Error retreiving String value. Cannot convert " + object.getClass().getName() + " to String.");
    }

    public Time getTime(int n) throws SQLException {
        Timestamp timestamp = null;
        try {
            timestamp = this.getTimestamp(n);
            if (timestamp == null) {
                this.lastParamWasNull = true;
                return null;
            }
            this.lastParamWasNull = false;
            return new Time(((java.util.Date)timestamp).getTime());
        }
        catch (Exception exception) {
            throw new SQLException("Error retreiving Time value. Cannot convert " + timestamp.getClass().getName() + " to Time");
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.results.getObject(this.getOutParamIndex(n) + 1);
        if (object == null) {
            this.lastParamWasNull = true;
            return null;
        }
        this.lastParamWasNull = false;
        if (object instanceof String) {
            return Timestamp.valueOf((String)object);
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        throw new SQLException("Error retreiving Timestamp value. Cannot convert " + object.getClass().getName() + " to Timestamp");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    void processOutParams() throws SQLException {
        try {
            while (!this.tds.comm.isEndOfPacket() && !this.tds.comm.isMoreIncomingPackets()) {
                this.tds.comm.peek();
                PacketResult packetResult = this.tds.processSubPacket();
                if (!(packetResult instanceof PacketOutputParamResult)) continue;
                this.outParams.addElement(packetResult);
            }
            while (!this.tds.comm.isEndOfPacket()) {
                this.tds.comm.peek();
                this.tds.processSubPacket();
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.setParam(n, null, 1, n2, this.typeAsString(n2, n3));
        ++this.numOutputParams;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.NotImplemented();
    }

    public boolean wasNull() throws SQLException {
        return this.lastParamWasNull;
    }

    public boolean execute() throws SQLException {
        this.fullyQualifyProcName();
        this.closeAllResults();
        return super.execute();
    }

    protected void fullyQualifyProcName() throws SQLException {
        String string = "";
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawQueryString, " \t\n\r\f,=", true);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("=") && stringTokenizer.hasMoreTokens()) {
                string2 = string2 + string;
                String string3 = stringTokenizer.nextToken();
                while (string3.equals(" ")) {
                    string2 = string2 + string3;
                    string3 = stringTokenizer.nextToken();
                }
                int n = 0;
                n = string3.lastIndexOf(46);
                if (n == -1) {
                    Statement statement = (Statement)this.getConnection().createStatement();
                    ResultSet resultSet = statement.executeQuery("sp_help " + string3);
                    resultSet.next();
                    String string4 = resultSet.getString("Owner");
                    string = ((Connection)this.getConnection()).getDatabase() + "." + string4 + "." + string3;
                    statement.close();
                } else {
                    string = string3;
                }
            }
            string2 = string2 + string;
        }
        this.rawQueryString = string2;
    }

    protected Object getOutputParam(int n) {
        PacketOutputParamResult packetOutputParamResult = (PacketOutputParamResult)this.outParams.elementAt(n);
        return packetOutputParamResult.getParam();
    }

    public Array getArray(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return new Lob(byArray, (Connection)this.getConnection());
    }

    public Clob getClob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return new Lob(byArray, (Connection)this.getConnection());
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public CallableStatement(java.sql.Connection connection, Tds tds, String string) throws SQLException {
        super(connection, tds, string);
        this.outParams = new Vector();
        this.procedureName = "";
        int n = 0;
        while (n < string.length() && !Character.isLetterOrDigit(string.charAt(n)) && string.charAt(n) != '#') {
            ++n;
        }
        while (n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || string.charAt(n) == '#' || string.charAt(n) == '_')) {
            this.procedureName = this.procedureName + string.charAt(n);
            ++n;
        }
        if (this.procedureName.length() == 0) {
            throw new SQLException("Did not find name in sql string");
        }
    }
}

