/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.Connection;
import com.thinweb.tds.Constructors;
import com.thinweb.tds.DriverVersion;
import com.thinweb.tds.TdsException;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Driver
implements java.sql.Driver {
    static final boolean debug = false;
    static final String oldSQLServerUrlPrefix = "jdbc:freetds://";
    static final String newSQLServerUrlPrefix = "jdbc:freetds:sqlserver://";
    static final String sybaseUrlPrefix = "jdbc:freetds:sybase://";
    static final String defaultSQLServerPort = "1433";
    static final String defaultSybasePort = "7100";

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = false;
        bl = this.parseUrl(string, new Properties());
        return bl;
    }

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        Connection connection = null;
        if (!this.parseUrl(string, properties)) {
            return null;
        }
        try {
            connection = Constructors.newConnection(properties);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("NumberFormatException converting port number");
        }
        catch (TdsException tdsException) {
            throw new SQLException(tdsException.getMessage());
        }
        return connection;
    }

    public int getMajorVersion() {
        return DriverVersion.getDriverMajorVersion();
    }

    public int getMinorVersion() {
        return DriverVersion.getDriverMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        return driverPropertyInfoArray;
    }

    private boolean isValidHostname(String string) {
        return true;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    protected boolean parseUrl(String string, Properties properties) {
        block15: {
            String string2 = string;
            int n = -1;
            if (string2.startsWith("jdbc:twtds://") || string2.startsWith("jdbc:twtds:sqlserver://")) {
                if (string2.startsWith("jdbc:twtds://")) {
                    n = 1;
                    string2 = string2.substring("jdbc:twtds://".length());
                } else if (string2.startsWith("jdbc:twtds:sqlserver://")) {
                    n = 1;
                    string2 = string2.substring("jdbc:twtds:sqlserver://".length());
                }
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/;", true);
                    String string3 = null;
                    String string4 = n != 2 ? defaultSQLServerPort : defaultSybasePort;
                    String string5 = null;
                    string3 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    if (string6.equals(":")) {
                        string4 = stringTokenizer.nextToken();
                        string6 = stringTokenizer.nextToken();
                    }
                    if (string6.equals("/")) {
                        string5 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            string6 = stringTokenizer.nextToken();
                        }
                    }
                    while (string6.equals(";")) {
                        String string7 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string7, "=", false);
                        String string8 = stringTokenizer2.nextToken().toUpperCase();
                        if (string8.compareToIgnoreCase("user") == 0) {
                            string8 = string8.toLowerCase();
                        }
                        if (string8.compareToIgnoreCase("password") == 0) {
                            string8 = string8.toLowerCase();
                            if (!stringTokenizer2.hasMoreTokens()) {
                                ((Hashtable)properties).put(string8, "");
                            }
                        }
                        if (stringTokenizer2.hasMoreTokens()) {
                            ((Hashtable)properties).put(string8, stringTokenizer2.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        string6 = stringTokenizer.nextToken();
                    }
                    if (!stringTokenizer.hasMoreTokens() && this.isValidHostname(string3) && string5 != null) {
                        ((Hashtable)properties).put("HOST", string3);
                        ((Hashtable)properties).put("SERVERTYPE", "" + n);
                        ((Hashtable)properties).put("PORT", string4);
                        ((Hashtable)properties).put("DBNAME", string5);
                        break block15;
                    }
                    return false;
                }
                catch (NoSuchElementException noSuchElementException) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

