/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.Columns;
import com.thinweb.tds.Connection;
import com.thinweb.tds.Context;
import com.thinweb.tds.Lob;
import com.thinweb.tds.PacketDoneInProcResult;
import com.thinweb.tds.PacketEndTokenResult;
import com.thinweb.tds.PacketMsgResult;
import com.thinweb.tds.PacketResult;
import com.thinweb.tds.PacketRowResult;
import com.thinweb.tds.ResultSetMetaData;
import com.thinweb.tds.SQLWarningChain;
import com.thinweb.tds.Statement;
import com.thinweb.tds.Tds;
import com.thinweb.tds.TdsAsciiInputStream;
import com.thinweb.tds.TdsException;
import com.thinweb.tds.TdsUtil;
import com.thinweb.tds.UpdateObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public final class ResultSet
implements java.sql.ResultSet {
    Tds tds = null;
    Statement stmt = null;
    Columns columnsInfo = null;
    ResultSetMetaData metaData = null;
    PacketRowResult currentRow = null;
    boolean lastGetWasNull = false;
    boolean hitEndOfData = false;
    boolean isClosed = false;
    private SQLWarningChain warningChain = null;
    protected int rowByteSize;
    private String cursorName;
    int FETCH_FORWARD;
    int FETCH_REVERSE;
    int FETCH_UNKNOWN;
    int TYPE_FORWARD_ONLY;
    int TYPE_SCROLL_INSENSITIVE;
    int TYPE_SCROLL_SENSITIVE;
    int CONCUR_READ_ONLY;
    int CONCUR_UPDATABLE;
    Vector columnsUpdated;
    boolean insertingRow;
    protected long cursorId;
    protected int fetchSize = -1;
    protected int rowPosition;
    private String tableName;
    Context context;

    public ResultSet(Tds tds, Statement statement, Columns columns) {
        this.tds = tds;
        this.stmt = statement;
        this.columnsInfo = columns;
        this.hitEndOfData = false;
        this.warningChain = new SQLWarningChain();
        this.FETCH_FORWARD = 1000;
        this.FETCH_REVERSE = 1001;
        this.FETCH_UNKNOWN = 1002;
        this.TYPE_FORWARD_ONLY = 1003;
        this.TYPE_SCROLL_INSENSITIVE = 1004;
        this.TYPE_SCROLL_SENSITIVE = 1005;
        this.CONCUR_READ_ONLY = 1007;
        this.CONCUR_UPDATABLE = 1008;
        this.columnsUpdated = new Vector();
    }

    public void clearWarnings() throws SQLException {
        this.warningChain.clearWarnings();
    }

    public void close() throws SQLException {
        Exception exception = null;
        if (this.cursorName != null && this.cursorId != 0L) {
            ResultSet resultSet = (ResultSet)this.stmt.executeQuery("CLOSE " + this.getCursorName() + " DEALLOCATE " + this.getCursorName());
            this.cursorId = 0L;
            this.cursorName = null;
            resultSet.setCursorName(null);
            resultSet.close();
        }
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                if (!this.tds.hitEndOfData()) {
                    this.tds.discardResultSet(this.columnsInfo);
                    this.hitEndOfData = true;
                }
            }
            catch (TdsException tdsException) {
                tdsException.printStackTrace();
                exception = tdsException;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                exception = iOException;
            }
            this.currentRow = null;
            this.metaData = null;
            this.columnsInfo = null;
            this.stmt = null;
            if (exception != null) {
                throw new SQLException(((Throwable)exception).getMessage());
            }
        }
    }

    public int findColumn(String string) throws SQLException {
        int n = 1;
        while (n <= this.columnsInfo.getColumnCount()) {
            if (this.columnsInfo.getName(n).equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        throw new SQLException("No such column " + string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Object object = this.getObject(n);
        BigDecimal bigDecimal = null;
        if (object == null) {
            bigDecimal = null;
        } else if (object instanceof Double) {
            bigDecimal = new BigDecimal((Double)object);
            bigDecimal = bigDecimal.setScale(n2, 4);
        } else if (object instanceof Float) {
            bigDecimal = new BigDecimal(((Float)object).doubleValue());
            bigDecimal = bigDecimal.setScale(n2, 4);
        } else if (object instanceof Number) {
            bigDecimal = BigDecimal.valueOf(((Number)object).longValue(), n2);
        } else if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)object;
        } else if (object instanceof String) {
            try {
                bigDecimal = new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException(numberFormatException.getMessage());
            }
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        Object object = this.getObject(n);
        if (object == null) {
            bl = false;
        } else {
            switch (this.getMetaData().getColumnType(n)) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (!(object instanceof Number)) {
                        throw new SQLException("Internal error");
                    }
                    bl = ((Number)object).intValue() != 0;
                    break;
                }
                case -7: {
                    if (!(object instanceof Boolean)) {
                        throw new SQLException("Internal error");
                    }
                    bl = (Boolean)object;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    if (!(object instanceof String)) {
                        throw new SQLException("Internal error");
                    }
                    char c = ((String)object + "n").charAt(0);
                    bl = c == 'Y' || c == 'y' || c == 't' || c == 'T';
                    break;
                }
                default: {
                    throw new SQLException("Can't convert column " + n + " from " + object.getClass().getName() + " to boolean");
                }
            }
        }
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getLong(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        block5: {
            try {
                Object object = this.currentRow.getElementAt(n);
                this.lastGetWasNull = false;
                if (object == null) {
                    this.lastGetWasNull = true;
                    byArray = null;
                    break block5;
                }
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                    break block5;
                }
                if (object instanceof String) {
                    byArray = this.tds.getEncoder().getBytes((String)object);
                    break block5;
                }
                throw new SQLException("Can't convert column " + n + " from " + object.getClass().getName() + " to byte[]");
            }
            catch (TdsException tdsException) {
                tdsException.printStackTrace();
                throw new SQLException(tdsException.getMessage());
            }
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    public Date getDate(int n) throws SQLException {
        Date date = null;
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp != null) {
            date = new Date(((java.util.Date)timestamp).getTime());
        }
        return date;
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public double getDouble(int n) throws SQLException {
        double d;
        Object object = this.getObject(n);
        if (object == null) {
            d = 0.0;
        } else {
            try {
                switch (this.getMetaData().getColumnType(n)) {
                    case -6: 
                    case 4: 
                    case 5: {
                        d = ((Number)object).doubleValue();
                        break;
                    }
                    case -5: {
                        d = ((Number)object).doubleValue();
                        break;
                    }
                    case 7: {
                        d = ((Float)object).doubleValue();
                        break;
                    }
                    case 6: 
                    case 8: {
                        d = ((Number)object).doubleValue();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            Double d2 = new Double((String)object);
                            d = d2;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SQLException(numberFormatException.getMessage());
                        }
                    }
                    case 2: 
                    case 3: {
                        d = ((BigDecimal)object).doubleValue();
                        break;
                    }
                    default: {
                        throw new SQLException("Internal error. Don't know how to convert from java.sql.Types." + TdsUtil.javaSqlTypeToString(this.getMetaData().getColumnType(n)) + " to an Dboule");
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new SQLException("Couldn't convert column " + n + " to an long.  " + classCastException.getMessage());
            }
        }
        return d;
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        return (int)this.getLong(n);
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        long l = 0L;
        Object object = this.getObject(n);
        if (object == null) {
            l = 0L;
        } else {
            try {
                switch (this.getMetaData().getColumnType(n)) {
                    case -6: 
                    case 4: 
                    case 5: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    case -5: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        try {
                            Long l2 = new Long((String)object);
                            l = l2;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SQLException(numberFormatException.getMessage());
                        }
                    }
                    case 2: {
                        l = ((Number)object).longValue();
                        break;
                    }
                    default: {
                        throw new SQLException("Internal error. Don't know how to convert from java.sql.Types " + TdsUtil.javaSqlTypeToString(this.getMetaData().getColumnType(n)) + " to an long");
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new SQLException("Couldn't convert column " + n + " to an long.  " + classCastException.getMessage());
            }
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new ResultSetMetaData(this.columnsInfo, this.stmt);
        }
        return this.metaData;
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        if (this.currentRow == null) {
            throw new SQLException("No current row in the result set.  Did you call ResultSet.next()?");
        }
        try {
            Object object2 = this.currentRow.getElementAt(n);
            this.lastGetWasNull = false;
            if (object2 == null) {
                this.lastGetWasNull = true;
                object = null;
            } else {
                switch (this.getMetaData().getColumnType(n)) {
                    case -10: 
                    case -9: 
                    case -8: 
                    case 1: 
                    case 12: {
                        if (object2 instanceof String) {
                            object = object2;
                            break;
                        }
                        throw new SQLException("Was expecting CHAR data.  Got" + object2.getClass().getName());
                    }
                    case -6: {
                        if (!(object2 instanceof Long)) {
                            throw new SQLException("Internal error");
                        }
                        object = new Short((short)((Long)object2).intValue());
                        break;
                    }
                    case 5: {
                        if (!(object2 instanceof Long)) {
                            throw new SQLException("Internal error");
                        }
                        object = new Short((short)((Long)object2).intValue());
                        break;
                    }
                    case 4: {
                        if (!(object2 instanceof Long)) {
                            throw new SQLException("Internal error");
                        }
                        object = new Integer(((Long)object2).intValue());
                        break;
                    }
                    case -5: {
                        if (!(object2 instanceof Long)) {
                            throw new SQLException("Internal error");
                        }
                        object = (Long)object2;
                        break;
                    }
                    case 7: {
                        if (!(object2 instanceof Float)) {
                            throw new SQLException("Internal error");
                        }
                        object = (Float)object2;
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (object2 instanceof Double) {
                            object = (Double)object2;
                            break;
                        }
                        if (object2 instanceof Float) {
                            object = new Double(((Float)object2).doubleValue());
                            break;
                        }
                        throw new SQLException("Was expecting Double data.  Got" + object2.getClass().getName());
                    }
                    case 91: {
                        if (!(object2 instanceof Timestamp)) {
                            throw new SQLException("Internal error");
                        }
                        object = new Date(((java.util.Date)((Timestamp)object2)).getTime());
                        break;
                    }
                    case 92: {
                        if (!(object2 instanceof Timestamp)) {
                            throw new SQLException("Internal error");
                        }
                        object = new Time(((java.util.Date)((Timestamp)object2)).getTime());
                        break;
                    }
                    case 93: {
                        if (!(object2 instanceof Timestamp)) {
                            throw new SQLException("Internal error");
                        }
                        object = (Timestamp)object2;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        object = this.getBytes(n);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (object2 instanceof BigDecimal) {
                            object = (BigDecimal)object2;
                            break;
                        }
                        throw new SQLException("Was expecting NUMERIC data.  Got" + object2.getClass().getName());
                    }
                    case -1: {
                        if (object2 instanceof TdsAsciiInputStream) {
                            object = ((TdsAsciiInputStream)object2).toString();
                            break;
                        }
                        if (object2 instanceof String) {
                            object = object2;
                            break;
                        }
                        throw new SQLException("Was expecting LONGVARCHAR data. Got " + object2.getClass().getName());
                    }
                    case 0: {
                        throw new SQLException("Not implemented");
                    }
                    case 1111: {
                        throw new SQLException("Not implemented");
                    }
                    case -7: {
                        if (object2 instanceof Boolean) {
                            object = (Boolean)object2;
                            break;
                        }
                        throw new SQLException("Was expecting BIT data. Got" + object2.getClass().getName());
                    }
                    default: {
                        String string = "Unknown datatype " + this.getMetaData().getColumnType(n);
                        throw new SQLException(string);
                    }
                }
            }
        }
        catch (TdsException tdsException) {
            tdsException.printStackTrace();
            throw new SQLException(tdsException.getMessage());
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getLong(n);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        return object.toString();
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        Time time = null;
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp != null) {
            time = new Time(((java.util.Date)timestamp).getTime());
        }
        return time;
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        block4: {
            try {
                Object object = this.currentRow.getElementAt(n);
                this.lastGetWasNull = false;
                if (object == null) {
                    this.lastGetWasNull = true;
                    timestamp = null;
                    break block4;
                }
                if (object instanceof Timestamp) {
                    timestamp = (Timestamp)object;
                    break block4;
                }
                throw new SQLException("Can't convert column " + n + " from " + object.getClass().getName() + " to Timestamp");
            }
            catch (TdsException tdsException) {
                throw new SQLException(tdsException.getMessage());
            }
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain.getWarnings();
    }

    public boolean next() throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        boolean bl2 = false;
        Object var4_4 = null;
        if (this.isClosed) {
            throw new SQLException("result set is closed");
        }
        if (!this.tds.hitEndOfData()) {
            try {
                PacketResult packetResult;
                this.clearWarnings();
                Context context = new Context();
                context.setColumnInfo(this.columnsInfo);
                while (!(this.tds.isResultSet() || this.tds.isEndOfResults() || this.tds.isResultRow())) {
                    if (this.tds.isProcId() || this.tds.peek() == 121) {
                        this.tds.processSubPacket();
                        continue;
                    }
                    if (this.tds.isDoneInProc()) {
                        packetResult = (PacketDoneInProcResult)this.tds.processSubPacket();
                        continue;
                    }
                    if (this.tds.isTextUpdate()) {
                        this.tds.processSubPacket();
                        continue;
                    }
                    if (this.tds.isMessagePacket() || this.tds.isErrorPacket()) {
                        packetResult = (PacketMsgResult)this.tds.processSubPacket();
                        sQLException = this.warningChain.addOrReturn((PacketMsgResult)packetResult);
                        continue;
                    }
                    throw new SQLException("Protocol confusion.  Got a 0x" + Integer.toHexString(this.tds.peek() & 0xFF) + " packet");
                }
                if (sQLException != null) {
                    throw sQLException;
                }
                if (this.tds.isResultSet()) {
                    this.stmt.startResultSet();
                    context.setColumnInfo(this.stmt.getCurrentResultSet().getColumnsInfo());
                }
                if (this.tds.isResultRow()) {
                    this.currentRow = (PacketRowResult)this.tds.processSubPacket(context);
                    bl = true;
                } else if (this.tds.isEndOfResults()) {
                    packetResult = this.tds.processSubPacket(context);
                    this.currentRow = null;
                    this.hitEndOfData = true;
                    bl2 = bl2 || ((PacketEndTokenResult)packetResult).wasCanceled();
                } else if (!this.tds.isResultSet()) {
                    throw new SQLException("Protocol confusion.  Got a 0x" + Integer.toHexString(this.tds.peek() & 0xFF) + " packet");
                }
                if (sQLException != null) {
                    throw sQLException;
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            catch (TdsException tdsException) {
                tdsException.printStackTrace();
                throw new SQLException(tdsException.getMessage());
            }
        }
        if (!bl && this.stmt.isUsingCursor()) {
            long l = this.getCursorId();
            ResultSet resultSet = (ResultSet)this.stmt.executeQuery("sp_cursorfetch " + l + ", 2 , 1, " + this.stmt.getFetchSize());
            this.stmt.getCurrentResultSet().setCursorName(this.stmt.getCursorName());
            this.stmt.getCurrentResultSet().setCursorId(l);
            try {
                if (resultSet.tds.comm.peek() != -47) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tds = resultSet.tds;
            this.stmt = resultSet.stmt;
            this.columnsInfo = resultSet.columnsInfo;
            this.metaData = resultSet.metaData;
            return this.next();
        }
        if (bl2) {
            throw new SQLException("Query was cancelled or timed out.");
        }
        ++this.rowPosition;
        return bl;
    }

    protected void NotImplemented() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void setCursorName(String string) {
        this.cursorName = string;
    }

    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    public Columns getColumnsInfo() {
        return this.columnsInfo;
    }

    protected long getCursorId() throws SQLException {
        ResultSet resultSet;
        if (this.cursorId == 0L && (resultSet = (ResultSet)this.stmt.executeQuery("DECLARE @Report CURSOR EXEC master.dbo.sp_describe_cursor @cursor_return = @Report OUTPUT, @cursor_source = N'global', @cursor_identity = N'" + this.getCursorName() + "' " + "FETCH NEXT from @Report")).next()) {
            --this.rowPosition;
            resultSet.columnsInfo = this.stmt.getCurrentResultSet().getColumnsInfo();
            resultSet.metaData = null;
            this.cursorId = resultSet.getLong("cursor_handle");
        }
        return this.cursorId;
    }

    protected String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setContext(Columns columns) {
        if (this.context == null) {
            this.context = new Context();
            this.context.setColumnInfo(columns);
        }
    }

    public void setCursorId(long l) {
        if (this.cursorId == 0L) {
            this.cursorId = l;
        }
    }

    public boolean absolute(int n) throws SQLException {
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery("FETCH ABSOLUTE " + n + " FROM " + this.getCursorName());
        this.tds = resultSet.tds;
        this.stmt = resultSet.stmt;
        this.columnsInfo = resultSet.columnsInfo;
        this.metaData = resultSet.metaData;
        try {
            if (this.tds.comm.peek() != -47) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = this.next();
        if (bl) {
            this.rowPosition = n;
        }
        return bl;
    }

    public void afterLast() throws SQLException {
        this.last();
        this.next();
        this.next();
        this.rowPosition = -1;
    }

    public void beforeFirst() throws SQLException {
        this.first();
        this.previous();
        this.previous();
        this.rowPosition = 0;
    }

    public void cancelRowUpdates() throws SQLException {
        this.columnsUpdated = null;
    }

    public void deleteRow() throws SQLException {
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery("DELETE " + this.getTableName() + " WHERE CURRENT OF " + this.getCursorName());
        this.tds = resultSet.tds;
        this.stmt = resultSet.stmt;
        this.columnsInfo = resultSet.columnsInfo;
        this.metaData = resultSet.metaData;
    }

    public boolean first() throws SQLException {
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery("FETCH FIRST FROM " + this.getCursorName());
        this.tds = resultSet.tds;
        this.stmt = resultSet.stmt;
        this.columnsInfo = resultSet.columnsInfo;
        this.metaData = resultSet.metaData;
        try {
            if (this.tds.comm.peek() != -47) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = this.next();
        if (bl) {
            this.rowPosition = 1;
        }
        return bl;
    }

    public Array getArray(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Array getArray(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        return new BigDecimal(object.toString());
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        return this.getLob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        return this.getLob(n);
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Vector getColumnsUpdated() {
        return this.columnsUpdated;
    }

    public int getConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    public int getFetchSize() throws SQLException {
        if (this.fetchSize != -1) {
            return this.fetchSize;
        }
        return this.stmt.getFetchSize();
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public int getRow() throws SQLException {
        if (this.stmt.getResultSetType() == 1006) {
            return -1;
        }
        return this.rowPosition;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public void insertRow() throws SQLException {
        if (this.getTableName() == null) {
            throw new SQLException("ResultSet is not updateable.");
        }
        if (this.insertingRow && this.columnsUpdated.size() == 0) {
            ResultSet resultSet = (ResultSet)this.stmt.executeQuery("sp_cursor " + this.getCursorId() + ", 4, 1, ' ', " + "'insert " + this.getTableName() + " default values'");
            this.insertingRow = false;
        } else if (this.insertingRow && this.columnsUpdated.size() > 0) {
            Object object;
            java.sql.ResultSetMetaData resultSetMetaData = this.getMetaData();
            Columns columns = this.columnsInfo;
            PacketRowResult packetRowResult = this.currentRow;
            String string = " (";
            Object object2 = " (";
            int n = 0;
            while (n < this.columnsUpdated.size()) {
                object = (UpdateObject)this.columnsUpdated.elementAt(n);
                string = string + resultSetMetaData.getColumnName(((UpdateObject)object).getColumn());
                object2 = (String)object2 + ((UpdateObject)object).getValue();
                if (n < this.columnsUpdated.size() - 1) {
                    string = string + ", ";
                    object2 = (String)object2 + ", ";
                }
                ++n;
            }
            string = string + ")";
            object2 = (String)object2 + ")";
            object = "";
            int n2 = 0;
            while (n2 < ((String)object2).length()) {
                char c = ((String)object2).charAt(n2);
                if (c == '\'') {
                    object = (String)object + '\'';
                }
                object = (String)object + c;
                ++n2;
            }
            object2 = object;
            String string2 = "'insert into " + this.getTableName() + string + " values" + (String)object2 + "'";
            try {
                ResultSet resultSet = (ResultSet)this.stmt.executeQuery("sp_cursor " + this.getCursorId() + ", 4, 1, ' ', " + string2);
            }
            catch (Exception exception) {
                throw new SQLException("Error inserting row. SQL: " + string2 + "\n " + exception.getMessage());
            }
            this.metaData = (ResultSetMetaData)resultSetMetaData;
            this.columnsInfo = columns;
            this.currentRow = packetRowResult;
            this.insertingRow = false;
            this.columnsUpdated.removeAllElements();
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.getRow() == -1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery(" declare @P3 int \ndeclare @P4 int \nset @P3=null \nset @P4=null \nexec sp_cursorfetch " + this.getCursorId() + ", 256, @P3 out, @P4 out \n" + "select @P3, @P4 \n");
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt(2);
        }
        resultSet.close();
        return this.getRow() == n;
    }

    public boolean last() throws SQLException {
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery(" declare @P3 int \ndeclare @P4 int \nset @P3=null \nset @P4=null \nexec sp_cursorfetch " + this.getCursorId() + ", 256, @P3 out, @P4 out \n" + "select @P3, @P4 \n");
        int n = 0;
        if (resultSet.next()) {
            resultSet.columnsInfo = this.stmt.results.columnsInfo;
            n = resultSet.getInt(2);
        }
        ResultSet resultSet2 = (ResultSet)this.stmt.executeQuery("sp_cursorfetch " + this.getCursorId() + ", 8, -1, " + this.getFetchSize());
        this.tds = resultSet2.tds;
        this.stmt = resultSet2.stmt;
        this.columnsInfo = resultSet2.columnsInfo;
        this.metaData = resultSet2.metaData;
        try {
            if (this.tds.comm.peek() != -47) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rowPosition = n - 1;
        return this.next();
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        this.insertingRow = true;
    }

    public boolean previous() throws SQLException {
        if (this.rowPosition == -1) {
            return this.last();
        }
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery("FETCH FIRST FROM " + this.getCursorName());
        ResultSet resultSet2 = (ResultSet)this.stmt.executeQuery("FETCH RELATIVE " + (this.rowPosition - 2) + " FROM " + this.getCursorName());
        this.tds = resultSet2.tds;
        this.stmt = resultSet2.stmt;
        this.columnsInfo = resultSet2.columnsInfo;
        this.metaData = resultSet2.metaData;
        this.currentRow = resultSet2.currentRow;
        try {
            if (this.tds.comm.peek() != -47) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rowPosition -= 2;
        return this.next();
    }

    public void refreshRow() throws SQLException {
        this.NotImplemented();
    }

    public boolean relative(int n) throws SQLException {
        ResultSet resultSet = null;
        if (this.getFetchSize() > 1) {
            resultSet = (ResultSet)this.stmt.executeQuery("FETCH FIRST FROM " + this.getCursorName() + " FETCH RELATIVE " + (this.rowPosition - 2) + " FROM " + this.getCursorName());
        }
        ResultSet resultSet2 = (ResultSet)this.stmt.executeQuery("FETCH RELATIVE " + n + " FROM " + this.getCursorName());
        this.tds = resultSet2.tds;
        this.stmt = resultSet2.stmt;
        this.columnsInfo = resultSet2.columnsInfo;
        this.metaData = resultSet2.metaData;
        try {
            if (this.tds.comm.peek() != -47) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        --this.rowPosition;
        this.rowPosition += n;
        return this.next();
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setColumnsUpdated(Vector vector) {
        this.columnsUpdated = vector;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer(n2 + 16);
            stringBuffer.append('\'');
            boolean bl = false;
            int n3 = 0;
            while (n3 < n2 && inputStream.available() != 0) {
                char c = (char)inputStream.read();
                stringBuffer.append(c);
                if (c == '\'') {
                    stringBuffer.append('\'');
                }
                ++n3;
            }
            stringBuffer.append('\'');
            UpdateObject updateObject = new UpdateObject(n, new String(stringBuffer));
            this.columnsUpdated.addElement(updateObject);
            return;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(bigDecimal, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype BigDecimal");
        }
        UpdateObject updateObject = new UpdateObject(n, bigDecimal.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer(2 * n2 + 2);
            stringBuffer.append("0x");
            int n3 = 0;
            while (n3 < n2) {
                byte by = (byte)inputStream.read();
                char c = Character.forDigit(by & 0xF, 16);
                by = (byte)(by >>> 4);
                stringBuffer.append(Character.forDigit(by & 0xF, 16));
                stringBuffer.append(c);
                ++n3;
            }
            UpdateObject updateObject = new UpdateObject(n, new String(stringBuffer));
            this.columnsUpdated.addElement(updateObject);
            return;
        }
        catch (Exception exception) {
            throw new SQLException("Error updating binary stream column: " + exception.getMessage());
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = new Boolean(bl);
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(bl2, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype bit");
        }
        UpdateObject updateObject = new UpdateObject(n, new Integer(n2).toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        Integer n2 = new Integer(by & 0xFF);
        n2.intValue();
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(n2, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype byte");
        }
        UpdateObject updateObject = new UpdateObject(n, n2.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = reader.read();
            int n4 = 0;
            while (n3 != -1) {
                stringBuffer.append((char)n3);
                n3 = reader.read();
                ++n4;
            }
            UpdateObject updateObject = new UpdateObject(n, "'" + new String(stringBuffer) + "'");
            this.columnsUpdated.addElement(updateObject);
            return;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(d2, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype double");
        }
        UpdateObject updateObject = new UpdateObject(n, d2.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        Float f2 = new Float(f);
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(f2, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype float");
        }
        UpdateObject updateObject = new UpdateObject(n, f2.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(n3, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype int");
        }
        UpdateObject updateObject = new UpdateObject(n, n3.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        Long l2 = new Long(l);
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(l2, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype long");
        }
        UpdateObject updateObject = new UpdateObject(n, l2.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(null, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column to null");
        }
        UpdateObject updateObject = new UpdateObject(n, "null");
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        try {
            if (object instanceof String) {
                String string = null;
                int n2 = 55;
                string = (n2 == 55 ? "" : "N") + "'" + object + "'";
                try {
                    if (this.currentRow != null) {
                        this.currentRow.setElementAt(string, n);
                    }
                }
                catch (Exception exception) {
                    throw new SQLException("Error updating column of datatype String");
                }
                UpdateObject updateObject = new UpdateObject(n, string);
                this.columnsUpdated.addElement(updateObject);
                return;
            }
            if (object instanceof Double) {
                this.updateDouble(n, (double)((Double)object));
                return;
            }
            if (object instanceof Float) {
                this.updateFloat(n, ((Float)object).floatValue());
                return;
            }
            if (object instanceof Integer) {
                this.updateInt(n, (int)((Integer)object));
                return;
            }
            if (object instanceof Long) {
                this.updateLong(n, (long)((Long)object));
                return;
            }
            if (object instanceof BigInteger) {
                this.updateLong(n, ((BigInteger)object).longValue());
                return;
            }
            if (object instanceof BigDecimal) {
                this.updateDouble(n, ((BigDecimal)object).doubleValue());
                return;
            }
            if (object instanceof Short) {
                this.updateShort(n, (short)((Short)object));
                return;
            }
            if (object instanceof Byte) {
                this.updateByte(n, (byte)((Byte)object));
                return;
            }
            if (object instanceof Timestamp || object instanceof Date || object instanceof Time) {
                this.updateTimestamp(n, (Timestamp)object);
                return;
            }
            if (object instanceof Boolean) {
                this.updateBoolean(n, (boolean)((Boolean)object));
                return;
            }
            if (object instanceof Date) {
                this.updateDate(n, (Date)object);
                return;
            }
            if (object == null) {
                this.updateNull(n);
                return;
            }
            if (object instanceof byte[]) {
                this.updateBytes(n, (byte[])object);
                return;
            }
            if (object instanceof InputStream) {
                this.updateBinaryStream(n, (InputStream)object, ((InputStream)object).available());
                return;
            }
            throw new SQLException("TDS Driver does not support setObject(" + n + ", " + object.getClass() + ")");
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateRow() throws SQLException {
        if (this.getTableName() == null) {
            throw new SQLException("ResultSet is not updateable.");
        }
        if (this.columnsUpdated == null) {
            return;
        }
        String string = this.buildSetStmt();
        ResultSet resultSet = (ResultSet)this.stmt.executeQuery("UPDATE " + this.getTableName() + " " + string + " WHERE CURRENT OF " + this.getCursorName());
        this.columnsUpdated.removeAllElements();
    }

    public void updateShort(int n, short s) throws SQLException {
        Short s2 = new Short(s);
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(s2, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype short");
        }
        UpdateObject updateObject = new UpdateObject(n, s2.toString());
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(time, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype time");
        }
        UpdateObject updateObject = new UpdateObject(n, "'" + time.toString() + "'");
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(timestamp, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype timestamp");
        }
        UpdateObject updateObject = new UpdateObject(n, "'" + timestamp.toString() + "'");
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.NotImplemented();
        return null;
    }

    public java.sql.Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            if (this.currentRow != null) {
                this.currentRow.setElementAt(date, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error updating column of datatype Date");
        }
        UpdateObject updateObject = new UpdateObject(n, "'" + this.stmt.toNativeDateFormat(date) + "'");
        this.columnsUpdated.addElement(updateObject);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    private String buildSetStmt() throws SQLException {
        if (this.metaData == null) {
            this.metaData = (ResultSetMetaData)this.getMetaData();
        }
        String string = " set ";
        int n = 0;
        while (n < this.columnsUpdated.size()) {
            UpdateObject updateObject = (UpdateObject)this.columnsUpdated.elementAt(n);
            String string2 = this.metaData.getColumnName(updateObject.getColumn());
            if (!string2.equals("rowstat")) {
                string = string + string2 + " = " + updateObject.getValue() + ", ";
            }
            ++n;
        }
        if (string.trim().endsWith(",")) {
            string = string.trim().substring(0, string.trim().length() - 1);
        }
        return string;
    }

    public Lob getLob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new Lob(byArray, (Connection)this.stmt.getConnection());
    }
}

