/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.TdsDefinitions;
import com.thinweb.tds.TdsException;
import com.thinweb.tds.TdsUnknownPacketType;
import com.thinweb.tds.util.HexDump;
import com.thinweb.tds.util.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Timestamp;

final class TdsComm
implements TdsDefinitions {
    static final int headerLength = 8;
    static final byte QUERY = 1;
    static final byte LOGON = 2;
    static final byte PROC = 3;
    static final byte REPLY = 4;
    static final byte CANCEL = 6;
    static final byte LOGON70 = 16;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    byte[] outBuffer;
    int nextOutBufferIndex = 0;
    int packetType = 0;
    byte[] inBuffer;
    int inBufferIndex = 0;
    int inBufferLen = 0;
    int packetsSent = 0;
    int packetsReceived = 0;
    static int id;
    private int tdsVer = 42;
    Socket socket;
    protected boolean moreIncomingPackets = false;

    public TdsComm(Socket socket, int n) throws IOException {
        this.socket = socket;
        this.out = new DataOutputStream(socket.getOutputStream());
        this.in = new DataInputStream(socket.getInputStream());
        this.outBuffer = new byte[4096];
        this.inBuffer = new byte[4096];
        this.tdsVer = n;
        ++id;
    }

    void appendByte(byte by) throws IOException {
        if (this.nextOutBufferIndex == 4096) {
            this.sendPhysicalPacket(false);
            this.nextOutBufferIndex = 8;
        }
        this.storeByte(this.nextOutBufferIndex, by);
        ++this.nextOutBufferIndex;
    }

    void appendBytes(byte[] byArray) throws IOException {
        this.appendBytes(byArray, byArray.length, (byte)0);
    }

    void appendBytes(byte[] byArray, int n, byte by) throws IOException {
        int n2 = 0;
        while (n2 < byArray.length && n2 < n) {
            this.appendByte(byArray[n2]);
            ++n2;
        }
        while (n2 < n) {
            this.appendByte(by);
            ++n2;
        }
    }

    void appendChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            byte by = (byte)(c & 0xFF);
            byte by2 = (byte)(c >> 8 & 0xFF);
            this.appendByte(by);
            this.appendByte(by2);
            ++n;
        }
    }

    void appendFlt8(Double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.appendByte((byte)(l >> 0 & 0xFFL));
        this.appendByte((byte)(l >> 8 & 0xFFL));
        this.appendByte((byte)(l >> 16 & 0xFFL));
        this.appendByte((byte)(l >> 24 & 0xFFL));
        this.appendByte((byte)(l >> 32 & 0xFFL));
        this.appendByte((byte)(l >> 40 & 0xFFL));
        this.appendByte((byte)(l >> 48 & 0xFFL));
        this.appendByte((byte)(l >> 56 & 0xFFL));
    }

    void appendInt(int n) throws IOException {
        this.appendByte((byte)(n >> 24 & 0xFF));
        this.appendByte((byte)(n >> 16 & 0xFF));
        this.appendByte((byte)(n >> 8 & 0xFF));
        this.appendByte((byte)(n >> 0 & 0xFF));
    }

    void appendInt64(long l) throws IOException {
        this.appendByte((byte)(l >> 56 & 0xFFL));
        this.appendByte((byte)(l >> 48 & 0xFFL));
        this.appendByte((byte)(l >> 40 & 0xFFL));
        this.appendByte((byte)(l >> 32 & 0xFFL));
        this.appendByte((byte)(l >> 24 & 0xFFL));
        this.appendByte((byte)(l >> 16 & 0xFFL));
        this.appendByte((byte)(l >> 8 & 0xFFL));
        this.appendByte((byte)(l >> 0 & 0xFFL));
    }

    void appendShort(short s) throws IOException {
        this.appendByte((byte)(s >> 8 & 0xFF));
        this.appendByte((byte)(s >> 0 & 0xFF));
    }

    void appendTdsBigDecimal(BigDecimal bigDecimal) {
        bigDecimal.toString();
    }

    void appendTdsInt(int n) throws IOException {
        this.appendByte((byte)(n >> 0 & 0xFF));
        this.appendByte((byte)(n >> 8 & 0xFF));
        this.appendByte((byte)(n >> 16 & 0xFF));
        this.appendByte((byte)(n >> 24 & 0xFF));
    }

    void appendTdsShort(short s) throws IOException {
        this.appendByte((byte)(s >> 0 & 0xFF));
        this.appendByte((byte)(s >> 8 & 0xFF));
    }

    void backup() {
        --this.inBufferIndex;
    }

    void close() throws IOException {
        this.socket.close();
    }

    byte getByte() throws TdsException, IOException {
        if (this.inBufferIndex >= this.inBufferLen) {
            this.getPhysicalPacket();
        }
        byte by = this.inBuffer[this.inBufferIndex++];
        return by;
    }

    byte[] getBytes(int n) throws TdsException, IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.getByte();
            ++n2;
        }
        return byArray;
    }

    DataInputStream getDataInputStream() {
        return this.in;
    }

    int getNetShort() throws TdsException, IOException {
        byte[] byArray = new byte[]{this.getByte(), this.getByte()};
        return TdsComm.ntohs(byArray, 0);
    }

    private void getPhysicalPacket() throws TdsException, IOException {
        byte by;
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            n += this.in.read(byArray, n, 8 - n);
        }
        if (Logger.isActive()) {
            String string = HexDump.hexDump(byArray, 8);
            String string2 = new Timestamp(System.currentTimeMillis()).toString();
            Logger.println("Instance " + id + " @ " + string2 + " recevied header #" + (this.packetsReceived + 1) + "\n" + string);
        }
        if ((by = byArray[0]) != 2 && by != 1 && by != 4) {
            throw new TdsUnknownPacketType(by, byArray);
        }
        if (byArray[1] == 0) {
            this.setMoreIncomingPackets(true);
        } else {
            this.setMoreIncomingPackets(false);
        }
        int n2 = TdsComm.ntohs(byArray, 2) - 8;
        if (n2 >= this.inBuffer.length) {
            this.inBuffer = new byte[n2];
        }
        if (n2 < 0) {
            throw new TdsException("Error processing returned packet");
        }
        int n3 = 0;
        while (n3 < n2) {
            n3 += this.in.read(this.inBuffer, n3, n2 - n3);
        }
        ++this.packetsReceived;
        this.inBufferLen = n2;
        this.inBufferIndex = 0;
        if (Logger.isActive()) {
            String string = HexDump.hexDump(this.inBuffer, n2);
            String string3 = new Timestamp(System.currentTimeMillis()).toString();
            Logger.println("Instance " + id + " @ " + string3 + " recevied data #" + this.packetsReceived + "\n" + string);
        }
    }

    String getString(int n) throws TdsException, IOException {
        if (this.tdsVer == 70) {
            char[] cArray = new char[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.getByte() & 0xFF;
                int n4 = this.getByte() & 0xFF;
                cArray[n2] = (char)(n3 | n4 << 8);
                ++n2;
            }
            return new String(cArray);
        }
        return new String(this.getBytes(n));
    }

    int getTdsInt() throws TdsException, IOException {
        byte by = this.getByte();
        byte by2 = this.getByte();
        byte by3 = this.getByte();
        byte by4 = this.getByte();
        int n = by & 0xFF;
        int n2 = (by2 & 0xFF) << 8;
        int n3 = (by3 & 0xFF) << 16;
        int n4 = (by4 & 0xFF) << 24;
        int n5 = n4 | n3 | n2 | n;
        return n5;
    }

    long getTdsInt64() throws TdsException, IOException {
        long l = (long)this.getByte() & 0xFFL;
        long l2 = ((long)this.getByte() & 0xFFL) << 8;
        long l3 = ((long)this.getByte() & 0xFFL) << 16;
        long l4 = ((long)this.getByte() & 0xFFL) << 24;
        long l5 = ((long)this.getByte() & 0xFFL) << 32;
        long l6 = ((long)this.getByte() & 0xFFL) << 40;
        long l7 = ((long)this.getByte() & 0xFFL) << 48;
        long l8 = ((long)this.getByte() & 0xFFL) << 56;
        return l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
    }

    int getTdsShort() throws TdsException, IOException {
        int n = this.getByte() & 0xFF;
        int n2 = (this.getByte() & 0xFF) << 8;
        return n | n2;
    }

    boolean isEndOfPacket() {
        return this.inBufferIndex == this.inBufferLen;
    }

    boolean isMoreIncomingPackets() {
        return this.moreIncomingPackets;
    }

    private static int ntohs(byte[] byArray, int n) {
        int n2 = byArray[n + 1] & 0xFF;
        int n3 = (byArray[n] & 0xFF) << 8;
        return n3 | n2;
    }

    byte peek() throws TdsException, IOException {
        byte by = this.getByte();
        this.backup();
        return by;
    }

    synchronized void sendPacket() throws IOException {
        this.sendPhysicalPacket(true);
        this.nextOutBufferIndex = 0;
        this.packetType = 0;
        this.notify();
    }

    private void sendPhysicalPacket(boolean bl) throws IOException {
        if (this.nextOutBufferIndex > 8 || this.packetType == 6) {
            this.storeByte(0, (byte)(this.packetType & 0xFF));
            this.storeByte(1, bl ? (byte)1 : 0);
            this.storeShort(2, (short)this.nextOutBufferIndex);
            this.storeByte(4, (byte)0);
            this.storeByte(5, (byte)0);
            this.storeByte(6, this.tdsVer != 70 ? (byte)0 : 1);
            this.storeByte(7, (byte)0);
            this.out.write(this.outBuffer, 0, this.nextOutBufferIndex);
            ++this.packetsSent;
            if (Logger.isActive()) {
                String string = HexDump.hexDump(this.outBuffer, this.nextOutBufferIndex);
                String string2 = new Timestamp(System.currentTimeMillis()).toString();
                Logger.println("Instance " + id + " @ " + string2 + " sent packet #" + this.packetsSent + "\n" + string);
            }
        }
    }

    void setMoreIncomingPackets(boolean bl) {
        this.moreIncomingPackets = bl;
    }

    void skip(int n) throws TdsException, IOException {
        while (n > 0) {
            this.getByte();
            --n;
        }
    }

    boolean someThreadIsBuildingPacket() {
        return this.packetType != 0;
    }

    synchronized void startPacket(int n) {
        while (this.someThreadIsBuildingPacket()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.packetType = n;
        this.nextOutBufferIndex = 8;
    }

    private void storeByte(int n, byte by) {
        this.outBuffer[n] = by;
    }

    private void storeShort(int n, short s) {
        this.outBuffer[n] = (byte)(s >> 8 & 0xFF);
        this.outBuffer[n + 1] = (byte)(s >> 0 & 0xFF);
    }
}

