/*
 * Decompiled with CFR 0.152.
 */
package com.eg.webservice.util;

import com.eg.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EgSOAPUtil {
    public static String soapEnvelope = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"";

    public static String getSOAPRequest(HashMap operation, String prefix, String targetNamespace) {
        StringBuffer SOAPRequest = null;
        SOAPRequest = new StringBuffer();
        SOAPRequest.append(EgSOAPUtil.getsoapEnvelope(prefix, targetNamespace));
        SOAPRequest.append(EgSOAPUtil.getSOAPBody(operation, prefix));
        SOAPRequest.append("</soapenv:Envelope>");
        return EgSOAPUtil.FormatWSDL(SOAPRequest.toString());
    }

    public static String getSOAPRequest(HashMap operation, String prefix, String targetNamespace, Hashtable values) {
        StringBuffer SOAPRequest = null;
        SOAPRequest = new StringBuffer();
        SOAPRequest.append(EgSOAPUtil.getsoapEnvelope(prefix, targetNamespace));
        SOAPRequest.append(EgSOAPUtil.getSOAPBody(operation, prefix, values));
        SOAPRequest.append("</soapenv:Envelope>");
        return EgSOAPUtil.FormatWSDL(SOAPRequest.toString());
    }

    public static String getSOAPBody(HashMap operation, String prefix, Hashtable values) {
        String previousKey = "";
        StringBuffer SOAPBody = new StringBuffer();
        String headerinputType = (String)operation.get("HeaderInputType");
        if (headerinputType != null && headerinputType.length() > 0) {
            SOAPBody.append("<soapenv:Header>");
            SOAPBody.append("<").append(prefix).append(":").append(headerinputType).append(">");
            HashMap headerinputInfo = (HashMap)operation.get("HeaderInput");
            SOAPBody.append(EgSOAPUtil.userDefinedRequest(headerinputInfo, prefix, values, values, previousKey));
            SOAPBody.append("</").append(prefix).append(":").append(headerinputType).append(">");
            SOAPBody.append("</soapenv:Header>");
        }
        String inputType = (String)operation.get("InputType");
        SOAPBody.append("<soapenv:Body>");
        if (inputType != null && inputType.length() > 0) {
            SOAPBody.append("<").append(prefix).append(":").append(inputType).append(">");
            HashMap inputInfo = (HashMap)operation.get("Input");
            SOAPBody.append(EgSOAPUtil.userDefinedRequest(inputInfo, prefix, values, values, previousKey));
            SOAPBody.append("</").append(prefix).append(":").append(inputType).append(">");
        }
        SOAPBody.append("</soapenv:Body>");
        return SOAPBody.toString();
    }

    public static String getSOAPBody(HashMap operation, String prefix) {
        StringBuffer SOAPBody = new StringBuffer();
        String headerinputType = (String)operation.get("HeaderInputType");
        if (headerinputType != null && headerinputType.length() > 0) {
            SOAPBody.append("<soapenv:Header>");
            SOAPBody.append("<").append(prefix).append(":").append(headerinputType).append(">");
            HashMap headerinputInfo = (HashMap)operation.get("HeaderInput");
            SOAPBody.append(EgSOAPUtil.userDefinedRequest(headerinputInfo, prefix));
            SOAPBody.append("</").append(prefix).append(":").append(headerinputType).append(">");
            SOAPBody.append("</soapenv:Header>");
        }
        String inputType = (String)operation.get("InputType");
        SOAPBody.append("<soapenv:Body>");
        if (inputType != null && inputType.length() > 0) {
            SOAPBody.append("<").append(prefix).append(":").append(inputType).append(">");
            HashMap inputInfo = (HashMap)operation.get("Input");
            SOAPBody.append(EgSOAPUtil.userDefinedRequest(inputInfo, prefix));
            SOAPBody.append("</").append(prefix).append(":").append(inputType).append(">");
        }
        SOAPBody.append("</soapenv:Body>");
        return SOAPBody.toString();
    }

    private static String userDefinedRequest(HashMap userDefined, String prefix, Hashtable values, Hashtable subTable, String previousKey) {
        String sep = "@#@";
        if (previousKey.startsWith("@#@")) {
            previousKey = previousKey.substring(sep.length());
        }
        StringBuilder build = new StringBuilder();
        if (userDefined instanceof HashMap && !userDefined.isEmpty()) {
            for (String attributeName : userDefined.keySet()) {
                String userDataType;
                HashMap checkDataType;
                if (attributeName != null && attributeName.equals("enumeration") || (checkDataType = (HashMap)userDefined.get(attributeName)) == null || checkDataType.isEmpty()) continue;
                String minOccurs = (String)checkDataType.get("minOccurs");
                if (minOccurs != null && minOccurs.equals("0")) {
                    build.append("<!--Optional-->");
                }
                if ((userDataType = (String)checkDataType.get("userDefined")) != null && userDataType.equals("yes")) {
                    String attrValues;
                    Object innerTable;
                    Object innerObject;
                    HashMap typeMap;
                    Object type = checkDataType.get("type");
                    boolean ret = false;
                    if (type instanceof HashMap && (typeMap = (HashMap)type).size() == 0) {
                        ret = true;
                        build.append("<").append(prefix).append(":").append(attributeName).append(">");
                        if (subTable.containsKey(attributeName)) {
                            Object attributeValue = subTable.get(attributeName);
                            if (attributeValue instanceof String) {
                                build.append(attributeValue.toString());
                            }
                        } else if (subTable.containsKey(previousKey)) {
                            Object innerObject2 = subTable.get(previousKey);
                            Hashtable innerTable2 = null;
                            String attrValue = "";
                            if (innerObject2 instanceof Hashtable) {
                                innerTable2 = (Hashtable)innerObject2;
                                if (innerTable2.containsKey(attributeName)) {
                                    attrValue = (String)innerTable2.get(attributeName);
                                }
                            } else {
                                attrValue = innerObject2.toString();
                            }
                            build.append(attrValue);
                        } else {
                            build.append("$$$$UnConfigured");
                        }
                        build.append("</").append(prefix).append(":").append(attributeName).append(">");
                    }
                    if (ret) continue;
                    if (!attributeName.equals("GroupType")) {
                        build.append("<").append(prefix).append(":").append(attributeName).append(">");
                    }
                    if (attributeName.equals("GroupType")) {
                        HashMap choiceMap = (HashMap)checkDataType.get("ref");
                        if (choiceMap == null) {
                            choiceMap = (HashMap)checkDataType.get("base");
                        }
                        Hashtable attributeTable = null;
                        if (values.containsKey(attributeName)) {
                            attributeTable = (Hashtable)values.get(attributeName);
                        } else if (values.containsKey(String.valueOf(previousKey) + "@#@" + attributeName)) {
                            innerObject = values.get(previousKey);
                            innerTable = null;
                            attrValues = "";
                            if (innerObject instanceof Hashtable) {
                                attributeTable = (Hashtable)innerObject;
                            }
                        }
                        if (attributeTable != null) {
                            build.append(EgSOAPUtil.userDefinedRequest(choiceMap, prefix, values, attributeTable, String.valueOf(previousKey) + "@#@" + attributeName));
                        } else {
                            build.append(EgSOAPUtil.userDefinedRequest(choiceMap, prefix, values, values, String.valueOf(previousKey) + "@#@" + attributeName));
                        }
                    } else {
                        Hashtable attributeTable = null;
                        String attrValue = null;
                        if (values.containsKey(attributeName)) {
                            Object val = values.get(attributeName);
                            if (val instanceof Hashtable) {
                                attributeTable = (Hashtable)values.get(attributeName);
                            } else {
                                attrValue = val.toString();
                                if (attrValue != null) {
                                    build.append(attrValue);
                                } else {
                                    build.append("$$$$UnConfigured");
                                }
                            }
                        } else if (subTable.containsKey(attributeName)) {
                            Object attributeValue = subTable.get(attributeName);
                            if (attributeValue instanceof String) {
                                build.append(attributeValue.toString());
                            }
                        } else if (values.containsKey(String.valueOf(previousKey) + "@#@" + attributeName)) {
                            innerObject = values.get(String.valueOf(previousKey) + "@#@" + attributeName);
                            innerTable = null;
                            attrValues = "";
                            if (innerObject instanceof Hashtable) {
                                attributeTable = (Hashtable)innerObject;
                            }
                        } else if (subTable.containsKey(String.valueOf(previousKey) + "@#@" + attributeName)) {
                            innerObject = subTable.get(String.valueOf(previousKey) + "@#@" + attributeName);
                            innerTable = null;
                            attrValues = "";
                            if (innerObject instanceof Hashtable) {
                                attributeTable = (Hashtable)innerObject;
                            }
                        }
                        if (attributeTable != null) {
                            build.append(EgSOAPUtil.userDefinedRequest((HashMap)checkDataType.get("type"), prefix, values, attributeTable, String.valueOf(previousKey) + "@#@" + attributeName));
                        } else if (attributeTable == null) {
                            build.append(EgSOAPUtil.userDefinedRequest((HashMap)checkDataType.get("type"), prefix, values, values, String.valueOf(previousKey) + "@#@" + attributeName));
                        }
                    }
                    if (attributeName.equals("GroupType")) continue;
                    build.append("</").append(prefix).append(":").append(attributeName).append(">");
                    continue;
                }
                build.append("<").append(prefix).append(":").append(attributeName).append(">");
                if (subTable.containsKey(attributeName)) {
                    Object attributeValue = subTable.get(attributeName);
                    if (attributeValue instanceof String) {
                        build.append(attributeValue.toString());
                    }
                } else if (subTable.containsKey(previousKey)) {
                    Object innerObject = subTable.get(previousKey);
                    Hashtable innerTable = null;
                    String attrValue = "";
                    if (innerObject instanceof Hashtable && (innerTable = (Hashtable)innerObject).containsKey(attributeName)) {
                        attrValue = (String)innerTable.get(attributeName);
                    }
                    build.append(attrValue);
                } else {
                    build.append("$$$$UnConfigured");
                }
                build.append("</").append(prefix).append(":").append(attributeName).append(">");
            }
        }
        return build.toString();
    }

    private static String userDefinedRequest(HashMap userDefined, String prefix) {
        StringBuilder build = new StringBuilder();
        if (userDefined instanceof HashMap && !userDefined.isEmpty()) {
            for (String attributeName : userDefined.keySet()) {
                String userDataType;
                HashMap checkDataType;
                if (attributeName != null && attributeName.equals("enumeration") || (checkDataType = (HashMap)userDefined.get(attributeName)) == null || checkDataType.isEmpty()) continue;
                String minOccurs = (String)checkDataType.get("minOccurs");
                if (minOccurs != null && minOccurs.equals("0")) {
                    build.append("<!--Optional-->");
                }
                if ((userDataType = (String)checkDataType.get("userDefined")) != null && userDataType.equals("yes")) {
                    if (!attributeName.equals("GroupType")) {
                        build.append("<").append(prefix).append(":").append(attributeName).append(">");
                    }
                    if (attributeName.equals("GroupType")) {
                        HashMap choiceMap = (HashMap)checkDataType.get("ref");
                        if (choiceMap == null) {
                            choiceMap = (HashMap)checkDataType.get("base");
                        }
                        build.append(EgSOAPUtil.userDefinedRequest(choiceMap, prefix));
                    } else {
                        build.append(EgSOAPUtil.userDefinedRequest((HashMap)checkDataType.get("type"), prefix));
                    }
                    if (attributeName.equals("GroupType")) continue;
                    build.append("</").append(prefix).append(":").append(attributeName).append(">");
                    continue;
                }
                build.append("<").append(prefix).append(":").append(attributeName).append(">");
                build.append("$UnConfigured");
                build.append("</").append(prefix).append(":").append(attributeName).append(">");
            }
        }
        return build.toString();
    }

    public static String invokeOperation(String xmlInput, String targetURL) {
        return EgSOAPUtil.invokeOperation(xmlInput, "", targetURL);
    }

    public static String invokeOperation(String xmlInput, String SOAPActionUrl, String targetURL) {
        return EgSOAPUtil.invokeOperation(xmlInput, SOAPActionUrl, targetURL, null, null);
    }

    public static String invokeOperation(String xmlInput, String SOAPActionUrl, String targetURL, String userName, String passWord) {
        String responseString = null;
        String cause = "";
        try {
            SOAPConnectionFactory conFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = conFactory.createConnection();
            MessageFactory msgFactory = MessageFactory.newInstance();
            SOAPMessage message = msgFactory.createMessage();
            SOAPPart soapPart = message.getSOAPPart();
            MimeHeaders headers = message.getMimeHeaders();
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            if (SOAPActionUrl != null && SOAPActionUrl.length() > 0) {
                headers.addHeader("SOAPAction", SOAPActionUrl);
            }
            if (userName != null && userName.length() > 0 && passWord != null && passWord.length() > 0 && !userName.equalsIgnoreCase("none") && !passWord.equalsIgnoreCase("none")) {
                String authorization = Base64Coder.encodeString((String)(String.valueOf(userName) + ":" + passWord));
                headers.addHeader("Authorization", "Basic " + authorization);
            }
            byte[] buffer = xmlInput.getBytes();
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
            StreamSource source = new StreamSource(stream);
            soapPart.setContent((Source)source);
            message.saveChanges();
            URL endpoint = new URL(targetURL);
            ByteArrayOutputStream msgStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)msgStream);
            SOAPMessage response = connection.call(message, (Object)endpoint);
            Source responseContent = response.getSOAPPart().getContent();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult streamResult = new StreamResult(sw);
            transformer.transform(responseContent, streamResult);
            responseString = sw.toString();
            connection.close();
        }
        catch (Exception e) {
            System.out.println("Exception Occured while invoking Operation ... ");
            cause = "<Error>" + e.getMessage();
        }
        if (responseString == null) {
            responseString = cause;
        }
        return responseString;
    }

    public static String getException(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    private static String getsoapEnvelope(String prefix, String targetNamespace) {
        StringBuffer toReturn = new StringBuffer();
        toReturn.append(" xmlns:").append(prefix).append("=").append("\"").append(targetNamespace).append("\"").append(">");
        return String.valueOf(soapEnvelope) + toReturn.toString();
    }

    public static String parseSOAPResponse() {
        return null;
    }

    private static Document parseXmlFile(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatXML(String unformattedXml) {
        String formattedString = null;
        try {
            Document document = EgSOAPUtil.parseXmlFile(unformattedXml);
            OutputFormat format = new OutputFormat(document);
            format.setIndenting(true);
            format.setIndent(3);
            format.setOmitXMLDeclaration(true);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            formattedString = ((Object)out).toString();
        }
        catch (Exception e) {
            System.out.println(" Exception Occcured in formatXML");
            e.printStackTrace();
        }
        return formattedString;
    }

    public static String FormatWSDL(String xml) {
        StreamResult result = null;
        StringWriter writer = null;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xml.getBytes()));
            DOMSource source = new DOMSource(document);
            writer = new StringWriter();
            result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (writer != null) {
            return writer.toString();
        }
        return xml;
    }

    public static ArrayList getComplexTypes(String attributeName) {
        ArrayList<String> complexType = new ArrayList<String>();
        if (!complexType.contains(attributeName)) {
            complexType.add(attributeName);
        }
        return complexType;
    }
}

