/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util.multipart;

import com.egurkha.util.multipart.BufferedServletInputStream;
import com.egurkha.util.multipart.FilePart;
import com.egurkha.util.multipart.LimitedServletInputStream;
import com.egurkha.util.multipart.ParamPart;
import com.egurkha.util.multipart.Part;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class MultipartParser {
    private ServletInputStream in;
    private String boundary;
    private FilePart lastFilePart;
    private byte[] buf = new byte[8192];
    private static String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding = DEFAULT_ENCODING;

    public MultipartParser(HttpServletRequest httpServletRequest, int n) throws IOException {
        this(httpServletRequest, n, true, true);
    }

    public MultipartParser(HttpServletRequest httpServletRequest, int n, boolean bl, boolean bl2) throws IOException {
        this(httpServletRequest, n, bl, bl2, null);
    }

    public MultipartParser(HttpServletRequest httpServletRequest, int n, boolean bl, boolean bl2, String string) throws IOException {
        String string2;
        if (string != null) {
            this.setEncoding(string);
        }
        String string3 = null;
        String string4 = httpServletRequest.getHeader("Content-Type");
        String string5 = httpServletRequest.getContentType();
        if (string4 == null && string5 != null) {
            string3 = string5;
        } else if (string5 == null && string4 != null) {
            string3 = string4;
        } else if (string4 != null && string5 != null) {
            String string6 = string3 = string4.length() > string5.length() ? string4 : string5;
        }
        if (string3 == null || !string3.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int n2 = httpServletRequest.getContentLength();
        if (n2 > n) {
            throw new IOException("Posted content length of " + n2 + " exceeds limit of " + n);
        }
        String string7 = this.extractBoundary(string3);
        if (string7 == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        if (bl) {
            servletInputStream = new BufferedServletInputStream(servletInputStream);
        }
        if (bl2) {
            servletInputStream = new LimitedServletInputStream(servletInputStream, n2);
        }
        this.in = servletInputStream;
        this.boundary = string7;
        do {
            if ((string2 = this.readLine()) != null) continue;
            throw new IOException("Corrupt form data: premature ending");
        } while (!string2.startsWith(string7));
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        var1_1 = new Vector<String>();
        var2_2 = this.readLine();
        if (var2_2 == null) {
            return null;
        }
        if (var2_2.length() != 0) ** GOTO lbl21
        return null;
lbl-1000:
        // 1 sources

        {
            var3_3 = null;
            var4_4 = true;
            while (var4_4) {
                var3_3 = this.readLine();
                if (var3_3 != null && (var3_3.startsWith(" ") || var3_3.startsWith("\t"))) {
                    var2_2 = var2_2 + var3_3;
                    continue;
                }
                var4_4 = false;
            }
            var1_1.addElement(var2_2);
            var2_2 = var3_3;
lbl21:
            // 2 sources

            ** while (var2_2 != null && var2_2.length() > 0)
        }
lbl22:
        // 1 sources

        if (var2_2 == null) {
            return null;
        }
        var3_3 = null;
        var4_5 = null;
        var5_6 = null;
        var6_7 /* !! */  = "text/plain";
        var7_8 = var1_1.elements();
        while (var7_8.hasMoreElements()) {
            var8_9 = (String)var7_8.nextElement();
            if (var8_9.toLowerCase().startsWith("content-disposition:")) {
                var9_10 /* !! */  = this.extractDispositionInfo(var8_9);
                var3_3 = var9_10 /* !! */ [1];
                var4_5 = var9_10 /* !! */ [2];
                var5_6 = var9_10 /* !! */ [3];
                continue;
            }
            if (!var8_9.toLowerCase().startsWith("content-type:") || (var9_10 /* !! */  = MultipartParser.extractContentType(var8_9)) == null) continue;
            var6_7 /* !! */  = var9_10 /* !! */ ;
        }
        if (var4_5 == null) {
            return new ParamPart(var3_3, this.in, this.boundary, this.encoding);
        }
        if (var4_5.equals("")) {
            var4_5 = null;
        }
        this.lastFilePart = new FilePart(var3_3, this.in, this.boundary, (String)var6_7 /* !! */ , var4_5, var5_6);
        return this.lastFilePart;
    }

    private String extractBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }

    private String[] extractDispositionInfo(String string) throws IOException {
        String[] stringArray = new String[4];
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string3 = string.substring(n + 21, n2);
        if (!string3.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        int n3 = 6;
        if (n == -1 || n2 == -1) {
            n = string.indexOf("name=", n2);
            n2 = string.indexOf(";", n + 6);
            if (n == -1) {
                throw new IOException("Content disposition corrupt: " + string2);
            }
            if (n2 == -1) {
                n2 = string.length();
            }
            n3 = 5;
        }
        String string4 = string2.substring(n + n3, n2);
        String string5 = null;
        String string6 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string6 = string5 = string2.substring(n + 10, n2);
            int n4 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n4 > -1) {
                string5 = string5.substring(n4 + 1);
            }
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string5;
        stringArray[3] = string6;
        return stringArray;
    }

    private static String extractContentType(String string) throws IOException {
        int n = (string = string.toLowerCase()).indexOf(";");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(13, n).trim();
    }

    private String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            stringBuffer.append(new String(this.buf, 0, n, this.encoding));
        } while (n == this.buf.length);
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n2 = stringBuffer.length();
        if (n2 >= 2 && stringBuffer.charAt(n2 - 2) == '\r') {
            stringBuffer.setLength(n2 - 2);
        } else if (n2 >= 1 && stringBuffer.charAt(n2 - 1) == '\n') {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }
}

