/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import oracle.core.ojdl.ExceptionHandler;
import oracle.core.ojdl.ExceptionHandlerIntf;
import oracle.core.ojdl.LogManagerInitException;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.UniqueCounter;

public class LogManager {
    private static final String PROPERTIES_PREFIX = "oracle.core.ojdl.";
    private static final int MAX_UNIQUE_ID_LEN = 64;
    private String m_processId = null;
    private String m_encoding = LogManager.checkEncoding(null);
    private ExceptionHandlerIntf m_exnHandler = new ExceptionHandler(false);
    private Properties m_properties = null;
    private long m_initCount = 0L;
    private Vector m_writers = null;
    private LogWriter m_globalLogWriter;
    private String m_startId;
    private boolean m_debug = false;
    private static LogManager s_globalManager;
    private static String s_alternateProcessId;

    protected LogManager() {
    }

    public static LogManager getLogManager() {
        return s_globalManager;
    }

    public synchronized void init(Properties properties) throws LogManagerInitException {
        if (++this.m_initCount > 1L) {
            return;
        }
        this.m_properties = properties;
        if (this.getProperty("Debug", "false").equals("true")) {
            this.m_exnHandler = new ExceptionHandler(true);
            this.m_debug = true;
        } else {
            this.m_exnHandler = new ExceptionHandler(false);
            this.m_debug = false;
        }
        String string = this.getProperty("ProcessId");
        if (string != null) {
            this.setProcessId(string);
        }
        this.m_startId = null;
        String string2 = this.getProperty("Encoding");
        this.m_encoding = LogManager.checkEncoding(string2);
        this.m_writers = new Vector();
        LogMessage.initDefaultValues();
    }

    public synchronized void term() {
        if (--this.m_initCount > 0L) {
            return;
        }
        this.m_properties = null;
        this.m_processId = null;
        this.m_exnHandler = null;
        if (this.m_globalLogWriter != null) {
            this.m_globalLogWriter.close();
            this.m_globalLogWriter = null;
        }
        if (this.m_writers != null) {
            for (int i = 0; i < this.m_writers.size(); ++i) {
                ((LogWriter)this.m_writers.elementAt(i)).close();
            }
            this.m_writers = null;
        }
    }

    public synchronized void setExceptionHandler(ExceptionHandlerIntf exceptionHandlerIntf) {
        this.m_exnHandler = exceptionHandlerIntf;
    }

    public ExceptionHandlerIntf getExceptionHandler() {
        return this.m_exnHandler;
    }

    public String getUniqueId() {
        if (this.m_startId == null) {
            String string;
            String string2 = null;
            try {
                string = InetAddress.getLocalHost().getHostAddress();
                string2 = LogManager.hashIt(string);
            }
            catch (Exception exception) {
                string2 = LogManager.hashIt("127.0.0.1");
            }
            string = this.getProcessId();
            if (string == null) {
                string = s_alternateProcessId;
            }
            this.m_startId = string2 + ":" + string;
            int n = 24;
            if (this.m_startId.length() > n) {
                this.m_startId = this.m_startId.substring(0, n);
            }
            this.m_startId = this.m_startId + ":";
        }
        return this.m_startId + System.currentTimeMillis() + ":" + UniqueCounter.next();
    }

    public synchronized void setProcessId(String string) {
        this.m_processId = string;
    }

    public String getProcessId() {
        return this.m_processId;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public synchronized void setGlobalLogWriter(LogWriter logWriter) {
        this.m_globalLogWriter = logWriter;
    }

    public LogWriter getGlobalLogWriter() {
        return this.m_globalLogWriter;
    }

    static String checkEncoding(String string) {
        if (string != null) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(0), string);
                return outputStreamWriter.getEncoding();
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new ByteArrayOutputStream(0));
            return outputStreamWriter.getEncoding();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isActive() {
        return this.m_initCount > 0L;
    }

    String getProperty(String string, String string2) {
        if (this.m_properties == null) {
            return string2;
        }
        return this.m_properties.getProperty(PROPERTIES_PREFIX + string, string2);
    }

    String getProperty(String string) {
        return this.getProperty(string, null);
    }

    synchronized void addLogWriter(LogWriter logWriter) {
        if (this.isActive()) {
            this.m_writers.addElement(logWriter);
        }
    }

    synchronized void removeLogWriter(LogWriter logWriter) {
        if (this.isActive() && !this.m_writers.removeElement(logWriter)) {
            this.getExceptionHandler().onException(new LoggingException("Attempt to remove nonexistant LogWriter"));
        }
    }

    boolean getDebugMode() {
        return this.m_debug;
    }

    void debug(String string) {
        if (this.m_debug) {
            System.err.println(string);
        }
    }

    private static String hashIt(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n ^= byArray[i] << i % 4 * 8;
            }
            n &= Integer.MAX_VALUE;
            string2 = Integer.toString(n |= 0x40000000);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return string2;
    }

    static {
        s_alternateProcessId = null;
        s_globalManager = new LogManager();
        try {
            Random random = new Random();
            s_alternateProcessId = Integer.toString(random.nextInt(100000));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

