/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.console.DMSError;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.LoggerFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.SensorFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.instrument.CorrelationContext;
import oracle.dms.instrument.EventFactory;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.LoggerFactory;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounFactory;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.PhaseEventFactory;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorFactory;
import oracle.dms.instrument.StateFactory;
import oracle.dms.instrument.TransTrace;
import oracle.dms.instrument.TransTraceIntf;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class DMSConsole
extends oracle.dms.console.DMSConsole {
    public static final int NONE = 0;
    public static final int NORMAL = 5;
    public static final int HEAVY = 10;
    public static final int ALL = Integer.MAX_VALUE;
    private static int SENSOR_WEIGHT = 5;
    public static long UNITS = 1000L;
    private static Clock _clock = null;
    public static final int PRE_INIT = 0;
    public static final int ACTIVE = 1;
    public static final int SHUTDOWN = 2;
    public static final int INCONSISTENT = 3;
    private static int _status = 0;
    private static EventFactoryIntf _eventFactory;
    private static NounFactoryIntf _nounFactory;
    private static PhaseEventFactoryIntf _phaseEventFactory;
    private static SensorFactoryIntf _sensorFactory;
    private static StateFactoryIntf _stateFactory;
    private static LoggerFactoryIntf _loggerFactory;
    private static TransTraceIntf _transTrace;

    public EventFactoryIntf newEventFactory() {
        _eventFactory = new EventFactory();
        return _eventFactory;
    }

    public NounFactoryIntf newNounFactory() {
        _nounFactory = new NounFactory();
        return _nounFactory;
    }

    public PhaseEventFactoryIntf newPhaseEventFactory() {
        _phaseEventFactory = new PhaseEventFactory();
        return _phaseEventFactory;
    }

    public SensorFactoryIntf newSensorFactory() {
        _sensorFactory = new SensorFactory();
        return _sensorFactory;
    }

    public StateFactoryIntf newStateFactory() {
        _stateFactory = new StateFactory();
        return _stateFactory;
    }

    public LoggerFactoryIntf newLoggerFactory() {
        _loggerFactory = new LoggerFactory();
        return _loggerFactory;
    }

    public synchronized EventFactoryIntf getEventFactory() {
        if (_eventFactory == null) {
            _eventFactory = new EventFactory();
        }
        return _eventFactory;
    }

    public synchronized NounFactoryIntf getNounFactory() {
        if (_nounFactory == null) {
            _nounFactory = new NounFactory();
        }
        return _nounFactory;
    }

    public synchronized PhaseEventFactoryIntf getPhaseEventFactory() {
        if (_phaseEventFactory == null) {
            _phaseEventFactory = new PhaseEventFactory();
        }
        return _phaseEventFactory;
    }

    public synchronized SensorFactoryIntf getSensorFactory() {
        if (_sensorFactory == null) {
            _sensorFactory = new SensorFactory();
        }
        return _sensorFactory;
    }

    public synchronized StateFactoryIntf getStateFactory() {
        if (_stateFactory == null) {
            _stateFactory = new StateFactory();
        }
        return _stateFactory;
    }

    public synchronized LoggerFactoryIntf getLoggerFactory() {
        if (_loggerFactory == null) {
            _loggerFactory = new LoggerFactory();
        }
        return _loggerFactory;
    }

    public synchronized TransTraceIntf getTransTrace() {
        if (_transTrace == null) {
            _transTrace = new TransTrace();
        }
        return _transTrace;
    }

    public void setProcessID(int n) {
        DMSUtil.setProcessID(n);
    }

    public int getProcessID() {
        return DMSUtil.getProcessID();
    }

    public void init(String string) throws DMSError {
        this.init(string, null);
    }

    public void init(String string, Properties properties) throws DMSError {
        try {
            DMSConsole.initClock(properties);
            this.initWeight();
            Spy.init(string, properties);
        }
        catch (Exception exception) {
            throw new DMSError(exception.toString());
        }
        _status = 1;
    }

    public void setName(String string) {
        Spy.setName(string);
    }

    public String getName() {
        return Spy.getName();
    }

    public Object getMetricValue(String string) {
        return Spy.getMetricValue(string);
    }

    public void exit() {
        this.exit(true);
    }

    public synchronized void exit(boolean bl) {
        if (bl) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Spy.exit();
                    return null;
                }
            });
        } else {
            Spy.exit(false);
        }
        CorrelationContext.shutdown();
        ExecutionContext.shutdown();
        Noun.shutdown();
        PhaseEvent.shutdown();
        Sensor.shutdown();
        TransTrace.shutdown();
        ClockManager.shutdown();
        _clock = null;
        SENSOR_WEIGHT = 5;
        _status = 2;
    }

    public boolean isActive() {
        return Spy.isActive();
    }

    public void setDumpFile(String string) {
        Spy.setDumpFile(string);
    }

    public String getDumpFile() {
        return Spy.getDumpFile();
    }

    public void dump() {
        Spy.dump();
    }

    public void dump(String string, boolean bl, boolean bl2) {
        Spy.dump(string, bl, bl2);
    }

    public void dump(PrintWriter printWriter, boolean bl) throws IOException {
        Spy.dump(printWriter, bl);
    }

    public void dump(PrintWriter printWriter, String string) {
        Noun.getRoot().dump(printWriter, string);
    }

    public void dump(String string, String string2, boolean bl) {
        Noun.getRoot().dump(string, string2, bl);
    }

    private void initWeight() {
        block8: {
            String string = null;
            try {
                string = DMSProperties.getProperty("oracle.dms.sensors");
                if (string == null) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            try {
                SENSOR_WEIGHT = Integer.parseInt(string);
            }
            catch (Exception exception) {
                if (string.equalsIgnoreCase("ALL")) {
                    SENSOR_WEIGHT = Integer.MAX_VALUE;
                }
                if (string.equalsIgnoreCase("NONE")) {
                    SENSOR_WEIGHT = 0;
                }
                if (string.equalsIgnoreCase("NORMAL")) {
                    SENSOR_WEIGHT = 5;
                }
                if (!string.equalsIgnoreCase("HEAVY")) break block8;
                SENSOR_WEIGHT = 10;
            }
        }
    }

    public static boolean setSensorWeightOff() {
        if (_clock != null) {
            return false;
        }
        SENSOR_WEIGHT = 0;
        return true;
    }

    public static int getSensorWeight() {
        return SENSOR_WEIGHT;
    }

    private static void initClock(Properties properties) {
        String string = null;
        String string2 = null;
        if (properties != null) {
            string = properties.getProperty("oracle.dms.clock");
            string2 = properties.getProperty("oracle.dms.clock.units");
        }
        if (string == null) {
            string = DMSProperties.getProperty("oracle.dms.clock");
        }
        if (string2 == null) {
            string2 = DMSProperties.getProperty("oracle.dms.clock.units");
        }
        if (string == null) {
            string = "default";
        }
        _clock = ClockManager.setClock(string);
        UNITS = string2 == null || _clock.getName().equals("logical") ? _clock.getReportedFrequency() : ClockManager.getFrequency(string2);
    }

    public static Clock getClock() {
        if (_clock == null) {
            DMSConsole.initClock(null);
        }
        return _clock;
    }

    public void debug(String string) {
        DMSConsole._debug(string);
    }

    public static void _debug(String string) {
        try {
            System.err.println("<DMSDEBUG> " + string + " </DMSDEBUG>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getStatus() {
        if (_status == 0 || _status == 2) {
            if (Spy.isActive()) {
                return 3;
            }
            if (_clock != null || _eventFactory != null || _phaseEventFactory != null || _sensorFactory != null || _stateFactory != null || _loggerFactory != null || _transTrace != null || _nounFactory != null) {
                return 3;
            }
            return _status;
        }
        if (_status == 1) {
            if (!Spy.isActive() || Noun.getRoot() == null) {
                return 3;
            }
            if (_clock == null) {
                return 3;
            }
            return _status;
        }
        return 3;
    }
}

