/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.clock.ClockManager;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.State;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;

public class RollupSensor
extends Sensor {
    private static final byte STATE = 0;
    private static final byte EVENT = 1;
    private static final byte PHASE_EVENT = 2;
    private static final String STATE_NAME = "State";
    private static final String EVENT_NAME = "Event";
    private static final String PHASE_EVENT_NAME = "PhaseEvent";
    private static final int MAX_COUNT = 6;
    private static int[] s_max = new int[3];
    private byte m_type;
    private byte m_state_type;
    private String m_units = null;
    private int m_count;
    private int m_derived = 0;
    private double m_avg = 0.0;
    private Number m_sum;
    private Number m_max;
    private Number m_min;
    private long m_time = 0L;
    private int m_active = 0;

    private RollupSensor() {
    }

    private RollupSensor(Noun noun, Sensor sensor, byte by) {
        super(noun, sensor.getName(), "rollup sensor for " + sensor.getName());
        this.m_type = by;
        this.m_count = sensor.getDescriptor().getMetricCount();
        switch (by) {
            case 0: {
                this.createStateMetrics((State)sensor);
                break;
            }
            case 1: {
                this.createEventMetrics((Event)sensor);
                break;
            }
            case 2: {
                this.createPhaseEventMetrics((PhaseEvent)sensor);
            }
        }
    }

    private void createStateMetrics(State state) {
        Object var2_2 = null;
        Metric metric = state.getMetric(1);
        if (metric == null) {
            return;
        }
        this.m_units = metric.getUnits();
        this.m_state_type = state.getValueType();
        this._metrics[4] = new Metric(this._name + ".sum", this._description, this.m_units, this, false, this.m_state_type, 4);
        this._metrics[5] = new Metric(this._name + ".avg", this._description, this.m_units, this, false, 1, 5);
        metric = state.getMetric(8);
        if (metric != null) {
            this._metrics[3] = new Metric(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, 3);
            this.m_derived |= 8;
        }
        if ((metric = state.getMetric(4)) != null) {
            this._metrics[2] = new Metric(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, 2);
            this.m_derived |= 4;
        }
    }

    private void createEventMetrics(Event event) {
        this._metrics[4] = new Metric(this._name + ".sum", this._description, "ops", this, false, 3, 4);
        this._metrics[5] = new Metric(this._name + ".avg", this._description, "ops", this, false, 1, 5);
    }

    private void createPhaseEventMetrics(PhaseEvent phaseEvent) {
        this.m_units = ClockManager.getUnits(DMSConsole.UNITS);
        Metric metric = null;
        this._metrics[0] = new Metric(this._name + ".time", this._description, this.m_units, this, false, 2, 0);
        metric = phaseEvent.getMetric(4);
        if (metric != null) {
            this._metrics[2] = new Metric(this._name + ".minTime", this._description, this.m_units, this, false, 2, 2);
            this.m_derived |= 4;
        }
        if ((metric = phaseEvent.getMetric(8)) != null) {
            this._metrics[3] = new Metric(this._name + ".maxTime", this._description, this.m_units, this, false, 2, 3);
            this.m_derived |= 8;
        }
        if ((metric = phaseEvent.getMetric(2)) != null) {
            this._metrics[1] = new Metric(this._name + ".completed", this._description, "ops", this, false, 3, 1);
            this.m_derived |= 2;
        }
        if ((metric = phaseEvent.getMetric(32)) != null && this._metrics[1] != null) {
            this._metrics[5] = new Metric(this._name + ".avg", this._description, this.m_units, this, false, 1, 5);
            this.m_derived |= 0x20;
        }
        if ((metric = phaseEvent.getMetric(64)) != null) {
            this._metrics[6] = new Metric(this._name + ".active", this._description, "threads", this, false, 3, 6);
            this.m_derived |= 0x40;
        }
    }

    protected static RollupSensor create(Noun noun, Sensor sensor) {
        String string = null;
        byte by = 0;
        if (sensor == null || (string = sensor.getDescriptor().getType()) == null) {
            return null;
        }
        if (string.equals(EVENT_NAME)) {
            by = 1;
        } else if (string.equals(PHASE_EVENT_NAME)) {
            by = 2;
        } else if (string.equals(STATE_NAME)) {
            by = 0;
            if (((State)sensor).getValueType() == 5) {
                return null;
            }
        } else {
            return null;
        }
        return new RollupSensor(noun, sensor, by);
    }

    protected void update(Noun[] nounArray, String string) {
        switch (this.m_type) {
            case 0: {
                this.updateState(nounArray, string);
                break;
            }
            case 1: {
                this.updateEvent(nounArray, string);
                break;
            }
            case 2: {
                this.updatePhaseEvent(nounArray, string);
            }
        }
    }

    private void updateState(Noun[] nounArray, String string) {
        Metric metric = null;
        Number number = null;
        int n = 0;
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < nounArray.length; ++i) {
            if (string.equals(nounArray[i].getType())) {
                ++n;
                State state = (State)nounArray[i].getSensor(this._name);
                if (state == null) continue;
                metric = state.getMetric(1);
                number = (Number)state.getValue(metric);
                d += number.doubleValue();
                metric = state.getMetric(4);
                if (metric != null && (d4 = (number = (Number)state.getValue(metric)).doubleValue()) < d2) {
                    d2 = d4;
                }
                if ((metric = state.getMetric(8)) != null && (d5 = (number = (Number)state.getValue(metric)).doubleValue()) > d3) {
                    d3 = d5;
                }
            }
            switch (this.m_state_type) {
                case 3: {
                    this.m_sum = new Integer((int)d);
                    if (this._metrics[2] != null) {
                        this.m_min = new Integer((int)d2);
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = new Integer((int)d3);
                    break;
                }
                case 2: {
                    this.m_sum = new Long((long)d);
                    if (this._metrics[2] != null) {
                        this.m_min = new Long((long)d2);
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = new Long((long)d3);
                    break;
                }
                case 1: {
                    this.m_sum = new Double(d);
                    if (this._metrics[2] != null) {
                        this.m_min = new Double(d2);
                    }
                    if (this._metrics[3] == null) break;
                    this.m_max = new Double(d3);
                }
            }
            this.m_avg = d / (double)n;
        }
    }

    private void updateEvent(Noun[] nounArray, String string) {
        Event event = null;
        int n = 0;
        int n2 = 0;
        Integer n3 = null;
        for (int i = 0; i < nounArray.length; ++i) {
            event = (Event)nounArray[i].getSensor(this._name);
            if (event == null) continue;
            n3 = (Integer)event.getValue();
            n += n3.intValue();
            ++n2;
        }
        this.m_sum = new Integer(n);
        this.m_avg = (double)n / (double)n2;
    }

    private void updatePhaseEvent(Noun[] nounArray, String string) {
        PhaseEvent phaseEvent = null;
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MIN_VALUE;
        int n = 0;
        int n2 = 0;
        Number number = null;
        long l4 = 0L;
        for (int i = 0; i < nounArray.length; ++i) {
            phaseEvent = (PhaseEvent)nounArray[i].getSensor(this._name);
            if (phaseEvent == null) continue;
            number = (Long)phaseEvent.getValue(1);
            l += number.longValue();
            number = (Integer)phaseEvent.getValue(2);
            if (number != null) {
                n2 += number.intValue();
            }
            if ((number = (Integer)phaseEvent.getValue(64)) != null) {
                n += number.intValue();
            }
            if ((number = (Long)phaseEvent.getValue(4)) != null && (l4 = number.longValue()) < l2) {
                l2 = l4;
            }
            if ((number = (Long)phaseEvent.getValue(8)) == null || (l4 = number.longValue()) <= l3) continue;
            l3 = l4;
        }
        this.m_time = l;
        this.m_sum = new Integer(n2);
        this.m_active = n;
        this.m_min = new Long(l2);
        this.m_max = new Long(l3);
        if (n2 > 0 && (this.m_derived & 0x20) == 32) {
            this.m_avg = (double)l / (double)n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric metric) {
        if (metric == null) {
            throw new InstrumentationException("metric is null!" + this);
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte by = metric.getIndex();
        if (this._metrics[by] != metric) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to this RollupSensor" + this);
        }
        RollupSensor rollupSensor = this;
        synchronized (rollupSensor) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (by) {
                case 4: {
                    return this.m_sum;
                }
                case 0: {
                    return new Long(this.m_time);
                }
                case 1: {
                    return this.m_sum;
                }
                case 2: {
                    return this.m_min;
                }
                case 3: {
                    return this.m_max;
                }
                case 6: {
                    return new Integer(this.m_active);
                }
                case 5: {
                    return new Double(this.m_avg);
                }
            }
        }
        return null;
    }

    public void deriveMetric(int n) {
        int n2 = (n | this.m_derived) ^ this.m_derived;
        if (n2 == 0) {
            return;
        }
        if (this.m_type == 1) {
            return;
        }
        if (this.m_type == 0) {
            if ((n2 & 4) != 0) {
                this._metrics[2] = new Metric(this._name + ".minValue", this._description, this.m_units, this, false, this.m_state_type, 2);
                this.m_derived |= 4;
            }
            if ((n2 & 8) != 0) {
                this._metrics[3] = new Metric(this._name + ".maxValue", this._description, this.m_units, this, false, this.m_state_type, 3);
                this.m_derived |= 8;
            }
        }
        if (this.m_type == 2) {
            if ((n2 & 4) != 0) {
                this._metrics[2] = new Metric(this._name + ".minTime", this._description, this.m_units, this, false, 2, 2);
                this.m_derived |= 4;
            }
            if ((n2 & 8) != 0) {
                this._metrics[3] = new Metric(this._name + ".maxTime", this._description, this.m_units, this, false, 2, 3);
                this.m_derived |= 8;
            }
            if ((n2 & 2) != 0) {
                this._metrics[1] = new Metric(this._name + ".completed", this._description, "ops", this, false, 3, 1);
                this.m_derived |= 2;
            }
            if ((n2 & 0x20) != 0 && this._metrics[1] != null) {
                this._metrics[5] = new Metric(this._name + ".avg", this._description, this.m_units, this, false, 1, 5);
                this.m_derived |= 0x20;
            }
            if ((n2 & 0x40) != 0) {
                this._metrics[6] = new Metric(this._name + ".active", this._description, "threads", this, false, 3, 6);
                this.m_derived |= 0x40;
            }
        }
    }

    protected void updateMetrics(Sensor sensor) {
        if (this.m_type != 0 && this.m_type != 2) {
            return;
        }
        SensorDescriptor sensorDescriptor = sensor.getDescriptor();
        int n = sensorDescriptor.getMetricCount();
        SensorDescriptor sensorDescriptor2 = this.getDescriptor();
        int n2 = sensorDescriptor2.getMetricCount();
        String[] stringArray = null;
        int n3 = 0;
        if (this.m_type == 0) {
            if (n2 == n + 1) {
                return;
            }
            stringArray = sensorDescriptor.getMetricNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith("minValue")) {
                    n3 |= 4;
                }
                if (!stringArray[i].endsWith("maxValue")) continue;
                n3 |= 8;
            }
            this.deriveMetric(n3);
            return;
        }
        if (n2 == n || n2 == 6) {
            return;
        }
        stringArray = sensorDescriptor.getMetricNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].endsWith("minTime")) {
                n3 |= 4;
            }
            if (stringArray[i].endsWith("maxTime")) {
                n3 |= 8;
            }
            if (stringArray[i].endsWith("completed")) {
                n3 |= 2;
            }
            if (stringArray[i].endsWith("active")) {
                n3 |= 0x40;
            }
            if (!stringArray[i].endsWith("avg")) continue;
            n3 |= 0x20;
        }
        this.deriveMetric(n3);
    }

    public void reset() {
    }

    static {
        RollupSensor.s_max[0] = 3;
        RollupSensor.s_max[1] = 1;
        RollupSensor.s_max[2] = 7;
    }
}

