/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.State;
import oracle.dms.instrument.TracerRecord;
import oracle.dms.instrument.TransTrace;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSUtil;

public class Tracer
extends Sensor {
    public static final int EVENT_OCCURRED = 0;
    public static final int PHASE_START = 1;
    public static final int PHASE_STOP = 2;
    public static final int PHASE_ABORT = 3;
    public static final int STATE_UPDATE = 4;
    public static final int REQUEST_BEGIN = 5;
    public static final int REQUEST_END = 6;
    public static final int NOUN_CREATE = 7;
    public static final int STATE_CREATE = 8;
    public static final int STATE_VALUE = 9;
    public static final int TRACE_FULL = 10;
    public static final int UNKNOWN = 11;
    public static final String[] ActionList = new String[12];
    private static final String DUMMY_VAL = "";
    private static int s_maxRecords;
    private static Object s_globalLock;
    private Vector m_theTrace = new Vector(50);
    private Hashtable m_nounTab = new Hashtable();
    private int m_startRecDex = 0;
    private TracerRecord m_beginRec = null;
    private boolean m_triggered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer create(String string, String string2, Tracer tracer) {
        Object object;
        Object object2;
        Object object3;
        if (string == null || string.length() == 0 || string2 == null || tracer == null) {
            throw new InstrumentationException("Tracer.create(): bad parameters");
        }
        Tracer tracer2 = (Tracer)Sensor.lookupCache(string = DMSUtil.sanitize(string, 511, true, true));
        if (tracer2 == null) {
            object3 = Sensor.createParent(string);
            object2 = DMSUtil.getLeafFromPath(string);
            object = object3;
            synchronized (object) {
                tracer2 = (Tracer)((Noun)object3).getSensor((String)object2);
                if (tracer2 != null) {
                    tracer2.addToCache(string);
                } else {
                    Tracer.evict((Noun)object3);
                    tracer2 = new Tracer((Noun)object3, (String)object2, string2);
                }
            }
        }
        if (tracer == tracer2) {
            return tracer;
        }
        tracer2.finishPreviousRequest();
        if (tracer != null && tracer.m_theTrace != null) {
            object3 = tracer2;
            synchronized (object3) {
                object2 = tracer.m_theTrace.elements();
                while (object2.hasMoreElements() && !tracer2.isFull()) {
                    object = (TracerRecord)object2.nextElement();
                    tracer2.m_theTrace.addElement(object);
                    if (((TracerRecord)object).actionID == 5) {
                        tracer2.m_beginRec = object;
                        continue;
                    }
                    if (((TracerRecord)object).actionID != 6) continue;
                    tracer2.m_beginRec = null;
                }
            }
        }
        return tracer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer create(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new InstrumentationException("Tracer.create(): bad parameters");
        }
        Tracer tracer = (Tracer)Sensor.lookupCache(string);
        if (tracer != null) {
            return tracer;
        }
        Noun noun = Sensor.createParent(string);
        String string3 = DMSUtil.getLeafFromPath(string);
        Noun noun2 = noun;
        synchronized (noun2) {
            tracer = (Tracer)noun.getSensor(string3);
            if (tracer != null) {
                tracer.addToCache(string);
                return tracer;
            }
            Tracer.evict(noun);
            return new Tracer(noun, string3, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer create(Noun noun, String string, String string2) {
        if (noun == null || string2 == null || string == null) {
            throw new InstrumentationException("Tracer.create(): bad parameters");
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            Tracer tracer = (Tracer)noun.getSensor(string);
            if (tracer != null) {
                return tracer;
            }
            Tracer.evict(noun);
            return new Tracer(noun, string, string2);
        }
    }

    public Tracer(Noun noun, String string, String string2) {
        super(noun, string, string2);
        this._metrics[1] = new Metric(this._name + ".count", this._description, "ops", this, false, 3, 1);
        this._lastUpdate = System.currentTimeMillis();
        s_maxRecords = TransTrace._getMaxRecords();
    }

    public Tracer() {
        this._lastUpdate = System.currentTimeMillis();
        s_maxRecords = TransTrace._getMaxRecords();
    }

    private void finishPreviousRequest() {
        if (this.m_theTrace.size() <= 0) {
            return;
        }
        TracerRecord tracerRecord = (TracerRecord)this.m_theTrace.lastElement();
        if (tracerRecord.actionID != 6 && this.m_beginRec != null) {
            TracerRecord tracerRecord2 = new TracerRecord(6);
            tracerRecord2.setTime(tracerRecord.getTime());
            this.m_theTrace.addElement(tracerRecord2);
            this.m_beginRec = null;
            this.setUpdateTime();
        }
    }

    public void beginRequest() {
        this.reset();
        TracerRecord tracerRecord = new TracerRecord(5);
        this.m_theTrace.addElement(tracerRecord);
        this.m_beginRec = tracerRecord;
    }

    void setTriggered(boolean bl) {
        this.m_triggered = bl;
    }

    boolean isTriggered() {
        return this.m_triggered;
    }

    public void endRequest() {
        if (this.m_beginRec != null) {
            ExecutionContext executionContext = ExecutionContext.get();
            TracerRecord tracerRecord = new TracerRecord(6);
            this.m_theTrace.addElement(tracerRecord);
            Map map = this.m_beginRec.getAttributeMap();
            map.putAll(executionContext.getAttributeMap());
            if (this.m_triggered) {
                Tracer tracer = Tracer.create("/TransTrace/" + executionContext.getECID().getUniqueId().toString(), "transaction trace", this);
            }
            if (TransTrace._isDebugEnabled()) {
                this.dumpTraceToFile(TransTrace._getDebugDestination());
            }
            this.processTrace();
            this.reset();
        }
    }

    private boolean isFull() {
        int n = this.m_theTrace.size();
        if (n < s_maxRecords) {
            return false;
        }
        if (n == s_maxRecords) {
            TracerRecord tracerRecord = new TracerRecord((Sensor)this, 10);
            this.m_theTrace.addElement(tracerRecord);
        }
        return true;
    }

    public static void append(String string, Sensor sensor, String string2) {
        ((Tracer)Sensor.get(string)).append(sensor, string2);
    }

    public synchronized void append(Sensor sensor, String string) {
        if (this.isFull()) {
            return;
        }
        TracerRecord tracerRecord = new TracerRecord(sensor, string);
        this.appendTheRecordToTheTrace(tracerRecord);
    }

    public synchronized void append(Sensor sensor, int n) {
        if (this.isFull()) {
            return;
        }
        if (n < 0 || n >= ActionList.length) {
            n = 11;
        }
        TracerRecord tracerRecord = new TracerRecord(sensor, n);
        this.appendTheRecordToTheTrace(tracerRecord);
    }

    public synchronized void append(Sensor sensor, int n, String string) {
        if (this.isFull()) {
            return;
        }
        if (n < 0 || n >= ActionList.length) {
            n = 11;
        }
        TracerRecord tracerRecord = new TracerRecord(sensor, n, string);
        this.appendTheRecordToTheTrace(tracerRecord);
    }

    public synchronized void append(Noun noun, int n) {
        if (this.isFull()) {
            return;
        }
        if (n != 7) {
            return;
        }
        TracerRecord tracerRecord = new TracerRecord(noun, n);
        this.appendTheRecordToTheTrace(tracerRecord);
    }

    private void appendTheRecordToTheTrace(TracerRecord tracerRecord) {
        if (tracerRecord == null) {
            return;
        }
        Noun noun = tracerRecord.noun;
        if (noun != null && this.m_nounTab.get(noun) == null) {
            Sensor[] sensorArray = noun.getSensors();
            if (sensorArray == null) {
                return;
            }
            Sensor sensor = tracerRecord.sensor;
            for (int i = 0; i < sensorArray.length; ++i) {
                Sensor sensor2 = sensorArray[i];
                if (sensor2 == sensor || !(sensor2 instanceof State)) continue;
                State state = (State)sensor2;
                Object object = state.getValue();
                String string = object == null ? DUMMY_VAL : object.toString();
                TracerRecord tracerRecord2 = new TracerRecord(sensor2, 9, string);
                tracerRecord2.setTime(tracerRecord.getTime());
                this.m_theTrace.addElement(tracerRecord2);
            }
            this.m_nounTab.put(noun, DUMMY_VAL);
        }
        this.m_theTrace.addElement(tracerRecord);
        this.setUpdateTime();
    }

    public synchronized Object getValue(Metric metric) {
        if (!this._alive) {
            return new ErrorObject();
        }
        if (metric == null) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to Tracer " + this);
        }
        byte by = metric.getIndex();
        if (this._metrics[by] != metric) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to Tracer " + this);
        }
        switch (by) {
            case 1: {
                return new Integer(this.m_theTrace.size());
            }
        }
        throw new InstrumentationException("Metric: " + metric + " does not belong to Tracer " + this);
    }

    public synchronized String getTraceString() {
        this.finishPreviousRequest();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_theTrace.elements();
        while (enumeration.hasMoreElements()) {
            TracerRecord tracerRecord = (TracerRecord)enumeration.nextElement();
            tracerRecord.toStringBuffer(stringBuffer);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public synchronized void reset() {
        this.m_theTrace.clear();
        this.m_nounTab.clear();
        this.m_startRecDex = 0;
        this.m_beginRec = null;
        this.m_triggered = false;
        this.setUpdateTime();
    }

    public void deriveMetric(int n) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processTrace() {
        TracerRecord tracerRecord = null;
        try {
            if (!TransTrace._isDumpEnabled()) {
                return;
            }
            Stack<TracerRecord> stack = new Stack<TracerRecord>();
            long l = 0L;
            Noun noun = null;
            PhaseEvent phaseEvent = null;
            long l2 = 0L;
            if (this.m_theTrace == null) return;
            if (this.m_theTrace.size() <= 0) {
                return;
            }
            int n = this.m_theTrace.size();
            for (int i = this.m_startRecDex; i < n; ++i) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                tracerRecord = (TracerRecord)this.m_theTrace.elementAt(i);
                long l3 = tracerRecord.getTime();
                if (tracerRecord.actionID == 5) {
                    block31: {
                        noun = null;
                        phaseEvent = null;
                        l2 = 0L;
                        stack.clear();
                        String string = (String)tracerRecord.getAttributeMap().get("URI");
                        if (string == null) break;
                        int n2 = string.indexOf(63);
                        if (n2 >= 0) {
                            string = string.substring(0, n2);
                        }
                        if (TransTrace._isDollarStrippingEnabled() && (n2 = string.indexOf(36)) >= 0) {
                            string = string.substring(0, n2);
                        }
                        string = DMSUtil.sanitize(string, 511, true, false);
                        object4 = Noun.create(TransTrace.NOUN_PATHNAME, "n/a");
                        noun = ((Noun)object4).getChild(string);
                        if (noun == null) {
                            if (((Noun)object4).getNumChildNouns() < TransTrace._getMaxAggregates()) {
                                noun = Noun.create((Noun)object4, string, "oc4j_uri");
                                phaseEvent = PhaseEvent.create(noun, "service", "servicing a URI request");
                                phaseEvent.deriveMetric(287);
                                break block31;
                            } else {
                                tracerRecord.detail = string;
                                object3 = Event.create((Noun)object4, "ignoredURI", "URI {0} was not recorded because more than maxaggregates ({1}) unique URIs have been recorded since last dump");
                                if (((Sensor)object3).isGonnaLog()) {
                                    object2 = new Object[]{string, new Integer(TransTrace._getMaxAggregates())};
                                    ((Event)object3).occurred((Object[])object2);
                                    break;
                                }
                                ((Event)object3).occurred();
                                break;
                            }
                        }
                        phaseEvent = (PhaseEvent)noun.getSensor("service");
                    }
                    l = l2 = l3;
                    if (phaseEvent != null) {
                        phaseEvent.start(l2);
                    }
                    tracerRecord.sensor = phaseEvent;
                    tracerRecord.noun = noun;
                    tracerRecord.cousin = tracerRecord.sensor;
                    stack.push(tracerRecord);
                    continue;
                }
                if (tracerRecord.actionID == 6) {
                    if (phaseEvent == null) continue;
                    phaseEvent.addExclTime(l3 - l);
                    phaseEvent.stop(l2, l3);
                    phaseEvent = null;
                    continue;
                }
                if (tracerRecord.actionID == 1) {
                    PhaseEvent phaseEvent2 = (PhaseEvent)tracerRecord.sensor;
                    if (!stack.empty()) {
                        TracerRecord tracerRecord2 = (TracerRecord)stack.peek();
                        object4 = (PhaseEvent)tracerRecord2.sensor;
                        if (object4 != null) {
                            ((PhaseEvent)object4).addExclTime(l3 - l);
                        }
                        if (phaseEvent2 != null && tracerRecord2.cousin != null && (object2 = phaseEvent2.getCousin((Noun)(object3 = tracerRecord2.cousin.getParent()))) != null) {
                            ((PhaseEvent)object2).start(l3);
                            tracerRecord.cousin = object2;
                        }
                    }
                    l = l3;
                    stack.push(tracerRecord);
                    continue;
                }
                if (tracerRecord.actionID == 2) {
                    PhaseEvent phaseEvent3 = (PhaseEvent)tracerRecord.sensor;
                    TracerRecord tracerRecord3 = tracerRecord.findMatchingStart(stack);
                    if (tracerRecord3 != null) {
                        phaseEvent3.addExclTime(l3 - l);
                        if (phaseEvent3 != null && (object4 = (PhaseEvent)tracerRecord3.cousin) != null) {
                            ((PhaseEvent)object4).stop(tracerRecord3.tstamp, l3);
                        }
                        if ((object4 = (TracerRecord)stack.peek()) != null && ((TracerRecord)object4).actionID == 1) {
                            object3 = tracerRecord3.getStateValues();
                            object2 = ((TracerRecord)object4).getUpdatedStates();
                            if (object2 != null && object3 != null) {
                                object = object2.keySet().iterator();
                                while (object.hasNext()) {
                                    Object k = object.next();
                                    if (!object3.containsKey(k)) continue;
                                    State state = (State)object2.get(k);
                                    Object v = object3.get(k);
                                    state.update(v);
                                }
                            }
                        }
                    }
                    l = l3;
                    continue;
                }
                if (tracerRecord.actionID == 3) {
                    PhaseEvent phaseEvent4 = (PhaseEvent)tracerRecord.sensor;
                    TracerRecord tracerRecord4 = tracerRecord.findMatchingStart(stack);
                    if (tracerRecord4 != null && phaseEvent4 != null && (object4 = (PhaseEvent)tracerRecord4.cousin) != null) {
                        ((PhaseEvent)object4).abort(tracerRecord4.tstamp);
                    }
                    l = l3;
                    continue;
                }
                if (tracerRecord.actionID == 0) {
                    Event event = (Event)tracerRecord.sensor;
                    if (event == null || stack.empty()) continue;
                    TracerRecord tracerRecord5 = (TracerRecord)stack.peek();
                    object4 = tracerRecord5.cousin.getParent();
                    object3 = event.getCousin((Noun)object4);
                    if (object3 == null) continue;
                    ((Event)object3).occurred();
                    continue;
                }
                if (tracerRecord.actionID == 4 || tracerRecord.actionID == 8) {
                    State state = (State)tracerRecord.sensor;
                    if (state == null || stack.empty()) continue;
                    TracerRecord tracerRecord6 = (TracerRecord)stack.peek();
                    object4 = tracerRecord6.cousin.getParent();
                    object3 = state.getCousin((Noun)object4);
                    if (object3 != null) {
                        ((State)object3).update(tracerRecord.detail);
                    }
                    object2 = tracerRecord6.getStateValues();
                    object2.put(state, tracerRecord.detail);
                    object = tracerRecord6.getUpdatedStates();
                    object.put(state, object3);
                    continue;
                }
                if (tracerRecord.actionID == 7) {
                    Noun noun2 = tracerRecord.noun;
                    if (stack.empty()) continue;
                    TracerRecord tracerRecord7 = (TracerRecord)stack.peek();
                    object4 = tracerRecord7.cousin.getParent();
                    object3 = noun2.getCousin((Noun)object4);
                    continue;
                }
                if (tracerRecord.actionID == 9 || tracerRecord.actionID != 10) continue;
                int n3 = stack.size();
                for (int j = n3 - 1; j > 0; --j) {
                    object4 = (TracerRecord)stack.get(j);
                    object3 = (PhaseEvent)((TracerRecord)object4).sensor;
                    object2 = (PhaseEvent)((TracerRecord)object4).cousin;
                    ((PhaseEvent)object3).addExclTime(l3 - l);
                    ((PhaseEvent)object2).stop(((TracerRecord)object4).tstamp, l3);
                }
                if (phaseEvent == null) continue;
                phaseEvent.addExclTime(l3 - l);
                phaseEvent.stop(l2, l3);
                phaseEvent = null;
            }
            this.m_startRecDex = n;
            return;
        }
        catch (Exception exception) {
            System.err.println("RBI: caught exception: ");
            exception.printStackTrace();
            System.err.println("RBI: full trace:\n" + this.getTraceString());
            System.err.println("RBI: current record:\n  " + tracerRecord + '\n');
        }
    }

    static synchronized void evict(Noun noun) {
        int n;
        if (noun == null) {
            return;
        }
        Sensor[] sensorArray = noun.getSensors();
        if (sensorArray == null) {
            return;
        }
        Vector<Sensor> vector = new Vector<Sensor>();
        for (n = 0; n < sensorArray.length; ++n) {
            Sensor sensor = sensorArray[n];
            if (!(sensor instanceof Tracer)) continue;
            vector.addElement(sensor);
        }
        n = vector.size();
        int n2 = TransTrace._getMaxTraces();
        while (n >= n2 && n > 0) {
            int n3 = 0;
            long l = ((Tracer)vector.elementAt(n3)).getLastTstamp();
            for (int i = 1; i < n; ++i) {
                Tracer tracer = (Tracer)vector.elementAt(i);
                long l2 = tracer.getLastTstamp();
                if (l2 >= l) continue;
                l = l2;
                n3 = i;
            }
            Tracer tracer = (Tracer)vector.elementAt(n3);
            tracer.destroy();
            vector.removeElementAt(n3);
            n = vector.size();
        }
    }

    private long getLastTstamp() {
        long l = 0L;
        TracerRecord tracerRecord = (TracerRecord)this.m_theTrace.lastElement();
        if (tracerRecord != null) {
            l = tracerRecord.getTime();
        }
        return l;
    }

    private long getDumpTime() {
        String string = "/DMS-Internal/transtrace/DumpInfo/nextDumpTime.value";
        Number number = (Number)Spy.getMetricValue(string);
        long l = 0L;
        if (number != null) {
            l = number.longValue();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpTraceToFile(String string) {
        block12: {
            int n = this.m_theTrace.size();
            if (n <= 2) {
                return;
            }
            Object object = s_globalLock;
            synchronized (object) {
                File file = new File(string, "dmsTrace_" + this.getDumpTime() + ".trc");
                String string2 = file.getPath();
                FileOutputStream fileOutputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                BufferedWriter bufferedWriter = null;
                PrintWriter printWriter = null;
                fileOutputStream = new FileOutputStream(string2, true);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                printWriter = new PrintWriter(bufferedWriter);
                printWriter.println(this.getTraceString());
                Object var12_10 = null;
                try {
                    printWriter.close();
                    bufferedWriter.close();
                    outputStreamWriter.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block12;
                {
                    catch (Exception exception) {
                        System.err.println("WARNING: DMS unable to dump trace : " + string2);
                        exception.printStackTrace();
                        Object var12_11 = null;
                        try {
                            printWriter.close();
                            bufferedWriter.close();
                            outputStreamWriter.close();
                            fileOutputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    try {
                        printWriter.close();
                        bufferedWriter.close();
                        outputStreamWriter.close();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    static synchronized void shutdown() {
        s_maxRecords = 1000;
        s_globalLock = new Object();
    }

    static {
        Tracer.ActionList[0] = "EventOccurred";
        Tracer.ActionList[1] = "PhaseStart";
        Tracer.ActionList[2] = "PhaseStop";
        Tracer.ActionList[3] = "PhaseAbort";
        Tracer.ActionList[4] = "StateUpdate";
        Tracer.ActionList[5] = "RequestBegin";
        Tracer.ActionList[6] = "RequestEnd";
        Tracer.ActionList[7] = "NounCreate";
        Tracer.ActionList[8] = "StateCreate";
        Tracer.ActionList[9] = "StateValue";
        Tracer.ActionList[10] = "TraceFull";
        Tracer.ActionList[11] = "unknown";
        s_maxRecords = 1000;
        s_globalLock = new Object();
    }
}

