/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class IntegerValue
extends Value {
    private int _value = 0;
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;

    private void setValue(int n) {
        this._value = n;
        if (this.MAX && this._value > this._max) {
            this._max = n;
        }
        if (this.MIN && this._value < this._min) {
            this._min = n;
        }
    }

    public void update(int n) {
        this.setValue(n);
    }

    public void update(double d) {
        int n = 0;
        n = d >= 0.0 ? (int)Math.round(d) : -((int)Math.round(-d));
        this.setValue(n);
    }

    public void update(long l) {
        int n = (int)l;
        this.setValue(n);
    }

    public void increment() {
        int n = this._value + 1;
        this.setValue(n);
    }

    public void increment(int n) {
        int n2 = this._value + n;
        this.setValue(n2);
    }

    public void increment(long l) {
        int n = (int)l;
        this.setValue(n += this._value);
    }

    public void increment(double d) {
        int n = (int)Math.round(d);
        this.setValue(n += this._value);
    }

    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    public Object getValue() {
        return new Integer(this._value);
    }

    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Integer.MAX_VALUE) {
            return new Integer(this._min);
        }
        return new Integer(0);
    }

    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Integer.MIN_VALUE) {
            return new Integer(this._max);
        }
        return new Integer(0);
    }
}

