/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.DataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;

public abstract class AbstractDataFrameProcessor
implements DataFrameProcessor {
    protected static final Logger LOGGER = Logger.getLogger(DataFrameProcessor.class.getName());
    protected volatile ProfilerClient client = null;
    private final Set listeners = new HashSet();
    private boolean processorLives = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasListeners() {
        Set set = this.listeners;
        synchronized (set) {
            return !this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDataFrame(byte[] byArray) {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            if (!this.processorLives) {
                return;
            }
            try {
                this.fireBatchStart();
                this.doProcessDataFrame(byArray);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error while processing data frame", exception);
            }
            finally {
                this.fireBatchStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        HashSet hashSet;
        Object object = this.listeners;
        synchronized (object) {
            hashSet = new HashSet(this.listeners);
            this.listeners.clear();
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((ProfilingResultListener)object.next()).shutdown();
        }
    }

    @Override
    public void reset() {
        this.fireReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            this.processorLives = false;
            this.fireShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(ProfilerClient profilerClient) {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            this.processorLives = true;
            this.client = profilerClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(ProfilingResultListener profilingResultListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(profilingResultListener);
        }
    }

    protected abstract void doProcessDataFrame(byte[] var1);

    protected void fireProfilingPoint(final int n, final int n2, final long l) {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.profilingPoint(n, n2, l);
            }
        });
    }

    protected void fireReset() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.reset();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foreachListener(ListenerFunctor listenerFunctor) {
        HashSet hashSet;
        Object object = this.listeners;
        synchronized (object) {
            hashSet = new HashSet(this.listeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            listenerFunctor.execute((ProfilingResultListener)object.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListener(ProfilingResultListener profilingResultListener) {
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.remove(profilingResultListener)) {
                profilingResultListener.shutdown();
            }
        }
    }

    private void fireBatchStart() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.onBatchStart();
            }
        });
    }

    private void fireBatchStop() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.onBatchStop();
            }
        });
    }

    private void fireShutdown() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                profilingResultListener.shutdown();
            }
        });
    }

    protected static interface ListenerFunctor {
        public void execute(ProfilingResultListener var1);
    }
}

