/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.wireprotocol.Response;

public class MonitoredNumbersResponse
extends Response {
    public static final int FREE_MEMORY_IDX = 0;
    public static final int TOTAL_MEMORY_IDX = 1;
    public static final int USER_THREADS_IDX = 2;
    public static final int SYSTEM_THREADS_IDX = 3;
    public static final int SURVIVING_GENERATIONS_IDX = 4;
    public static final int GC_TIME_IDX = 5;
    public static final int GC_PAUSE_IDX = 6;
    public static final int LOADED_CLASSES_IDX = 7;
    public static final int TIMESTAMP_IDX = 8;
    public static final int GENERAL_NUMBERS_SIZE = 9;
    private long[] gcFinishs;
    private long[] gcStarts;
    private long[] generalNumbers = new long[9];
    private String[] newThreadClassNames;
    private int[] newThreadIds;
    private String[] newThreadNames;
    private long[] stateTimestamps = new long[10];
    private int[] threadIds = new int[10];
    private byte[] threadStates = new byte[100];
    private int nNewThreads;
    private int nThreadStates;
    private int nThreads;

    public MonitoredNumbersResponse(long[] lArray) {
        super(true, 9);
        this.generalNumbers = lArray;
        this.nNewThreads = 0;
    }

    MonitoredNumbersResponse() {
        super(true, 9);
    }

    public void setDataOnNewThreads(int n, int[] nArray, String[] stringArray, String[] stringArray2) {
        this.nNewThreads = n;
        this.newThreadIds = nArray;
        this.newThreadNames = stringArray;
        this.newThreadClassNames = stringArray2;
    }

    public void setDataOnThreads(int n, int n2, int[] nArray, long[] lArray, byte[] byArray) {
        this.nThreads = n;
        this.nThreadStates = n2;
        this.threadIds = nArray;
        this.stateTimestamps = lArray;
        this.threadStates = byArray;
    }

    public long[] getGCFinishs() {
        return this.gcFinishs;
    }

    public long[] getGCStarts() {
        return this.gcStarts;
    }

    public void setGCstartFinishData(long[] lArray, long[] lArray2) {
        this.gcStarts = lArray;
        this.gcFinishs = lArray2;
    }

    public long[] getGeneralMonitoredNumbers() {
        return this.generalNumbers;
    }

    public int getNNewThreads() {
        return this.nNewThreads;
    }

    public int getNThreadStates() {
        return this.nThreadStates;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public String[] getNewThreadClassNames() {
        return this.newThreadClassNames;
    }

    public int[] getNewThreadIds() {
        return this.newThreadIds;
    }

    public String[] getNewThreadNames() {
        return this.newThreadNames;
    }

    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public byte[] getThreadStates() {
        return this.threadStates;
    }

    public String toString() {
        return "MonitoredNumbersResponse, " + super.toString();
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        int n2;
        for (n2 = 0; n2 < this.generalNumbers.length; ++n2) {
            this.generalNumbers[n2] = objectInputStream.readLong();
        }
        this.nThreads = objectInputStream.readInt();
        this.nThreadStates = objectInputStream.readInt();
        if (this.threadIds.length < this.nThreads) {
            this.threadIds = new int[this.nThreads];
        }
        if (this.stateTimestamps.length < this.nThreadStates) {
            this.stateTimestamps = new long[this.nThreadStates];
        }
        if (this.threadStates.length < (n2 = this.nThreads * this.nThreadStates)) {
            this.threadStates = new byte[n2];
        }
        for (n = 0; n < this.nThreads; ++n) {
            this.threadIds[n] = objectInputStream.readInt();
        }
        for (n = 0; n < this.nThreadStates; ++n) {
            this.stateTimestamps[n] = objectInputStream.readLong();
        }
        objectInputStream.readFully(this.threadStates, 0, n2);
        this.nNewThreads = objectInputStream.readInt();
        if (this.nNewThreads > 0) {
            if (this.newThreadIds == null || this.newThreadIds.length < this.nNewThreads) {
                this.newThreadIds = new int[this.nNewThreads];
                this.newThreadNames = new String[this.nNewThreads];
                this.newThreadClassNames = new String[this.nNewThreads];
            }
            for (n = 0; n < this.nNewThreads; ++n) {
                this.newThreadIds[n] = objectInputStream.readInt();
                this.newThreadNames[n] = objectInputStream.readUTF();
                this.newThreadClassNames[n] = objectInputStream.readUTF();
            }
        }
        int n3 = objectInputStream.readInt();
        this.gcStarts = new long[n3];
        for (n = 0; n < n3; ++n) {
            this.gcStarts[n] = objectInputStream.readLong();
        }
        n3 = objectInputStream.readInt();
        this.gcFinishs = new long[n3];
        for (n = 0; n < n3; ++n) {
            this.gcFinishs[n] = objectInputStream.readLong();
        }
        Arrays.sort(this.gcStarts);
        Arrays.sort(this.gcFinishs);
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        int n2;
        for (n2 = 0; n2 < this.generalNumbers.length; ++n2) {
            objectOutputStream.writeLong(this.generalNumbers[n2]);
        }
        objectOutputStream.writeInt(this.nThreads);
        objectOutputStream.writeInt(this.nThreadStates);
        for (n2 = 0; n2 < this.nThreads; ++n2) {
            objectOutputStream.writeInt(this.threadIds[n2]);
        }
        for (n2 = 0; n2 < this.nThreadStates; ++n2) {
            objectOutputStream.writeLong(this.stateTimestamps[n2]);
        }
        n2 = this.nThreads * this.nThreadStates;
        objectOutputStream.write(this.threadStates, 0, n2);
        if (this.nNewThreads == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.nNewThreads);
            for (n = 0; n < this.nNewThreads; ++n) {
                objectOutputStream.writeInt(this.newThreadIds[n]);
                objectOutputStream.writeUTF(this.newThreadNames[n]);
                objectOutputStream.writeUTF(this.newThreadClassNames[n]);
            }
        }
        objectOutputStream.writeInt(this.gcStarts.length);
        for (n = 0; n < this.gcStarts.length; ++n) {
            objectOutputStream.writeLong(this.gcStarts[n]);
        }
        objectOutputStream.writeInt(this.gcFinishs.length);
        for (n = 0; n < this.gcFinishs.length; ++n) {
            objectOutputStream.writeLong(this.gcFinishs[n]);
        }
    }
}

