/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.EgClassFileTransformer;
import com.eg.jtm.JTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.StartServer;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class Agent {
    private static String jtmJarName = "eg_jtm.jar";
    private static String jtmHome = null;
    private static String propsHome = null;
    private static String logHome = null;
    private static String logFolderHome = null;

    static {
        propsHome = System.getProperty("EG_PROPS_HOME");
        logHome = System.getProperty("EG_LOG_HOME");
        jtmHome = Agent.getJtmHomeFolder(propsHome, logHome);
    }

    private Agent(Instrumentation instrumentation) {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        if (jtmHome != null && jtmHome.length() > 0) {
            String version = System.getProperty("java.version");
            System.out.println(new Date() + " [eG JTM  - Java version is  :" + version);
            System.out.println(new Date() + " [eG JTM  - HomeFolder is    :" + jtmHome);
            System.out.println(new Date() + " [eG JTM  - PropsFolder is   :" + propsHome);
            System.out.println(new Date() + " [eG JTM  - logFolderHome is :" + logFolderHome);
            StringTokenizer versionTokenizer = new StringTokenizer(version, ".");
            int count = versionTokenizer.countTokens();
            if (count > 2) {
                versionTokenizer.nextToken();
                String majorVersion = versionTokenizer.nextToken();
                try {
                    int majorValue = Integer.parseInt(majorVersion);
                    if (majorValue >= 5) {
                        boolean isAbove6 = false;
                        if (majorValue >= 6) {
                            isAbove6 = true;
                            boolean isAppend = Agent.appendJarToBootstrapClassLoader(jtmHome, inst, jtmJarName);
                            if (isAppend) {
                                System.out.println(new Date() + " JTM jar file is added to BootstrapClassLoader successfully !!!");
                            }
                        }
                        PropsManager.EG_JTM_HOME = System.getProperty("EG_JTM_HOME");
                        StartServer.startThread();
                        Agent.logSystemProperties();
                        EgClassFileTransformer egClassFileTransformer = new EgClassFileTransformer(inst, isAbove6, true);
                    }
                }
                catch (Exception e) {
                    System.out.println(" eG Java Transaction Monitor supports from 1.5 onwards. Exiting..." + e);
                    System.exit(0);
                }
            } else {
                System.out.println("-javaagent:<< ...path of " + jtmJarName + " >> is not configured properly. Exiting ...");
                System.exit(0);
            }
        } else {
            System.out.println(" Cannot find the JTM Home Folder..");
        }
    }

    private static boolean appendJarToBootstrapClassLoader(String jtmHome, Instrumentation instrumentation, String jarName) {
        boolean result = false;
        File egNewJtmFile = new File(String.valueOf(jtmHome) + "/" + jarName);
        JarFile newJtmJarFile = null;
        try {
            newJtmJarFile = new JarFile(egNewJtmFile);
            instrumentation.appendToBootstrapClassLoaderSearch(newJtmJarFile);
            result = true;
        }
        catch (IOException e) {
            System.out.println("Exception while adding jar file to bootstrap classloader ...");
            e.printStackTrace();
        }
        return result;
    }

    private static String getJtmHomeFolder(String propsfileHome, String logHome) {
        String jtmFolder = null;
        ClassLoader classLoader = Agent.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            JarFile agentJarFile = null;
            int i = 0;
            while (i < urls.length) {
                String fileName = urls[i].getFile();
                if (fileName != null && fileName.endsWith(jtmJarName)) {
                    try {
                        agentJarFile = new JarFile(fileName);
                        String name = agentJarFile.getName();
                        jtmFolder = name.substring(0, name.indexOf(jtmJarName) - 1);
                        Agent.setEgSystemProperties(jtmFolder, propsfileHome);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (agentJarFile != null) {
                            try {
                                agentJarFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                ++i;
            }
        } else {
            jtmFolder = Agent.getEGAgentInstallDirectory();
            Agent.setEgSystemProperties(jtmFolder, propsfileHome);
        }
        return jtmFolder;
    }

    private static void setEgSystemProperties(String btmFolder, String propsfileHome) {
        if (btmFolder != null) {
            if (propsfileHome != null && propsfileHome.length() > 0) {
                System.setProperty("EG_JTM_HOME", propsfileHome);
            } else {
                propsfileHome = btmFolder;
                propsHome = btmFolder;
                System.setProperty("EG_JTM_HOME", btmFolder);
            }
            if (propsfileHome != null && propsfileHome.length() > 0) {
                String sep = System.getProperty("file.separator");
                int lastIndex = propsfileHome.lastIndexOf(sep);
                String folderName = null;
                folderName = lastIndex > 0 ? propsfileHome.substring(lastIndex + 1) : propsfileHome;
                if (logHome != null && logHome.length() > 0) {
                    if (logHome.equalsIgnoreCase("none")) {
                        System.setProperty("EG_LOG_HOME", "none");
                    } else {
                        logFolderHome = logHome.endsWith(sep) ? String.valueOf(logHome) + folderName : String.valueOf(logHome) + sep + folderName;
                        System.setProperty("EG_LOG_HOME", logFolderHome);
                    }
                } else {
                    logFolderHome = propsfileHome;
                    System.setProperty("EG_LOG_HOME", logFolderHome);
                }
            }
        }
    }

    private static String getEGAgentInstallDirectory() {
        block4: {
            try {
                String systemClassPath = System.getProperty("java.class.path");
                String agentInstallEntry = systemClassPath.substring(systemClassPath.lastIndexOf(File.pathSeparator) + 1);
                if (!agentInstallEntry.contains(jtmJarName)) {
                    StringTokenizer cpTokenizer = new StringTokenizer(systemClassPath, File.pathSeparator);
                    while (cpTokenizer.hasMoreTokens()) {
                        String cpEntry = cpTokenizer.nextToken();
                        if (!cpEntry.contains(jtmJarName)) continue;
                        return Agent.getInstallDirPath(cpEntry);
                    }
                    break block4;
                }
                return Agent.getInstallDirPath(agentInstallEntry);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return null;
    }

    private static String getInstallDirPath(String agentInstallEntry) {
        File agentInstallDir;
        if (new File(agentInstallEntry).exists() && (agentInstallDir = new File(agentInstallEntry).getParentFile()) != null) {
            try {
                return agentInstallDir.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private static void logSystemProperties() {
        if (JTMLog.debugLogger.isDebugEnabled()) {
            Properties jvmProperties = System.getProperties();
            Set<Object> keySet = jvmProperties.keySet();
            Iterator<Object> itr = keySet.iterator();
            JTMLog.debugLogger.debug(" **************** System Properties ********************");
            while (itr.hasNext()) {
                String propsKey = (String)itr.next();
                String propsValue = jvmProperties.getProperty(propsKey);
                JTMLog.debugLogger.debug(String.valueOf(propsKey) + " == " + propsValue);
            }
        }
    }
}

