/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.Type;
import java.io.IOException;
import java.io.InputStream;

public class EgClassMetaData {
    private static final int HEADER_MODIFIERS_OFFSET = 0;
    private static final int HEADER_SUPER_CLASS_CONSTANT_POOL_OFFSET = 4;
    private static final int HEADER_NUM_INTERFACES_OFFSET = 6;
    private static final int HEADER_INITIAL_INTERFACE_OFFSET = 8;
    private static final int INTERFACE = 512;
    private Type type;
    private ClassLoader classLoader;
    private ClassReader classReader;
    int modifiers;
    String superClass;
    String[] interfaces;
    EgClassMetaData superClassMetadata;
    EgClassMetaData[] interfaceMetadata;

    public EgClassMetaData(String type, ClassLoader loader) {
        this.classLoader = loader;
        if (loader == null) {
            this.classLoader = ClassLoader.getSystemClassLoader();
        }
        this.type = Type.getObjectType(type);
        this.classReader = this.getClassReader(type, this.classLoader);
        this.modifiers = this.classReader.readUnsignedShort(this.classReader.header + 0);
        char[] charBuffer = new char[2048];
        int cpSuperIndex = this.classReader.getItem(this.classReader.readUnsignedShort(this.classReader.header + 4));
        this.superClass = cpSuperIndex == 0 ? null : this.classReader.readUTF8(cpSuperIndex, charBuffer);
        this.interfaces = new String[this.classReader.readUnsignedShort(this.classReader.header + 6)];
        int nextInterface = this.classReader.header + 8;
        int i = 0;
        while (i < this.interfaces.length) {
            this.interfaces[i] = this.classReader.readClass(nextInterface, charBuffer);
            nextInterface += 2;
            ++i;
        }
    }

    private ClassReader getClassReader(String type, ClassLoader classLoader) {
        ClassReader cr;
        block12: {
            String resource = String.valueOf(type.replace('.', '/')) + ".class";
            InputStream is = null;
            cr = null;
            try {
                try {
                    is = classLoader.getResourceAsStream(resource);
                    cr = new ClassReader(is);
                }
                catch (IOException iOException) {
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return cr;
    }

    String getName() {
        return this.type.getInternalName();
    }

    EgClassMetaData getSuperclass() {
        if (this.superClass == null) {
            return null;
        }
        if (this.superClassMetadata == null) {
            this.superClassMetadata = new EgClassMetaData(this.superClass, this.classLoader);
        }
        return this.superClassMetadata;
    }

    EgClassMetaData[] getInterfaces() {
        if (this.interfaceMetadata == null) {
            this.interfaceMetadata = new EgClassMetaData[this.interfaces.length];
            int i = 0;
            while (i < this.interfaces.length) {
                this.interfaceMetadata[i] = new EgClassMetaData(this.interfaces[i], this.classLoader);
                ++i;
            }
        }
        return this.interfaceMetadata;
    }

    boolean isInterface() {
        return (this.modifiers & 0x200) > 0;
    }

    private boolean implementsInterface(EgClassMetaData other) {
        if (this == other) {
            return true;
        }
        EgClassMetaData metadata = this;
        while (metadata != null) {
            EgClassMetaData[] egClassMetaDataArray = metadata.getInterfaces();
            int n = egClassMetaDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                EgClassMetaData in = egClassMetaDataArray[n2];
                if (in.type.equals(other.type) || in.implementsInterface(other)) {
                    return true;
                }
                ++n2;
            }
            metadata = metadata.getSuperclass();
        }
        return false;
    }

    private boolean isSubclassOf(EgClassMetaData other) {
        EgClassMetaData metadata = this;
        while (metadata != null) {
            EgClassMetaData sc = metadata.getSuperclass();
            if (sc != null && sc.type.equals(other.type)) {
                return true;
            }
            metadata = metadata.getSuperclass();
        }
        return false;
    }

    public boolean isAssignableFrom(EgClassMetaData other) {
        return this == other || other.implementsInterface(this) || other.isSubclassOf(this) || other.isInterface() && this.type.getDescriptor().equals("Ljava/lang/Object;");
    }
}

