/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.ch.qos.logback.classic.AsyncAppender;
import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.core.Appender;
import com.eg.ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import com.eg.ch.qos.logback.core.rolling.RollingFileAppender;
import com.eg.ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import com.eg.ch.qos.logback.core.util.FileSize;
import com.eg.org.slf4j.LoggerFactory;

public class LogbackFileUtils {
    public static final String JTMLogger = "JTMLog";
    public static final String JTMDebugLogger = "JTMDebug";
    private static boolean JTMLoggerInitialized = false;
    private static boolean JTMDebugLoggerInitialized = false;
    private static RollingFileAppender<ILoggingEvent> jtmDebugRollingFileAppender;
    private static AsyncAppender asyncAppender;
    private static String jtmLogFileName;
    private static Level jtmLogLevel;
    private static int jtmLogFileMaxCount;
    private static int jtmLogFileLimit;
    private static String jtmlogHomeFolder;
    private static int asyncQueueSize;
    private static int discardThresholdLimit;
    private static final String jtmDebugLogFileName = "JTMDebug.log";

    private static void initJTMLogger(String filePath) {
        if (!JTMLoggerInitialized) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            RollingFileAppender<ILoggingEvent> jtmRollingFileAppender = new RollingFileAppender<ILoggingEvent>();
            jtmRollingFileAppender.setContext(loggerContext);
            jtmRollingFileAppender.setFile(String.valueOf(filePath) + "/logs/" + jtmLogFileName);
            FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
            fwRollingPolicy.setContext(loggerContext);
            fwRollingPolicy.setFileNamePattern(String.valueOf(filePath) + "/logs/" + jtmLogFileName + "-%i.log");
            fwRollingPolicy.setMinIndex(1);
            fwRollingPolicy.setMaxIndex(jtmLogFileMaxCount);
            fwRollingPolicy.setParent(jtmRollingFileAppender);
            fwRollingPolicy.start();
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            FileSize fileSize = FileSize.valueOf(String.valueOf(jtmLogFileLimit) + "MB");
            triggeringPolicy.setMaxFileSize(fileSize);
            triggeringPolicy.start();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext(loggerContext);
            encoder.setPattern("%date %-5level - %msg%n");
            encoder.start();
            jtmRollingFileAppender.setEncoder(encoder);
            jtmRollingFileAppender.setRollingPolicy(fwRollingPolicy);
            jtmRollingFileAppender.setTriggeringPolicy(triggeringPolicy);
            jtmRollingFileAppender.start();
            asyncAppender = new AsyncAppender();
            asyncAppender.setContext(loggerContext);
            asyncAppender.setName("JTMAsync");
            asyncAppender.addAppender(jtmRollingFileAppender);
            asyncAppender.setDiscardingThreshold(discardThresholdLimit);
            asyncAppender.setQueueSize(asyncQueueSize);
            asyncAppender.start();
            Logger logbackLogger = loggerContext.getLogger(JTMLogger);
            logbackLogger.addAppender(asyncAppender);
            logbackLogger.setLevel(jtmLogLevel);
            logbackLogger.setAdditive(true);
            JTMLoggerInitialized = true;
            jtmlogHomeFolder = filePath;
        }
    }

    public static void reInitializeJTMLogger() {
        if (JTMLoggerInitialized) {
            JTMLoggerInitialized = false;
            LogbackFileUtils.stop();
            LogbackFileUtils.initJTMLogger(jtmlogHomeFolder);
        }
    }

    public static void setLogbackLevel(Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logbackLogger = loggerContext.getLogger(JTMLogger);
        LogbackFileUtils.setJtmLogLevel(level);
        logbackLogger.setLevel(level);
    }

    private static void initJTMDebugLogger(String filePath) {
        if (!JTMDebugLoggerInitialized) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            jtmDebugRollingFileAppender = new RollingFileAppender();
            jtmDebugRollingFileAppender.setContext(loggerContext);
            jtmDebugRollingFileAppender.setFile(String.valueOf(filePath) + "/logs/" + jtmDebugLogFileName);
            FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
            fwRollingPolicy.setContext(loggerContext);
            fwRollingPolicy.setFileNamePattern(String.valueOf(filePath) + "/logs/" + jtmDebugLogFileName + "-%i.log");
            fwRollingPolicy.setMinIndex(1);
            fwRollingPolicy.setMaxIndex(3);
            fwRollingPolicy.setParent(jtmDebugRollingFileAppender);
            fwRollingPolicy.start();
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            FileSize fileSize = FileSize.valueOf("10MB");
            triggeringPolicy.setMaxFileSize(fileSize);
            triggeringPolicy.start();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext(loggerContext);
            encoder.setPattern("%date %-5level - %msg%n");
            encoder.start();
            jtmDebugRollingFileAppender.setEncoder(encoder);
            jtmDebugRollingFileAppender.setRollingPolicy(fwRollingPolicy);
            jtmDebugRollingFileAppender.setTriggeringPolicy(triggeringPolicy);
            jtmDebugRollingFileAppender.start();
            Logger logbackLogger = loggerContext.getLogger(JTMDebugLogger);
            logbackLogger.addAppender((Appender<ILoggingEvent>)jtmDebugRollingFileAppender);
            logbackLogger.setLevel(jtmLogLevel);
            logbackLogger.setAdditive(true);
            JTMDebugLoggerInitialized = true;
        }
    }

    public static void reset() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
    }

    public static void start(String filePath) {
        LogbackFileUtils.stop();
        LogbackFileUtils.initJTMLogger(filePath);
    }

    public static void startDebug(String filePath) {
        LogbackFileUtils.stopDebug();
        LogbackFileUtils.initJTMDebugLogger(filePath);
    }

    private static void stop() {
        if (asyncAppender != null && asyncAppender.isStarted()) {
            asyncAppender.stop();
        }
    }

    private static void stopDebug() {
        if (jtmDebugRollingFileAppender != null && jtmDebugRollingFileAppender.isStarted()) {
            jtmDebugRollingFileAppender.stop();
        }
    }

    public static String getJtmLogFileName() {
        return jtmLogFileName;
    }

    public static void setJtmLogFileName(String jtmLogFileName) {
        LogbackFileUtils.jtmLogFileName = jtmLogFileName;
    }

    public static Level getJtmLogLevel() {
        return jtmLogLevel;
    }

    public static void setJtmLogLevel(Level jtmLogLevel) {
        LogbackFileUtils.jtmLogLevel = jtmLogLevel;
    }

    public static int getJtmLogFileMaxCount() {
        return jtmLogFileMaxCount;
    }

    public static void setJtmLogFileMaxCount(int jtmLogFileMaxCount) {
        LogbackFileUtils.jtmLogFileMaxCount = jtmLogFileMaxCount;
    }

    public static int getJtmLogFileLimit() {
        return jtmLogFileLimit;
    }

    public static void setJtmLogFileLimit(int jtmLogFileLimit) {
        LogbackFileUtils.jtmLogFileLimit = jtmLogFileLimit;
    }

    static void setAsyncQueueSize(int queueSize) {
        asyncQueueSize = queueSize;
    }

    static void setDiscardThreshold(int threshold) {
        discardThresholdLimit = threshold;
    }

    static int getQsize() {
        return asyncQueueSize;
    }

    static int getThreshold() {
        return discardThresholdLimit;
    }

    public static void printDetails() {
        if (asyncAppender != null) {
            int noOfelements = asyncAppender.getNumberOfElementsInQueue();
            int remaining = asyncAppender.getRemainingCapacity();
            int qSize = asyncAppender.getQueueSize();
            System.out.println(" asyncAppender Details :" + qSize + " " + noOfelements + "  " + remaining);
        } else {
            System.out.println(" asyncAppender is NULL ");
        }
    }
}

