/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMUrlComparator;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class URLPatternMeasure {
    boolean modified = false;
    private String pName;
    private Hashtable pMeasureHT;
    private static final Double minusFive = new Double(-5.0);

    URLPatternMeasure(String patternName) {
        this.pName = patternName;
    }

    public Hashtable getMeasureTbl() {
        if (this.pMeasureHT == null) {
            this.modified = false;
            return null;
        }
        Hashtable cloneTable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT.remove("patternData");
        this.pMeasureHT.remove("SlowURLLists");
        this.pMeasureHT.remove("ErrorURLLists");
        this.pMeasureHT = null;
        return cloneTable;
    }

    public String getPName() {
        return this.pName;
    }

    public void update(URLPatternData UPD) {
        this.modified = true;
        if (this.pMeasureHT == null) {
            this.pMeasureHT = new Hashtable();
        }
        int length = PropsManager.subCompNames.length;
        if (this.pMeasureHT.containsKey("patternData")) {
            ArrayList existingData = (ArrayList)this.pMeasureHT.get("patternData");
            ArrayList<Double> syncDataList = new ArrayList<Double>(length);
            int j = 0;
            while (j < length) {
                if (j == 11 || j == 12 || j == 13 || j == 15 || j == 16 || j == 17) {
                    syncDataList.add(minusFive);
                    syncDataList.add(minusFive);
                } else {
                    double currentNumOf = UPD.numOf[j];
                    double currentSumOf = UPD.sumOf[j];
                    double newAvgOf = 0.0;
                    double newNumOf = currentNumOf;
                    try {
                        int index = j * 2;
                        double existingNumOf = (Double)existingData.get(index);
                        double existingAvgOf = (Double)existingData.get(index + 1);
                        double existingSumOf = existingNumOf * existingAvgOf;
                        newNumOf = currentNumOf + existingNumOf;
                        double newSumOf = currentSumOf + existingSumOf;
                        if (newNumOf > 0.0) {
                            newAvgOf = newSumOf / newNumOf;
                        }
                    }
                    catch (Exception e) {
                        JTMLog.logger.warn("[URLPatternMeasure] - update method throws ", e);
                    }
                    syncDataList.add(new Double(newNumOf));
                    syncDataList.add(new Double(newAvgOf));
                }
                ++j;
            }
            this.pMeasureHT.put("patternData", syncDataList);
        } else {
            ArrayList<Double> syncDataList = new ArrayList<Double>(length);
            int j = 0;
            while (j < length) {
                if (j == 11 || j == 12 || j == 13 || j == 15 || j == 16 || j == 17) {
                    syncDataList.add(minusFive);
                    syncDataList.add(minusFive);
                } else {
                    double numOf = UPD.numOf[j];
                    double sumOf = UPD.sumOf[j];
                    double avgOf = 0.0;
                    if (numOf > 0.0) {
                        avgOf = sumOf / numOf;
                    }
                    syncDataList.add(new Double(numOf));
                    syncDataList.add(new Double(avgOf));
                }
                ++j;
            }
            this.pMeasureHT.put("patternData", syncDataList);
        }
        this.calculateSlowURLDetails(UPD);
        this.calculateErrorURLDetails(UPD);
    }

    private void calculateSlowURLDetails(URLPatternData UPD) {
        ArrayList slowDataList = null;
        boolean existingData = false;
        if (this.pMeasureHT.containsKey("SlowURLLists")) {
            slowDataList = (ArrayList)this.pMeasureHT.get("SlowURLLists");
            existingData = true;
        }
        if (slowDataList == null) {
            slowDataList = new ArrayList();
        }
        ArrayList slowUrlList = null;
        int initialSize = 0;
        if (UPD.getSlowURLsList() != null) {
            slowUrlList = (ArrayList)UPD.getSlowURLsList().clone();
            initialSize = slowUrlList.size();
            int k = 0;
            while (k < initialSize) {
                block10: {
                    try {
                        MethodInfo rootMI = (MethodInfo)slowUrlList.get(k);
                        List urlMeasureList = rootMI.getURLMeasureList(true);
                        if (urlMeasureList != null) {
                            slowDataList.add(new ArrayList(urlMeasureList));
                        }
                        if (rootMI.isErrorURL()) break block10;
                        rootMI.clearURLTree();
                    }
                    catch (Exception e) {
                        JTMLog.logger.error("Exception while iterating slowUrlList " + e);
                        break;
                    }
                }
                ++k;
            }
            if (existingData) {
                Collections.sort(slowDataList, new JTMUrlComparator());
                int nowSize = slowDataList.size();
                int maxSlow = UPDManager.getMaxSlowURLs();
                if (nowSize > maxSlow) {
                    int i = nowSize - 1;
                    while (i >= maxSlow) {
                        slowDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put("SlowURLLists", slowDataList);
        }
        slowUrlList = null;
        UPD.cleanSlowURLsList();
    }

    private void calculateErrorURLDetails(URLPatternData UPD) {
        ArrayList errorDataList = null;
        boolean existingData = false;
        if (this.pMeasureHT.containsKey("ErrorURLLists")) {
            errorDataList = (ArrayList)this.pMeasureHT.get("ErrorURLLists");
            existingData = true;
        }
        if (errorDataList == null) {
            errorDataList = new ArrayList();
        }
        ArrayList errorUrlList = null;
        int initialSize = 0;
        if (UPD.getErrorURLsList() != null) {
            errorUrlList = (ArrayList)UPD.getErrorURLsList().clone();
            initialSize = errorUrlList.size();
            int k = 0;
            while (k < initialSize) {
                try {
                    MethodInfo rootMI = (MethodInfo)errorUrlList.get(k);
                    List urlMeasureList = rootMI.getURLMeasureList(true);
                    if (urlMeasureList != null) {
                        errorDataList.add(new ArrayList(urlMeasureList));
                    }
                    rootMI.clearURLTree();
                }
                catch (Exception e) {
                    JTMLog.logger.error("Exception while iterating slowUrlList " + e);
                    break;
                }
                ++k;
            }
            if (existingData) {
                Collections.sort(errorDataList, new JTMUrlComparator());
                int nowSize = errorDataList.size();
                int maxError = UPDManager.getMaxErrorURLs();
                if (nowSize > maxError) {
                    int i = nowSize - 1;
                    while (i >= maxError) {
                        errorDataList.remove(i);
                        --i;
                    }
                }
            }
            this.pMeasureHT.put("ErrorURLLists", errorDataList);
        }
        errorUrlList = null;
        UPD.cleanErrorURLsList();
    }

    public String toString() {
        ArrayList ErrorURLLists;
        StringBuilder outSB = new StringBuilder();
        outSB.append("URLPatternMeasure for pattern ").append(this.pName).append("\n");
        outSB.append("'modified' flag is  ").append(this.modified).append("\n");
        if (this.pMeasureHT == null) {
            return outSB.toString();
        }
        ArrayList pMeasuresList = (ArrayList)this.pMeasureHT.get("patternData");
        if (pMeasuresList != null) {
            outSB.append(pMeasuresList.toString()).append("\n");
        } else {
            outSB.append("No measures\n");
        }
        ArrayList SlowURLLists = (ArrayList)this.pMeasureHT.get("SlowURLLists");
        if (SlowURLLists != null) {
            if (SlowURLLists.size() > 0) {
                outSB.append("Slow URL List: \n");
                int i = 0;
                while (i < SlowURLLists.size()) {
                    ArrayList SlowURLList = (ArrayList)SlowURLLists.get(i);
                    outSB.append("Slow URL ").append(i).append(" : ").append(SlowURLList.toString());
                    ++i;
                }
            } else {
                outSB.append("No Slow URLs for this pattern.\n");
            }
        }
        if ((ErrorURLLists = (ArrayList)this.pMeasureHT.get("ErrorURLLists")) != null) {
            if (ErrorURLLists.size() > 0) {
                outSB.append("Error URL List: \n");
                int i = 0;
                while (i < ErrorURLLists.size()) {
                    ArrayList ErrorURLList = (ArrayList)ErrorURLLists.get(i);
                    outSB.append("Error URL ").append(i).append(" : ").append(ErrorURLList.toString());
                    ++i;
                }
            } else {
                outSB.append("No Error URLs for this pattern.\n");
            }
        }
        outSB.append("*******************************************************************************************");
        return outSB.toString();
    }
}

