/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxASFException;
import com.informix.asf.IfxASFRemoteException;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDatabaseMetaData;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxLocales;
import com.informix.jdbc.IfxNativeSQL;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect$FPCacheInfo;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.IfxMessage;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxSqliConnect
implements IfxConnection {
    private static final String JDBCExtVer = "9.280";
    private static final int JDBCIntVer = 307;
    private static final int NEW_HANDSHAKE_VERSION = 316;
    private static final String JDBCSerialNo = "RDS#R000000";
    private byte[] clientProtocols = new byte[]{-1, -4, 127, -4, 60, -120};
    public static final short HASLOG = 1;
    protected static final short ANSIMODE = 2;
    private static final short FLT2DEC = 8;
    private static final short CHGLOC = 64;
    public static final short ANSIWARN = 16;
    private static final int ASFVER = 0;
    private static final int DSA722VER = 1;
    private static final int USVER = 2;
    private static final int USVER9_02 = 3;
    private static final int USVER9_03 = 4;
    private static final int USVER9_0301 = 5;
    private static final int DSA723VER = 6;
    private static final int USVER9_0302 = 7;
    private static final int USVER9_0303 = 8;
    private static final int ODS730VER = 9;
    private static final int USVER9_0304 = 10;
    private static final int USVER9_0305 = 11;
    private static final int USVER9_0306 = 12;
    private static final int USVER9_0307 = 13;
    private static final int USVER9_0308 = 14;
    private static final int USVER9_0309 = 15;
    private static final int USVER9_0310 = 16;
    private static final int XPS8_31 = 17;
    private static final int XPS8_40 = 18;
    private static final int USVER4_10 = 19;
    private static final int USVER5_00 = 20;
    private static final int USVER5_01 = 21;
    private static final int USVER6_00 = 22;
    private static final int USVER7_00 = 23;
    private static final int USVER7_01 = 24;
    private static final int USVER7_10 = 25;
    private static final int USVER7_21 = 26;
    private static final int USVER7_31 = 27;
    private static final int USVER8_00 = 28;
    private static final int USVER9_00 = 29;
    private static final int USVER9_0311 = 30;
    private static final int USVER9_0312 = 31;
    private static final int USVER9_0313 = 32;
    private static final int USVER9_0314 = 33;
    private static final int USVER9_0315 = 34;
    private static final int USVER9_0316 = 35;
    private static final int USVER9_0317 = 36;
    private static final int USVER9_0318 = 37;
    private static final int USVER9_0319 = 38;
    private static final int USVER9_0320 = 39;
    private static final int USVER9_0321 = 40;
    private static final int USVER7_31GW = 41;
    private static final int USVER9_0322 = 42;
    private static final int USVER9_0323 = 43;
    private static final int USVER9_0324 = 44;
    private static final int DSA700VER = 45;
    private static final int DSA731VER = 46;
    private static final int GLSVER = 47;
    private static final int MAXFEATURE = 48;
    static final short NOXACT = 0;
    static final short SXACT = 1;
    static final short XACT = 2;
    private static final int DRSECOND = 32;
    private static final String PREFIX = "_ifxc";
    private static final String ZEROSTRING = new String("0000000000000");
    private long nextID = 0L;
    private SQLWarning connwarn = null;
    protected boolean isOpen = false;
    private BitSet dbVersion = new BitSet(48);
    private int internalVersion = 0;
    protected String externalVersion = null;
    protected String productName = null;
    private boolean floatToDec = false;
    private boolean onlineSer = false;
    protected com.informix.asf.Connection asfconn = null;
    protected IfxProtocol proto = null;
    private String URL = null;
    protected Properties connInfo = null;
    protected String userName = null;
    private String passwd = null;
    private String org_url = null;
    protected String dbName = null;
    private String dbLocale = null;
    private String dbEncoding = null;
    private String clLocale = null;
    private String clEncoding = null;
    private String dbDate = null;
    private String glDate = null;
    private String dbCentury = null;
    private boolean useDtenv = false;
    private String dbTime = null;
    private String glDateTime = null;
    private boolean is_client_loc_set = false;
    private boolean is_db_loc_set = false;
    private long dbTodayDate = -1L;
    private long dbTodayStart = -1L;
    private boolean convText = false;
    private boolean batchUpdatePerSpec = true;
    private boolean ctsCompliant = false;
    private int codesetLobSize = 0;
    Hashtable IfxToJdkEncodingTable = null;
    Hashtable IfxNoToJdkEncodingTable = null;
    Hashtable IfxToJdkLocaleTable = null;
    protected boolean Noansiwarn = true;
    protected boolean delimIdent = false;
    private boolean useV5server = false;
    private int retryCount = 1;
    String servername;
    int fetchBufSize = -1;
    private int lobCacheSize = 4096;
    private Properties PrimEnvVars;
    private Properties SecEnvVars;
    Hashtable fpCache = null;
    private IfxDataInputStream InputStream = null;
    private IfxDataOutputStream OutputStream = null;
    private boolean insqlexec = false;
    Trace traceObj = null;
    Trace protoTraceObj = null;
    boolean autoCommit = true;
    private int transactionLevel = 0;
    short TxState = 0;
    boolean SendCommit = false;
    private boolean isDatabaseOpen = false;
    boolean db_use_log = false;
    boolean AnsiDb = false;
    private boolean chgLocale = false;
    private short SerWarn;
    private StringBuffer serverWarningsString = new StringBuffer("        ");
    private boolean TrimTrailingSpaces = false;
    boolean readOnly = false;
    boolean hdrEnabled = false;
    int CapList = 0;
    int TypeList = 0;
    private boolean autoFree = false;
    protected boolean usePut = false;
    private boolean ifxPADVARCHAR = false;
    private boolean mapFloat = true;
    private boolean mapReal = true;
    private boolean sessionMutexLocked = false;
    private Thread lockThread = null;
    private boolean lockModeWaitChanged;
    private boolean isolationLevelChanged;
    private String newLockModeWaitStr;
    private String newIsolationLevelStr;
    private int newTxLevel = 0;
    protected String protoClassName;
    private Map udtMap = null;
    private Map xidMap = null;
    private Map userMap = null;
    private boolean useTypeCache = false;
    private int internalQuery = 0;
    private static final int IQstart = 1;
    private static final int IQsendCommit = 2;
    private boolean autoCommitModeChanged = false;
    private String tempdir = null;
    protected Vector stmtList = null;
    private int stmtErrorOffset = 0;
    protected Vector blobList = null;

    public Vector getBlobList() {
        return this.blobList;
    }

    public boolean isDirect() {
        return false;
    }

    public IfxSqliConnect() throws SQLException {
    }

    public IfxSqliConnect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        Object object;
        Object object2;
        Class<?> clazz;
        String string4;
        int n;
        int n2;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        Object var7_6 = null;
        Object var8_7 = null;
        Object var9_8 = null;
        Object var10_9 = null;
        String string8 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 307;
        Properties properties2 = new Properties();
        String string9 = null;
        String string10 = null;
        boolean bl3 = false;
        this.connInfo = properties;
        this.org_url = this.connInfo.getProperty("USERURL");
        this.URL = string;
        this.userName = this.connInfo.getProperty("USER");
        this.passwd = this.connInfo.getProperty("PASSWORD");
        if (this.userName != null) {
            this.userName = this.userName.trim();
        }
        if (this.passwd != null) {
            this.passwd = this.passwd.trim();
        }
        if (this.org_url != null) {
            this.org_url = this.org_url.trim();
        }
        if (this.URL != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.URL, ":");
            string6 = stringTokenizer.nextToken();
            string7 = stringTokenizer.nextToken();
        } else {
            string6 = null;
            string7 = null;
        }
        String string11 = this.connInfo.getProperty("ENABLE_HDRSWITCH");
        if (string11 != null && string11.equalsIgnoreCase("true")) {
            bl3 = true;
        }
        String string12 = this.connInfo.getProperty("INFORMIXSERVER_SECONDARY");
        string9 = this.connInfo.getProperty("PORTNO_SECONDARY");
        string10 = this.connInfo.getProperty("IFXHOST_SECONDARY");
        string8 = this.connInfo.getProperty("DBANSIWARN");
        if (string8 != null) {
            try {
                if (Integer.parseInt(string8) == 0) {
                    this.Noansiwarn = true;
                } else if (Integer.parseInt(string8) == 1) {
                    this.Noansiwarn = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string8 = this.connInfo.getProperty("FET_BUF_SIZE")) != null) {
            try {
                this.fetchBufSize = Integer.parseInt(string8);
            }
            catch (NumberFormatException numberFormatException) {
                this.fetchBufSize = -1;
            }
        }
        if ((string8 = this.connInfo.getProperty("BIG_FET_BUF_SIZE")) != null) {
            try {
                int n4 = Integer.parseInt(string8);
                if (n4 > this.fetchBufSize) {
                    this.fetchBufSize = n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.fetchBufSize = -1;
            }
        }
        if ((string8 = this.connInfo.getProperty("NEWLOCALE")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string8, ":");
            n2 = stringTokenizer.countTokens();
            this.IfxToJdkLocaleTable = new Hashtable();
            n = 0;
            while (n < n2) {
                string4 = stringTokenizer.nextToken();
                clazz = new StringTokenizer(string4, ",");
                object2 = ((StringTokenizer)((Object)clazz)).nextToken(",");
                if (!((StringTokenizer)((Object)clazz)).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79784, this);
                }
                object = ((StringTokenizer)((Object)clazz)).nextToken();
                this.addLocale((String)object2, (String)object);
                ++n;
            }
        }
        if ((string8 = this.connInfo.getProperty("NEWCODESET")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string8, ":");
            n2 = stringTokenizer.countTokens();
            this.IfxToJdkEncodingTable = new Hashtable();
            this.IfxNoToJdkEncodingTable = new Hashtable();
            n = 0;
            while (n < n2) {
                string4 = stringTokenizer.nextToken();
                clazz = new StringTokenizer(string4, ",");
                object2 = ((StringTokenizer)((Object)clazz)).nextToken();
                if (!((StringTokenizer)((Object)clazz)).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                object = ((StringTokenizer)((Object)clazz)).nextToken();
                this.addEncName((String)object, (String)object2);
                if (!((StringTokenizer)((Object)clazz)).hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                object = ((StringTokenizer)((Object)clazz)).nextToken();
                this.addEncNumber((String)object, (String)object2);
                ++n;
            }
        }
        if ((string8 = this.connInfo.getProperty("LOBCACHE")) != null) {
            try {
                this.lobCacheSize = Integer.parseInt(string8);
            }
            catch (NumberFormatException numberFormatException) {
                this.lobCacheSize = 4096;
            }
        }
        if ((string8 = this.connInfo.getProperty("INFORMIXCONRETRY")) != null) {
            try {
                int n5 = Integer.parseInt(string8);
                if (n5 >= 1) {
                    this.retryCount = n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.retryCount = 1;
            }
        }
        if ((string8 = this.connInfo.getProperty("DELIMIDENT")) != null) {
            this.delimIdent = true;
        }
        if ((string8 = this.connInfo.getProperty("IFX_PAM_CLASS")) != null) {
            try {
                Class<?> clazz2 = Class.forName(string8);
                Class<?>[] classArray = clazz2.getInterfaces();
                n = 0;
                int n6 = 0;
                while (n == 0 && n6 < classArray.length) {
                    clazz = classArray[n6];
                    if (clazz.getName().equals("com.informix.jdbc.IfmxPAM")) {
                        n = 1;
                    }
                    ++n6;
                }
                if (n == 0) {
                    throw IfxErrMsg.getSQLException(-79884, this);
                }
                properties2.put("IFX_PAM_CLASS", string8);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw IfxErrMsg.getSQLException(-79883, this);
            }
        }
        if ((string8 = this.connInfo.getProperty("USEV5SERVER")) != null) {
            n3 = 0;
            this.useV5server = true;
        }
        if ((this.servername = this.connInfo.getProperty("INFORMIXSERVER")) == null) {
            throw IfxErrMsg.getSQLException(-79734, this);
        }
        this.tempdir = this.connInfo.getProperty("JDBCTEMP");
        if (this.tempdir != null) {
            this.tempdir = this.tempdir.trim();
            String string13 = System.getProperty("file.separator");
            if (this.tempdir.lastIndexOf(string13) != this.tempdir.length() - 1) {
                this.tempdir = this.tempdir + string13;
            }
        }
        if ((string8 = this.connInfo.getProperty("SQLH_TYPE")) != null) {
            properties2.put("SQLH_TYPE", string8);
            if (string8.equalsIgnoreCase("FILE")) {
                string8 = this.connInfo.getProperty("SQLH_FILE");
                if (string8 != null) {
                    properties2.put("SQLH_FILE", string8);
                }
            } else if (string8.equalsIgnoreCase("LDAP")) {
                string8 = this.connInfo.getProperty("LDAP_URL");
                if (string8 != null) {
                    properties2.put("LDAP_URL", string8);
                }
                if ((string8 = this.connInfo.getProperty("LDAP_IFXBASE")) != null) {
                    properties2.put("LDAP_IFXBASE", string8);
                }
                if ((string8 = this.connInfo.getProperty("LDAP_USER")) != null) {
                    properties2.put("LDAP_USER", string8);
                }
                if ((string8 = this.connInfo.getProperty("LDAP_PASSWD")) != null) {
                    properties2.put("LDAP_PASSWD", string8);
                }
            }
            if ((string8 = this.connInfo.getProperty("SQLH_LOC")) != null) {
                properties2.put("SQLH_LOC", string8);
            } else {
                properties2.put("SQLH_LOC", "CLIENT");
            }
        }
        if ((string8 = this.connInfo.getProperty("SECURITY")) != null) {
            properties2.put("SECURITY", string8);
        }
        if ((string8 = this.connInfo.getProperty("CSM")) != null) {
            properties2.put("CSM", string8);
        }
        if ((string8 = (String)properties2.get("SECURITY")) != null && string8.equalsIgnoreCase("confidentiality")) {
            properties2.remove("SECURITY");
        }
        if ((string8 = this.connInfo.getProperty("PROXY")) != null) {
            properties2.put("PROXY", string8);
        }
        if ((string3 = this.connInfo.getProperty("ENABLE_TYPE_CACHE")) != null && string3.equalsIgnoreCase("true")) {
            this.useTypeCache = true;
        }
        string5 = string6 == null || string7 == null ? null : this.formatURL(string6, string7);
        this.PrimEnvVars = this.SetPrimEVars();
        if (this.dbEncoding != null) {
            properties2.put("DBENC", this.dbEncoding);
        }
        if ((string8 = this.connInfo.getProperty("INFORMIXCONTIME")) != null) {
            properties2.put("INFORMIXCONTIME", string8);
        }
        String string14 = JDBCExtVer;
        try {
            this.asfconn = new com.informix.asf.Connection(this.userName, this.passwd, string5, this.servername, this.dbName, this.PrimEnvVars, string14, n3, JDBCSerialNo, this.retryCount, properties2);
        }
        catch (IfxASFRemoteException ifxASFRemoteException) {
            String string15 = ifxASFRemoteException.toString();
            int n7 = ifxASFRemoteException.getError();
            if (bl3 && (n7 == -908 || n7 == -27002)) {
                string5 = string10 == null || string9 == null ? null : this.formatURL(string10, string9);
                try {
                    this.asfconn = new com.informix.asf.Connection(this.userName, this.passwd, string5, string12, this.dbName, this.PrimEnvVars, string14, n3, JDBCSerialNo, this.retryCount, properties2);
                }
                catch (IfxASFRemoteException ifxASFRemoteException2) {
                    object2 = ifxASFRemoteException2.toString();
                    int n8 = ifxASFRemoteException2.getError();
                    if (object2 != null && ((String)object2).length() > 0) {
                        throw new SQLException(IfxMessage.getMessage(n8, (String)object2, this.getclLocale()), IfxMessage.getSQLSTATE(n8), n7);
                    }
                    throw IfxErrMsg.getSQLException(n8, this);
                }
                catch (IfxASFException ifxASFException) {
                    object = ifxASFException.toString();
                    int n9 = ifxASFException.getErrorId();
                    if (object != null && ((String)object).length() > 0) {
                        throw new SQLException((String)object, IfxMessage.getSQLSTATE(n9), n9);
                    }
                    throw IfxErrMsg.getSQLException(n9, this);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79999, exception.toString(), (IfxConnection)this);
                }
            }
            if (string15 != null && string15.length() > 0) {
                throw new SQLException(IfxMessage.getMessage(n7, string15, this.getclLocale()), IfxMessage.getSQLSTATE(n7), n7);
            }
            throw IfxErrMsg.getSQLException(n7, this);
        }
        catch (IfxASFException ifxASFException) {
            String string16 = ifxASFException.toString();
            int n10 = ifxASFException.getErrorId();
            if (bl3 && (n10 == -908 || n10 == -27002)) {
                string5 = string10 == null || string9 == null ? null : this.formatURL(string10, string9);
                try {
                    this.asfconn = new com.informix.asf.Connection(this.userName, this.passwd, string5, string12, this.dbName, this.PrimEnvVars, string14, n3, JDBCSerialNo, this.retryCount, properties2);
                }
                catch (IfxASFRemoteException ifxASFRemoteException) {
                    object = ifxASFRemoteException.toString();
                    int n11 = ifxASFRemoteException.getError();
                    if (object != null && ((String)object).length() > 0) {
                        throw new SQLException(IfxMessage.getMessage(n11, (String)object, this.getclLocale()), IfxMessage.getSQLSTATE(n11), n10);
                    }
                    throw IfxErrMsg.getSQLException(n11, this);
                }
                catch (IfxASFException ifxASFException2) {
                    String string17 = ifxASFException2.toString();
                    int n12 = ifxASFException2.getErrorId();
                    if (string17 != null && string17.length() > 0) {
                        throw new SQLException(string17, IfxMessage.getSQLSTATE(n12), n12);
                    }
                    throw IfxErrMsg.getSQLException(n12, this);
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79999, exception.toString(), (IfxConnection)this);
                }
            }
            if (string16 != null && string16.length() > 0) {
                throw new SQLException(string16, IfxMessage.getSQLSTATE(n10), n10);
            }
            throw IfxErrMsg.getSQLException(n10, this);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79999, exception.toString(), (IfxConnection)this);
        }
        this.internalVersion = this.asfconn.Cap_1;
        String string18 = this.asfconn.VersionNumber;
        try {
            int n13 = string18.indexOf("Version");
            this.productName = string18.substring(0, n13 - 1).trim();
            this.externalVersion = string18.substring(n13 + 7).trim();
        }
        catch (Exception exception) {
            this.productName = "Informix Dynamic Server";
        }
        this.SerWarn = this.asfconn.Warnings;
        this.setWarnings();
        if ((this.SerWarn & 0x20) != 0) {
            this.readOnly = true;
        }
        if ((this.SerWarn & 8) != 0) {
            this.floatToDec = true;
        }
        this.isOpen = true;
        try {
            this.InputStream = this.asfconn.getIfxDataInputStream();
        }
        catch (IfxASFException ifxASFException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        try {
            this.OutputStream = this.asfconn.getIfxDataOutputStream();
        }
        catch (IfxASFException ifxASFException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        try {
            this.protoClassName = this.connInfo.getProperty("PROTOCOLCLASS");
            string2 = this.connInfo.getProperty("CONNECTIONCLASS");
            Class<?> clazz3 = Class.forName(string2);
            Class[] classArray = new Class[]{clazz3};
            object2 = Class.forName(this.protoClassName);
            object = ((Class)object2).getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            this.proto = (IfxProtocol)((Constructor)object).newInstance(objectArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), (IfxConnection)this);
        }
        try {
            this.getServerVer();
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException(sQLException.toString());
        }
        if (this.isPAMAuthentication()) {
            this.proto.handlePAMAuthentication(this.connInfo.getProperty("IFX_PAM_CLASS"));
        }
        if (this.connInfo.getProperty("IFX_AUTOFREE", "0").equals("1") && this.isAutoFree()) {
            this.autoFree = true;
        }
        if (this.connInfo.getProperty("IFX_USEPUT", "0").equals("1")) {
            this.usePut = true;
        }
        if (this.connInfo.getProperty("IFX_TRIMTRAILINGSPACES", "0").equals("1")) {
            this.TrimTrailingSpaces = true;
        }
        if (this.connInfo.getProperty("IFX_PAD_VARCHAR", "0").equals("1")) {
            this.ifxPADVARCHAR = true;
        }
        this.SecEnvVars = this.SetSecEVars();
        try {
            this.proto.executeEnv(this.SecEnvVars);
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw IfxErrMsg.getSQLException(-79716, this);
        }
        string2 = this.useV5server ? this.PrimEnvVars.getProperty("DBTODAY") : this.SecEnvVars.getProperty("DBTODAY");
        if (string2 != null) {
            try {
                this.dbTodayDate = Timestamp.valueOf(string2).getTime();
                this.dbTodayStart = System.currentTimeMillis();
            }
            catch (Exception exception) {
                this.dbTodayDate = -1L;
                this.dbTodayStart = -1L;
            }
        }
        if ((string8 = this.connInfo.getProperty("CTS_COMPLIANT")) != null && Integer.parseInt(string8) == 1) {
            this.ctsCompliant = true;
        }
        if ((string8 = this.connInfo.getProperty("IFX_BATCHUPDATE_PER_SPEC")) != null && Integer.parseInt(string8) == 0) {
            this.batchUpdatePerSpec = false;
        }
        if ((string8 = this.connInfo.getProperty("IFX_CODESETLOB")) != null) {
            this.convText = true;
            try {
                this.codesetLobSize = Integer.parseInt(string8);
            }
            catch (NumberFormatException numberFormatException) {
                this.codesetLobSize = -1;
                this.convText = false;
            }
        }
        if ((string8 = this.connInfo.getProperty("IFX_SET_FLOAT_AS_SMFLOAT")) != null && Integer.parseInt(string8) == 1) {
            this.mapFloat = false;
        }
        if ((string8 = this.connInfo.getProperty("IFX_GET_SMFLOAT_AS_FLOAT")) != null && Integer.parseInt(string8) == 1) {
            this.mapReal = false;
        }
        this.fpCache = new Hashtable();
        this.dbName = this.connInfo.getProperty("DATABASE");
        if (this.dbName != null) {
            this.dbName = this.dbName.trim();
            this.proto.executeOpenDatabase(this.dbName, 0);
            this.proto.clear();
        }
        if (this.useV5server && this.dbName != null) {
            this.set5ServerType();
        }
        if ((string8 = this.connInfo.getProperty("IFX_LOCK_MODE_WAIT")) != null) {
            int n14;
            try {
                n14 = Integer.parseInt(string8);
            }
            catch (NumberFormatException numberFormatException) {
                n14 = 0;
            }
            this.setLockModeWait(n14);
        }
        if ((string8 = this.connInfo.getProperty("IFX_ISOLATION_LEVEL")) != null) {
            this.setIsolationLevel(string8);
        }
    }

    public void close() throws SQLException {
        if (!this.isOpen) {
            return;
        }
        if (this.isDatabaseOpen) {
            this.CloseDbReset();
        }
        this.clearWarnings();
        this.isOpen = false;
        this.dbName = null;
        this.floatToDec = false;
        this.insqlexec = false;
        this.onlineSer = false;
        this.InputStream = null;
        this.OutputStream = null;
        if (this.stmtList != null) {
            this.stmtList.removeAllElements();
            this.stmtList = null;
        }
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        this.clear_dbVersion();
        this.internalVersion = 0;
        this.externalVersion = null;
        try {
            if (this.asfconn != null) {
                this.asfconn.disconnectOrderly();
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this);
        }
    }

    public boolean isClosed() throws SQLException {
        return !this.isOpen;
    }

    public void scrubConnection() throws SQLException {
        if (this.dbName != null) {
            this.closeAllResultSets();
            this.clearTransactions();
            this.resetDatabaseProperties();
        }
    }

    protected void clearTransactions() throws SQLException {
        if (this.TxState == 2) {
            this.rollback();
        }
    }

    protected void closeAllResultSets() throws SQLException {
        if (this.stmtList != null) {
            int n = 0;
            while (n < this.stmtList.size()) {
                IfxStatement ifxStatement = (IfxStatement)this.stmtList.elementAt(n);
                if (!ifxStatement.Closed && ifxStatement.savedResult != null) {
                    try {
                        ifxStatement.savedResult.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    protected void resetDatabaseProperties() throws SQLException {
        Statement statement = this.createStatement();
        String string = null;
        String string2 = null;
        this.setAutoCommit(true);
        this.transactionLevel = 0;
        if (this.AnsiDb) {
            string = "Repeatable Read";
            this.transactionLevel = 8;
        } else if (this.db_use_log) {
            string = "Committed Read";
            this.transactionLevel = 2;
        }
        if (this.isolationLevelChanged) {
            string2 = this.newIsolationLevelStr + ";";
            this.transactionLevel = this.newTxLevel;
        } else {
            String string3 = string2 = string != null ? "set isolation to " + string + ";" : "";
        }
        string2 = this.useV5server ? string2 + "set explain off;" + "set optimization high;" : (this.externalVersion.charAt(0) == '8' && this.externalVersion.charAt(2) <= '3' ? string2 + "set dataskip default;" + "set explain off;" + "set optimization high;" + "set pdqpriority default;" : string2 + "set dataskip default;" + "set explain off;" + "set optimization high;" + "set pdqpriority default;" + "set role null;");
        string2 = this.lockModeWaitChanged ? string2 + this.newLockModeWaitStr + ";" : string2 + "set lock mode to not wait;";
        try {
            statement.execute(string2);
        }
        catch (SQLException sQLException) {
            statement.close();
            throw sQLException;
        }
        statement.close();
    }

    protected void closeAllStatements() throws SQLException {
        if (this.stmtList != null) {
            while (this.stmtList.size() > 0) {
                IfxStatement ifxStatement = (IfxStatement)this.stmtList.elementAt(0);
                if (ifxStatement.Closed) continue;
                ifxStatement.close();
            }
            this.stmtList = null;
        }
    }

    public boolean scrubConnectionReleasesAllStatements() {
        return false;
    }

    public void commit() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79744, this);
        }
        if (!this.autoCommit && this.TxState != 2) {
            return;
        }
        try {
            this.proto.executeCommit();
        }
        catch (SQLException sQLException) {
            this.setTxEndState();
            throw sQLException;
        }
        catch (Exception exception) {
            this.setTxEndState();
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
    }

    public void rollback() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79744, this);
        }
        if (!this.autoCommit && this.TxState != 2) {
            return;
        }
        try {
            this.proto.executeRollback();
        }
        catch (SQLException sQLException) {
            this.setTxEndState();
            throw sQLException;
        }
        catch (Exception exception) {
            this.setTxEndState();
            throw IfxErrMsg.getSQLException(-79747, exception.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        this.autoCommit = bl;
        if (this.autoCommit) {
            if (this.TxState == 2) {
                try {
                    if (IfxDriver.compareJDKVersion("1.4") < 0) {
                        this.proto.executeRollback();
                    } else {
                        this.proto.executeCommit();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.setTxEndState();
            } else if (this.TxState == 1 && this.AnsiDb) {
                this.SendCommit = true;
            }
        } else {
            if (!this.db_use_log) {
                this.autoCommit = true;
                throw IfxErrMsg.getSQLException(-79744, this);
            }
            if (this.TxState == 1 && this.AnsiDb) {
                this.SendCommit = false;
            }
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        return this.autoCommit;
    }

    public void clearWarnings() throws SQLException {
        this.connwarn = null;
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        if (this.proto != null && (sQLWarning = this.proto.getWarnings()) != null) {
            this.addWarning(sQLWarning, null);
            this.proto.clearWarnings();
        }
        return this.connwarn;
    }

    void addWarning(SQLWarning sQLWarning, String string) {
        if (sQLWarning == null) {
            sQLWarning = IfxWarnMsg.getSQLWarning(string, null, this);
        }
        if (this.connwarn == null) {
            this.connwarn = sQLWarning;
        } else {
            this.connwarn.setNextWarning(sQLWarning);
        }
    }

    public Statement createStatement() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxStatement ifxStatement = new IfxStatement(this);
        this.addToStmtList(ifxStatement);
        return ifxStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxStatement ifxStatement = new IfxStatement(this);
        ifxStatement.setResultSetType(n);
        ifxStatement.setResultSetConcurrency(n2);
        this.addToStmtList(ifxStatement);
        return ifxStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxPreparedStatement ifxPreparedStatement = new IfxPreparedStatement(this, string);
        this.addToStmtList(ifxPreparedStatement);
        return ifxPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxPreparedStatement ifxPreparedStatement = new IfxPreparedStatement(this, string);
        ifxPreparedStatement.setResultSetType(n);
        ifxPreparedStatement.setResultSetConcurrency(n2);
        this.addToStmtList(ifxPreparedStatement);
        return ifxPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxCallableStatement ifxCallableStatement = new IfxCallableStatement((Connection)this, string);
        this.addToStmtList(ifxCallableStatement);
        return ifxCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        IfxCallableStatement ifxCallableStatement = new IfxCallableStatement((Connection)this, string);
        ifxCallableStatement.setResultSetType(n);
        ifxCallableStatement.setResultSetConcurrency(n2);
        this.addToStmtList(ifxCallableStatement);
        return ifxCallableStatement;
    }

    public Map getTypeMap() throws SQLException {
        if (this.userMap == null) {
            this.userMap = Collections.synchronizedMap(new IfxMap(this.isDelimIdentSet()));
        }
        return this.userMap;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.userMap = map;
    }

    public String nativeSQL(String string) throws SQLException {
        IfxNativeSQL ifxNativeSQL = new IfxNativeSQL(string, this);
        return ifxNativeSQL.getNewString();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        return new IfxDatabaseMetaData(this);
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.getDbName();
    }

    public void setReadOnly(boolean bl) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        if (this.hdrEnabled) {
            String string = this.getHDRType();
            this.readOnly = string != null && string.equalsIgnoreCase("Secondary");
        }
        return this.readOnly;
    }

    public String getHDRType() throws SQLException {
        String string = null;
        this.startMetaDataQuery();
        try {
            Statement statement = this.createStatement();
            String string2 = "select type from sysmaster:informix.sysdri";
            ResultSet resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            this.endMetaDataQuery();
            throw sQLException;
        }
        this.endMetaDataQuery();
        if (string != null) {
            return string.trim();
        }
        return null;
    }

    public boolean isHDREnabled() throws SQLException {
        String string = null;
        this.startMetaDataQuery();
        try {
            Statement statement = this.createStatement();
            String string2 = "select state from sysmaster:informix.sysdri";
            ResultSet resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            this.endMetaDataQuery();
            throw sQLException;
        }
        this.endMetaDataQuery();
        this.hdrEnabled = !string.trim().equalsIgnoreCase("off");
        return this.hdrEnabled;
    }

    public int getMaxLvarcharSize() {
        IfxDatabaseMetaData ifxDatabaseMetaData = new IfxDatabaseMetaData(this);
        int n = ifxDatabaseMetaData.getMaxLvarcharSize();
        ifxDatabaseMetaData = null;
        return n;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        String string = null;
        if (!this.isOpen) {
            throw IfxErrMsg.getSQLException(-79730, this);
        }
        if (!this.isDatabaseOpen) {
            throw IfxErrMsg.getSQLException(-349, this);
        }
        if (!this.db_use_log) {
            throw IfxErrMsg.getSQLException(-79746, this);
        }
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw IfxErrMsg.getSQLException(-79747, this);
        }
        if (this.TxState == 1) {
            if (n == this.transactionLevel) {
                return;
            }
        } else if (this.TxState == 2) {
            this.commit();
        }
        switch (n) {
            case 1: {
                string = new String("dirty read");
                break;
            }
            case 2: {
                string = new String("committed read");
                break;
            }
            case 4: 
            case 8: {
                string = new String("repeatable read");
            }
        }
        Statement statement = this.createStatement();
        int n2 = statement.executeUpdate("set isolation to " + string);
        statement.close();
        if (this.TxState == 2) {
            this.commit();
        }
        this.transactionLevel = n;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionLevel;
    }

    public int getDatabaseType() throws SQLException {
        if (!this.isDatabaseOpen) {
            return 0;
        }
        if (this.AnsiDb) {
            return 1;
        }
        if (this.db_use_log) {
            return 2;
        }
        return 3;
    }

    void setCapList(int n) {
        this.CapList = n;
    }

    void setTypeList(int n) {
        this.TypeList = n;
    }

    public boolean isDbOpen() throws SQLException {
        return this.isDatabaseOpen;
    }

    public String getConnectionDbName() throws SQLException {
        return this.dbName;
    }

    public String getDbName() throws SQLException {
        if (this.dbName != null) {
            return this.dbName;
        }
        if (!this.isSysmaster() || !this.isCurSessInfo()) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxConnection.getDbName().", (IfxConnection)this);
        }
        try {
            String string = "select scs_currdb from sysmaster:informix.syssqlcurses";
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            String string2 = null;
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            if (string2 != null) {
                string2 = stringUtil.trimTrailings(string2);
            }
            return string2;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    void setDatabaseOpen(boolean bl, short s) throws SQLException {
        if (bl) {
            this.SerWarn = s;
            this.OpenDbInit();
            if (this.isGLS()) {
                if (this.dbName != null && (this.chgLocale || this.dbEncoding == null)) {
                    this.setDatabaseLocale();
                }
            } else {
                if (this.dbEncoding != null || this.clLocale != null || this.glDate != null) {
                    throw IfxErrMsg.getSQLException(-79789, this);
                }
                this.dbEncoding = null;
                this.dbLocale = null;
                this.clLocale = null;
                this.clEncoding = null;
                this.glDate = null;
            }
        } else {
            this.CloseDbReset();
        }
    }

    public String getURL() throws SQLException {
        return this.org_url;
    }

    public String getUserName() throws SQLException {
        if (this.asfconn != null) {
            return this.asfconn.getUserName();
        }
        return this.userName;
    }

    public String getJDBCVersion() throws SQLException {
        return IfxDriver.getJDBCVersion();
    }

    public String getDbProductName() throws SQLException {
        return this.productName;
    }

    public String getDbVersion() throws SQLException {
        return this.externalVersion == null ? "unknown" : this.externalVersion;
    }

    private void OpenDbInit() throws SQLException {
        this.CloseDbReset();
        this.isDatabaseOpen = true;
        if ((this.SerWarn & 1) != 0) {
            this.db_use_log = true;
            this.transactionLevel = 2;
        }
        if ((this.SerWarn & 2) != 0) {
            this.AnsiDb = true;
            this.transactionLevel = 8;
        }
        if ((this.SerWarn & 0x40) != 0) {
            this.chgLocale = true;
        }
        this.TxState = !this.db_use_log ? (short)0 : 1;
        if (this.AnsiDb) {
            this.SendCommit = true;
        }
        this.clearWarnings();
        this.setWarnings();
    }

    private void CloseDbReset() {
        this.AnsiDb = false;
        this.chgLocale = false;
        this.transactionLevel = 0;
        this.autoCommit = true;
        this.db_use_log = false;
        this.isDatabaseOpen = false;
        this.TxState = 0;
        this.SendCommit = false;
    }

    private void setDatabaseLocale() throws SQLException {
        int n;
        boolean bl;
        block8: {
            bl = false;
            n = 0;
            if (this.getDbVersion().charAt(0) == '8' && (n = this.getTransactionIsolation()) != 1) {
                this.setTransactionIsolation(1);
                bl = true;
            }
            try {
                String string = this.onlineSer ? "select site from informix.systables where tabname = ' GL_COLLATE'" : "select dirpath from informix.systables where tabname = ' GL_COLLATE'";
                Statement statement = this.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                String string2 = null;
                if (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    resultSet.close();
                    statement.close();
                }
                this.parseIfxLocale("db", string2.trim());
                String string3 = this.getEncNo(this.dbEncoding);
                if (string3 == null) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
                this.dbEncoding = string3;
                if (this.clLocale != null) break block8;
                this.clEncoding = this.dbEncoding;
                String string4 = this.getLocale(this.dbLocale);
                if (string4 != null) {
                    this.clLocale = this.dbLocale;
                    break block8;
                }
                throw IfxErrMsg.getSQLException(-79784, this);
            }
            catch (SQLException sQLException) {
                if (bl) {
                    this.setTransactionIsolation(n);
                }
                throw sQLException;
            }
        }
        if (bl) {
            this.setTransactionIsolation(n);
        }
    }

    protected Properties SetPrimEVars() throws SQLException {
        String string;
        String[] stringArray = new String[]{"INFORMIXSTACKSIZE", "DBSPACETEMP", "SLABEL", "SINGLELEVEL", "LKNOTIFY", "LOCKDOWN", "NODEFDAC", "DELIMIDENT", "SKINHIBIT", "SKALL", "SKSHOW", "DB_LOCALE", "CLIENT_LOCALE", "DBDATE", "GL_DATE", "RASHELP", "STMT_CACHE", "STMT_CACHE_DEBUG", "IFX_LONGID", "DBPATH"};
        Properties properties = new Properties();
        properties.put("SINGLELEVEL", "no");
        properties.put("LKNOTIFY", "yes");
        properties.put("LOCKDOWN", "no");
        properties.put("NODEFDAC", "no");
        properties.put("SKINHIBIT", "0");
        properties.put("SKALL", "0");
        properties.put("SKSHOW", "0");
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            string2 = this.connInfo.getProperty(stringArray[n]);
            if (string2 != null) {
                properties.put(stringArray[n], string2);
            }
            ++n;
        }
        String string3 = properties.getProperty("DB_LOCALE");
        if (string3 != null) {
            this.parseIfxLocale("db", string3);
            string = this.getEncName(this.dbEncoding);
            if (string == null) {
                this.dbEncoding = this.getEncNo(this.dbEncoding);
                if (this.dbEncoding == null) {
                    throw IfxErrMsg.getSQLException(-79783, this);
                }
            } else {
                this.dbEncoding = string;
            }
            this.dbLocale = this.getLocale(this.dbLocale);
            if (this.dbLocale == null) {
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        } else {
            this.dbLocale = null;
            this.dbEncoding = null;
        }
        this.dbDate = properties.getProperty("DBDATE");
        this.glDate = properties.getProperty("GL_DATE");
        string = properties.getProperty("CLIENT_LOCALE");
        if (string != null) {
            this.parseIfxLocale("cl", string);
            this.clEncoding = this.getEncName(this.clEncoding);
            this.clLocale = this.getLocale(this.clLocale);
            if (this.clLocale == null) {
                throw IfxErrMsg.getSQLException(-79784, this);
            }
        } else if (this.dbLocale != null && this.dbEncoding != null) {
            this.clEncoding = this.dbEncoding;
            this.clLocale = this.dbLocale;
        } else {
            Locale locale = Locale.getDefault();
            String string4 = locale.getLanguage();
            String string5 = locale.getCountry();
            if (!this.useV5server && string4.equals("en") && (string5.equals("") || string5.equals("US"))) {
                this.clLocale = File.separator.equals("/") ? "en_US.8859-1" : "en_US.CP1252";
                properties.put("CLIENT_LOCALE", this.clLocale);
                if (this.dbDate == null && this.glDate == null) {
                    this.dbDate = "Y4MD-";
                    properties.put("DBDATE", "Y4MD-");
                }
            } else {
                this.clLocale = null;
            }
            this.clEncoding = null;
        }
        if (this.dbDate == null && this.glDate == null && properties.getProperty("CLIENT_LOCALE") == null && properties.getProperty("DB_LOCALE") == null) {
            this.dbDate = "Y4MD-";
            properties.put("DBDATE", "Y4MD-");
        }
        if (properties.getProperty("CLIENT_LOCALE") != null) {
            this.is_client_loc_set = true;
        }
        if (properties.getProperty("DB_LOCALE") != null) {
            this.is_db_loc_set = true;
        }
        if (this.useV5server && (string2 = this.connInfo.getProperty("DBTODAY")) != null) {
            properties.put("DBTODAY", string2);
        }
        if (!this.useV5server || this.useV5server && properties.getProperty("DBPATH") == null) {
            properties.put("DBPATH", ".");
        }
        properties.put("IFX_UPDDESC", "1");
        if (this.connInfo.getProperty("IFX_PAM_CLASS") != null) {
            properties.put("CLNT_PAM_CAPABLE", "1");
        }
        return properties;
    }

    private void parseIfxLocale(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "@");
        string2 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string2, ".");
        string3 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getSQLException(-79784, this);
        }
        string4 = stringTokenizer.nextToken();
        if (string == "cl") {
            this.clLocale = string3;
            this.clEncoding = string4;
        } else {
            this.dbLocale = string3;
            this.dbEncoding = string4;
        }
    }

    private Properties SetSecEVars() {
        String[] stringArray = new String[]{"DBTIME", "DBMAXPROC", "DBTEMP", "DEBUG", "DUMPCORE", "DUMPDIR", "DUMPMEM", "DUMPSHMEM", "GCORE", "NOSHMSG", "PSORT_DBTEMP", "PSORT_NPROCS", "SHELL", "TZ", "W1", "W2", "NOSORTINDEX", "SORTINDEX", "DBUPSPACE", "SUBQCACHESZ", "NO_KEYFIRST", "NO_PREDPROMOTE", "NO_SUBQF", "PDQPRIORITY", "IFX_DIRECTIVES", "IFX_NO_OROPT", "IFX_PAD_VARCHAR", "IFX_UPDDESC", "OPTCOMPIND", "INFORMIXCONRETRY", "INFORMIXOPCACHE", "GL_DATETIME", "SQLSTATS", "DBCENTURY", "PLCONFIG", "DBANSIWARN", "PATH", "CR_LOCKBLOB", "LOCKSSFU", "LIGHT_SCANS", "SQL_FROM_DBIMPORT", "PLOAD_LO_PATH", "OPT_GOAL", "USE_DTENV", "OPTOFC"};
        Properties properties = new Properties();
        properties.put("DBTEMP", "/tmp");
        properties.put("SUBQCACHESZ", "10");
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            string = this.connInfo.getProperty(stringArray[n]);
            if (string != null) {
                properties.put(stringArray[n], string);
            }
            ++n;
        }
        this.dbTime = properties.getProperty("DBTIME");
        this.glDateTime = properties.getProperty("GL_DATETIME");
        String string2 = properties.getProperty("USE_DTENV");
        if (string2 != null && string2.equalsIgnoreCase("1")) {
            this.useDtenv = true;
        }
        this.dbCentury = properties.getProperty("DBCENTURY");
        if (!(this.dbCentury == null || this.dbCentury.equalsIgnoreCase("R") || this.dbCentury.equalsIgnoreCase("F") || this.dbCentury.equalsIgnoreCase("C") || this.dbCentury.equalsIgnoreCase("P"))) {
            this.dbCentury = null;
        }
        if (!this.useV5server && (string = this.connInfo.getProperty("DBTODAY")) != null) {
            properties.put("DBTODAY", string);
        }
        return properties;
    }

    private void getServerVer() throws SQLException {
        String string = null;
        if (this.internalVersion == 0) {
            try {
                this.proto.executeVersion();
                string = this.proto.getServerVersion();
                if (this.externalVersion == null) {
                    this.externalVersion = string;
                }
            }
            catch (SQLException sQLException) {
                throw IfxErrMsg.getSQLException(-79716, sQLException.toString(), (IfxConnection)this);
            }
            if (string.compareTo("9.03") == 0) {
                this.dbVersion.set(4);
                this.dbVersion.set(3);
                this.dbVersion.set(2);
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("9.02") >= 0) {
                this.dbVersion.set(3);
                this.dbVersion.set(2);
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("9.00") >= 0) {
                this.dbVersion.set(2);
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("8.40") >= 0) {
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
                this.dbVersion.set(18);
            } else if (string.compareTo("8.20") >= 0) {
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("8.10") >= 0) {
                this.dbVersion.set(45);
                this.dbVersion.set(0);
            } else if (string.compareTo("7.31") >= 0 && string.compareTo("7.z") <= 0) {
                this.dbVersion.set(46);
                this.dbVersion.set(9);
                this.dbVersion.set(45);
                this.dbVersion.set(6);
                this.dbVersion.set(1);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("7.30") >= 0 && string.compareTo("7.z") <= 0) {
                this.dbVersion.set(9);
                this.dbVersion.set(45);
                this.dbVersion.set(6);
                this.dbVersion.set(1);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("7.23") >= 0 && string.compareTo("7.z") <= 0) {
                this.dbVersion.set(6);
                this.dbVersion.set(1);
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("7.22") >= 0 && string.compareTo("7.z") <= 0) {
                this.dbVersion.set(1);
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("7.20") >= 0 && string.compareTo("7.z") <= 0) {
                this.dbVersion.set(45);
                this.dbVersion.set(0);
                this.dbVersion.set(47);
            } else if (string.compareTo("7.00") >= 0) {
                this.dbVersion.set(45);
                this.dbVersion.set(0);
            } else if (string.compareTo("6.00") >= 0) {
                this.dbVersion.set(0);
            } else {
                this.clear_dbVersion();
            }
        } else {
            this.dbVersion.set(4);
            this.dbVersion.set(3);
            this.dbVersion.set(2);
            this.dbVersion.set(45);
            this.dbVersion.set(0);
            this.dbVersion.set(47);
            if (this.internalVersion == 316) {
                this.enhancedProtocolMechanism();
            } else if (this.internalVersion >= 315) {
                this.dbVersion.set(34);
                this.dbVersion.set(13);
                this.dbVersion.set(11);
                this.dbVersion.set(10);
                this.dbVersion.set(8);
                this.dbVersion.set(5);
            } else if (this.internalVersion >= 307) {
                this.dbVersion.set(13);
                this.dbVersion.set(11);
                this.dbVersion.set(10);
                this.dbVersion.set(8);
                this.dbVersion.set(5);
            } else if (this.internalVersion >= 305) {
                this.dbVersion.set(11);
                this.dbVersion.set(10);
                this.dbVersion.set(8);
                this.dbVersion.set(5);
            } else if (this.internalVersion >= 304) {
                this.dbVersion.set(10);
                this.dbVersion.set(8);
                this.dbVersion.set(5);
            } else if (this.internalVersion >= 303) {
                this.dbVersion.set(8);
                this.dbVersion.set(5);
            } else if (this.internalVersion >= 301) {
                this.dbVersion.set(5);
            } else if (this.internalVersion < 300) {
                this.clear_dbVersion();
            }
        }
        if (this.useV5server && !this.dbVersion.isEmpty()) {
            throw IfxErrMsg.getSQLException(-79762, this);
        }
    }

    IfxDataOutputStream Ifxproto_send() {
        return this.OutputStream;
    }

    IfxDataInputStream Ifxproto_receive() {
        return this.InputStream;
    }

    void setInSQLExec(boolean bl) {
        this.insqlexec = bl;
    }

    boolean getInsqlexec() {
        return this.insqlexec;
    }

    void setTxEndState() {
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 2) {
            this.TxState = 1;
            if (this.autoCommit && this.AnsiDb) {
                this.SendCommit = true;
            }
        }
    }

    void setTxBeginState() {
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 1) {
            this.TxState = (short)2;
            this.SendCommit = false;
        }
    }

    public boolean isDelimIdentSet() {
        return this.delimIdent;
    }

    public boolean isGLS() {
        return this.dbVersion.get(47);
    }

    public boolean isOnLine() {
        return this.onlineSer;
    }

    public boolean isLongID() {
        return this.dbVersion.get(10) || this.dbVersion.get(18);
    }

    public boolean is90303() {
        return this.dbVersion.get(8);
    }

    public boolean is9301() {
        return this.dbVersion.get(5);
    }

    public boolean isDescribeInputSupported() {
        return this.dbVersion.get(34);
    }

    public boolean isLvcGtThan2kSupported() {
        return this.dbVersion.get(37);
    }

    public boolean isANSIJoin() {
        return this.dbVersion.get(46) || this.dbVersion.get(10);
    }

    public boolean isXPSVER8_40() {
        return this.dbVersion.get(18);
    }

    boolean is903() {
        return this.dbVersion.get(4);
    }

    boolean is902() {
        return this.dbVersion.get(3);
    }

    public boolean isUSVER() {
        return this.dbVersion.get(2);
    }

    public boolean isXPS() {
        return this.externalVersion.charAt(0) == '8';
    }

    public boolean isIEEEM() {
        return !this.floatToDec;
    }

    public boolean isSysmaster() {
        return this.onlineSer && this.isASF();
    }

    boolean isASF() {
        return this.dbVersion.get(0);
    }

    public boolean isAutoFree() {
        return this.dbVersion.get(1) || this.dbVersion.get(3);
    }

    boolean isDefPrep() {
        return this.dbVersion.get(6) || this.dbVersion.get(5);
    }

    boolean isFetchArr() {
        return this.dbVersion.get(9) || this.dbVersion.get(8);
    }

    boolean isCurSessInfo() {
        return this.dbVersion.get(45);
    }

    boolean isVarcharVarLenSupported() {
        return this.dbVersion.get(13) && (!this.dbVersion.get(40) || this.dbVersion.get(40) && !this.ifxPADVARCHAR);
    }

    public boolean isMultipleUdrOutSupported() {
        return this.dbVersion.get(36);
    }

    public boolean isPAMAuthentication() {
        return this.dbVersion.get(44);
    }

    public boolean getMapFloat() {
        return this.mapFloat;
    }

    public boolean getMapReal() {
        return this.mapReal;
    }

    public Trace getTrace() {
        return this.traceObj;
    }

    public Trace getProtoTrace() {
        return this.protoTraceObj;
    }

    public synchronized boolean lockSession() {
        return this.lockSession(-1L);
    }

    public synchronized boolean lockSession(long l) {
        try {
            while (this.sessionMutexLocked) {
                if (l == -1L) {
                    Thread.yield();
                    this.wait();
                    continue;
                }
                Thread.yield();
                this.wait(l);
            }
            this.sessionMutexLocked = true;
            return true;
        }
        catch (Exception exception) {
            this.sessionMutexLocked = false;
            return false;
        }
    }

    public synchronized boolean unlockSession() {
        if (this.sessionMutexLocked) {
            this.sessionMutexLocked = false;
        }
        this.notify();
        return true;
    }

    void abortSession() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notify();
    }

    public synchronized String getGeneratedCursor() {
        String string = Long.toString(this.nextID, 36);
        string = PREFIX + ZEROSTRING.substring(0, ZEROSTRING.length() - string.length()) + string;
        if (this.nextID++ >= Long.MAX_VALUE) {
            this.nextID = 0L;
        }
        return string;
    }

    public String getProtoClassName() {
        return this.protoClassName;
    }

    public String getConnClassName() {
        return "com.informix.jdbc.IfxSqliConnect";
    }

    private void setWarnings() {
        int n = 0;
        if (this.SerWarn == 0) {
            return;
        }
        short s = this.SerWarn;
        if (this.Noansiwarn) {
            s = (short)(s & 0xFFFFFFEF);
        }
        int n2 = 1;
        while (n2 <= 6) {
            n = s & 1;
            if (n == 1) {
                this.serverWarningsString.setCharAt(n2, 'W');
                switch (n2) {
                    case 1: {
                        this.addWarning(null, "01I01");
                        break;
                    }
                    case 2: {
                        this.addWarning(null, "01I03");
                        break;
                    }
                    case 3: {
                        this.addWarning(null, "01I04");
                        this.onlineSer = true;
                        break;
                    }
                    case 4: {
                        this.addWarning(null, "01I05");
                        break;
                    }
                    case 5: {
                        this.addWarning(null, "01I06");
                        break;
                    }
                    case 6: {
                        this.addWarning(null, "01I10");
                    }
                }
            } else {
                this.serverWarningsString.setCharAt(n2, ' ');
            }
            s = (short)(s >> 1);
            n2 = (short)(n2 + 1);
        }
    }

    private String formatURL(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        return string + "," + string2;
    }

    private void setInternalQuery(boolean bl) throws SQLException {
        if (!this.AnsiDb || !this.autoCommit && this.internalQuery == 0) {
            return;
        }
        if (this.TxState == 0) {
            return;
        }
        if (bl) {
            this.autoCommit = false;
            if (this.SendCommit) {
                this.internalQuery |= 2;
                this.SendCommit = false;
            }
            this.internalQuery |= 1;
        } else if ((this.internalQuery & 1) > 0) {
            this.autoCommit = true;
            if ((this.internalQuery & 2) > 0) {
                this.SendCommit = true;
            }
            this.internalQuery = 0;
        }
    }

    protected IfxUDTInfo addUDTInfo(String string, String string2) throws SQLException {
        if (string2 == null) {
            return null;
        }
        ResultSet resultSet = null;
        Object var4_4 = null;
        IfxUDTInfo ifxUDTInfo = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        IfxUDTInfo[] ifxUDTInfoArray = new IfxUDTInfo[]{null, null, null};
        if (!this.isDbOpen()) {
            return null;
        }
        if (this.udtMap == null) {
            this.udtMap = Collections.synchronizedMap(new IfxMap(this.isDelimIdentSet()));
        }
        this.setInternalQuery(true);
        if (string == null) {
            string = new String("%");
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement("select extended_id, mode, owner, name, type, source, length from informix.sysxtdtypes where mode in ('R','B','D','C','T') and name like ? order by extended_id");
            if (string2.startsWith("timeseries(")) {
                string2 = this.strip(string2);
            }
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while (resultSet.next()) {
                Object object;
                Object object2;
                int n3 = resultSet.getInt(1);
                string3 = resultSet.getString(2);
                string4 = resultSet.getString(3);
                string5 = resultSet.getString(4);
                short s = resultSet.getShort(5);
                int n4 = resultSet.getInt(6);
                int n5 = resultSet.getInt(7);
                ifxUDTInfo = this.loadUDT(n3, string3, string5, string4, s, n4, n5);
                String string6 = string4.trim();
                if (IfxTypes.isComplexType(s = (short)(s & 0xFF))) {
                    object2 = null;
                    object2 = string3.equals("D") ? this.loadStructInfo(n4) : this.loadStructInfo(n3);
                    ifxUDTInfo.structInfo = new IfxResultSetMetaData(this, (Vector)object2);
                    if (s == 22 && string5 != null) {
                        object = (IfxColumnInfo)((Vector)object2).get(0);
                        ((IfxColumnInfo)object).ExtendedName = string5.trim();
                        if (string6 != null) {
                            ((IfxColumnInfo)object).ExtendedOwner = string6;
                        }
                    }
                }
                if (this.useTypeCache) {
                    if (this.getDatabaseType() == 1) {
                        this.udtMap.put(string6 + "." + string5, ifxUDTInfo);
                    } else {
                        this.udtMap.put(string5, ifxUDTInfo);
                    }
                }
                if (string6.equals(object2 = this.getUserName())) {
                    bl = true;
                    ifxUDTInfoArray[0] = ifxUDTInfo;
                    if (this.useTypeCache) continue;
                    break;
                }
                object = this.prepareStatement("select count(*) from informix.sysxtdtypeauth t where t.type = ? and (t.grantee in ('public', ?) or exists (select rolename from informix.sysroleauth r where t.grantee = r.rolename and r.grantee = ?) ) and t.auth in ('-u', '-U')");
                object.setInt(1, n3);
                object.setString(2, (String)object2);
                object.setString(3, (String)object2);
                ResultSet resultSet2 = object.executeQuery();
                if (resultSet2.next()) {
                    int n6 = resultSet2.getInt(1);
                    if (n6 > 0) {
                        if (n == 0) {
                            ifxUDTInfoArray[1] = ifxUDTInfo;
                        }
                        ++n;
                    } else {
                        if (n2 == 0) {
                            ifxUDTInfoArray[2] = ifxUDTInfo;
                        }
                        ++n2;
                    }
                }
                resultSet2.close();
                object.close();
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.setInternalQuery(false);
            throw sQLException;
        }
        this.setInternalQuery(false);
        if (string2.equals("%")) {
            return null;
        }
        if (!bl && n == 0 && n2 == 0) {
            return null;
        }
        if (bl) {
            return ifxUDTInfoArray[0];
        }
        if (n == 1) {
            return ifxUDTInfoArray[1];
        }
        if (n2 == 1 && this.getUserName().equals("informix")) {
            return ifxUDTInfoArray[2];
        }
        throw IfxErrMsg.getSQLException(-79770, this);
    }

    public Object loadUDTba(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, short s, int n2, int n3) throws SQLException {
        String string = new String(byArray, 0, 129);
        String string2 = new String(byArray2, 0, 129);
        String string3 = new String(byArray3, 0, 129);
        Vector vector = new Vector();
        IfxUDTInfo ifxUDTInfo = this.loadUDT(n, string, string2, string3, s, n2, n3);
        ifxUDTInfo.structInfo = new IfxResultSetMetaData(this, vector);
        return ifxUDTInfo;
    }

    private IfxUDTInfo loadUDT(int n, String string, String string2, String string3, short s, int n2, int n3) {
        IfxUDTInfo ifxUDTInfo = new IfxUDTInfo();
        ifxUDTInfo.SQLtype = s & 0xFF;
        ifxUDTInfo.xid = n;
        ifxUDTInfo.JDBCtype = string.equals("B") || string.equals("T") ? (short)2000 : (string.equals("D") ? (short)2001 : (short)2002);
        ifxUDTInfo.name = string2;
        ifxUDTInfo.owner = string3.trim();
        ifxUDTInfo.source = n2;
        if (string.equals("D") && ifxUDTInfo.source == 0) {
            ifxUDTInfo.source = s & 0xFF;
        }
        ifxUDTInfo.sourceLength = n3;
        return ifxUDTInfo;
    }

    private Vector loadStructInfo(int n) throws SQLException {
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>();
        Vector<IfxColumnInfo> vector2 = new Vector<IfxColumnInfo>();
        PreparedStatement preparedStatement = this.prepareStatement("select extended_id, seqno, levelno, parent_no,        fieldname, fieldno, type, length, xtd_type_id from informix.sysattrtypes where extended_id = ? order by seqno");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = this.prepareStatement("select owner, name, source from informix.sysxtdtypes where extended_id = ?");
        while (resultSet.next()) {
            IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
            ifxColumnInfo.Seqno = resultSet.getShort(2);
            ifxColumnInfo.Levelno = resultSet.getShort(3);
            ifxColumnInfo.Parentno = resultSet.getShort(4);
            ifxColumnInfo.ColName = resultSet.getString(5);
            ifxColumnInfo.Fieldno = resultSet.getShort(6);
            ifxColumnInfo.SQLtype = resultSet.getShort(7);
            ifxColumnInfo.ColLength = resultSet.getShort(8);
            ifxColumnInfo.ExtendedId = resultSet.getInt(9);
            IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfo, ifxColumnInfo.SQLtype);
            ifxColumnInfo.SQLtype &= 0xFF;
            if (ifxColumnInfo.ExtendedId != 0) {
                if (ifxColumnInfo.ExtendedId == 1) {
                    ifxColumnInfo.SQLtype = 43;
                } else if (ifxColumnInfo.ExtendedId == 5) {
                    ifxColumnInfo.SQLtype = 45;
                } else if (ifxColumnInfo.ExtendedId == 10) {
                    ifxColumnInfo.SQLtype = 102;
                } else if (ifxColumnInfo.ExtendedId == 11) {
                    ifxColumnInfo.SQLtype = 101;
                } else {
                    preparedStatement2.setInt(1, ifxColumnInfo.ExtendedId);
                    ResultSet resultSet2 = preparedStatement2.executeQuery();
                    resultSet2.next();
                    ifxColumnInfo.ExtendedOwner = resultSet2.getString(1).trim();
                    ifxColumnInfo.ExtendedName = resultSet2.getString(2);
                    if (ifxColumnInfo.IsDistinct) {
                        ifxColumnInfo.SourceType = resultSet2.getInt(3);
                        if (ifxColumnInfo.SourceType == 0) {
                            ifxColumnInfo.SourceType = ifxColumnInfo.SQLtype;
                        } else if (ifxColumnInfo.SourceType == 1) {
                            ifxColumnInfo.SQLtype = 43;
                        } else if (ifxColumnInfo.SourceType == 5) {
                            ifxColumnInfo.SQLtype = 45;
                        } else if (ifxColumnInfo.SourceType == 10) {
                            ifxColumnInfo.SQLtype = 102;
                        } else if (ifxColumnInfo.SourceType == 11) {
                            ifxColumnInfo.SQLtype = 101;
                        }
                    }
                    resultSet2.close();
                    if (ifxColumnInfo.ExtendedOwner == null) {
                        ifxColumnInfo.ExtendedOwner = "";
                    }
                    if (ifxColumnInfo.ExtendedName == null) {
                        ifxColumnInfo.ExtendedName = "";
                    }
                    if (IfxTypes.isComplexType(ifxColumnInfo.SQLtype)) {
                        Vector vector3 = this.loadStructInfo(ifxColumnInfo.ExtendedId);
                        ifxColumnInfo.child = ((IfxColumnInfo)vector3.get((int)0)).child;
                    }
                }
            } else {
                ifxColumnInfo.ExtendedOwner = "";
                ifxColumnInfo.ExtendedName = "";
            }
            ifxColumnInfo.Alignment = 0;
            ifxColumnInfo.SourceType = 0;
            if (ifxColumnInfo.Seqno == 1) {
                vector.addElement(ifxColumnInfo);
                if (ifxColumnInfo.child != null) continue;
                ifxColumnInfo.child = vector2;
                continue;
            }
            vector2.addElement(ifxColumnInfo);
        }
        resultSet.close();
        preparedStatement.close();
        preparedStatement2.close();
        return vector;
    }

    public void setStructInfo(Object object, short s, short s2, short s3, byte[] byArray, short s4, short s5, short s6, int n, byte[] byArray2, byte[] byArray3) throws SQLException {
        IfxUDTInfo ifxUDTInfo = (IfxUDTInfo)object;
        IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
        IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.structInfo;
        Vector vector = ifxResultSetMetaData.getColumnInfoVector();
        ifxColumnInfo.Seqno = s;
        ifxColumnInfo.Levelno = s2;
        ifxColumnInfo.Parentno = s3;
        ifxColumnInfo.ColName = byArray == null ? null : new String(byArray, 0, 129);
        ifxColumnInfo.Fieldno = s4;
        ifxColumnInfo.SQLtype = s5;
        ifxColumnInfo.ColLength = s6;
        ifxColumnInfo.ExtendedId = n;
        IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfo, ifxColumnInfo.SQLtype);
        ifxColumnInfo.SQLtype &= 0xFF;
        if (ifxColumnInfo.ExtendedId != 0) {
            if (ifxColumnInfo.ExtendedId == 1) {
                ifxColumnInfo.SQLtype = 43;
            } else if (ifxColumnInfo.ExtendedId == 5) {
                ifxColumnInfo.SQLtype = 45;
            } else if (ifxColumnInfo.ExtendedId == 10) {
                ifxColumnInfo.SQLtype = 102;
            } else if (ifxColumnInfo.ExtendedId == 11) {
                ifxColumnInfo.SQLtype = 101;
            } else {
                ifxColumnInfo.ExtendedOwner = byArray2 == null ? null : new String(byArray2, 0, 129);
                ifxColumnInfo.ExtendedName = byArray3 == null ? null : new String(byArray3, 0, 129);
                if (IfxTypes.isComplexType(ifxColumnInfo.SQLtype)) {
                    IfxUDTInfo ifxUDTInfo2 = this.getUDTInfo(ifxColumnInfo.ExtendedName, ifxColumnInfo.ExtendedOwner);
                    IfxResultSetMetaData ifxResultSetMetaData2 = ifxUDTInfo2.structInfo;
                    Vector vector2 = ifxResultSetMetaData2.getColumnInfoVector();
                    ifxColumnInfo.child = ((IfxColumnInfo)vector2.get((int)0)).child;
                }
            }
        }
        ifxColumnInfo.Alignment = 0;
        ifxColumnInfo.SourceType = 0;
        vector.addElement(ifxColumnInfo);
    }

    public IfxUDTInfo getUDTInfo(IfxColumnInfo ifxColumnInfo) throws SQLException {
        return null;
    }

    public IfxUDTInfo getUDTInfo(IfxColumnInfo ifxColumnInfo, String string) throws SQLException {
        String string2 = ifxColumnInfo == null || ifxColumnInfo.ExtendedOwner == null ? "%" : ifxColumnInfo.ExtendedOwner.trim();
        return this.getUDTInfo(string.trim(), string2);
    }

    public IfxUDTInfo getUDTInfo(int n) throws SQLException {
        IfxUDTInfo ifxUDTInfo = null;
        if (this.useTypeCache && this.xidMap != null && (ifxUDTInfo = (IfxUDTInfo)this.xidMap.get(new Integer(n))) != null) {
            return ifxUDTInfo;
        }
        if (!this.isDbOpen()) {
            return null;
        }
        if (this.xidMap == null) {
            this.xidMap = Collections.synchronizedMap(new IfxMap(false));
        }
        this.setInternalQuery(true);
        try {
            PreparedStatement preparedStatement = this.prepareStatement("select mode, owner, name, type, source, length from informix.sysxtdtypes where extended_id = ?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (resultSet.next()) {
                string = resultSet.getString(1);
                string2 = resultSet.getString(2);
                string3 = resultSet.getString(3);
                short s = resultSet.getShort(4);
                int n2 = resultSet.getInt(5);
                int n3 = resultSet.getInt(6);
                ifxUDTInfo = this.loadUDT(n, string, string3, string2, s, n2, n3);
                if (string.equals("R") || string.equals("C")) {
                    Vector vector = this.loadStructInfo(n);
                    ifxUDTInfo.structInfo = new IfxResultSetMetaData(this, vector);
                } else if (string.equals("S")) {
                    PreparedStatement preparedStatement2 = this.prepareStatement("select name from informix.sysxtdtypes where extended_id = (select xtd_type_id from informix.sysattrtypes where extended_id = ? and type = ?)");
                    preparedStatement2.setInt(1, n);
                    preparedStatement2.setInt(2, s);
                    ResultSet resultSet2 = preparedStatement2.executeQuery();
                    while (resultSet2.next()) {
                        ifxUDTInfo.name = resultSet2.getString(1).trim();
                    }
                    resultSet2.close();
                    preparedStatement2.close();
                }
                if (this.useTypeCache) {
                    this.xidMap.put(new Integer(n), ifxUDTInfo);
                }
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this.setInternalQuery(false);
            throw sQLException;
        }
        this.setInternalQuery(false);
        return ifxUDTInfo;
    }

    public IfxUDTInfo getUDTInfo(String string, String string2) throws SQLException {
        IfxUDTInfo ifxUDTInfo = null;
        if (!this.isDelimIdentSet()) {
            string = string.toLowerCase();
        }
        if (this.useTypeCache) {
            if (this.udtMap != null && (ifxUDTInfo = (IfxUDTInfo)this.udtMap.get(string.trim())) == null && this.getDatabaseType() == 1) {
                String string3 = string2.trim();
                if (string3.equals("%")) {
                    string3 = this.getUserName();
                    ifxUDTInfo = (IfxUDTInfo)this.udtMap.get(string3 + "." + string);
                    if (ifxUDTInfo == null) {
                        ifxUDTInfo = (IfxUDTInfo)this.udtMap.get("informix." + string);
                    }
                } else {
                    ifxUDTInfo = (IfxUDTInfo)this.udtMap.get(string3 + "." + string);
                }
            }
        }
        if (ifxUDTInfo == null) {
            ifxUDTInfo = this.addUDTInfo(string2, string.trim());
        }
        return ifxUDTInfo;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    public boolean getUsePut() {
        return this.usePut;
    }

    public boolean getTrimTrailingSpaces() {
        return this.TrimTrailingSpaces;
    }

    public int getBlobCacheSize() {
        return this.lobCacheSize;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    int getCodesetLobSize() {
        return this.codesetLobSize;
    }

    boolean isCTSCompliant() {
        return this.ctsCompliant;
    }

    boolean isBatchUpdatePerSpec() {
        return this.batchUpdatePerSpec;
    }

    boolean isConvText() {
        return this.convText;
    }

    public String getdbDate() {
        return this.dbDate;
    }

    public String getglDate() {
        return this.glDate;
    }

    public String getdbTime() {
        return this.dbTime;
    }

    public String getglDateTime() {
        return this.glDateTime;
    }

    public boolean getclLocaleProp() {
        return this.is_client_loc_set;
    }

    public boolean getdbLocaleProp() {
        return this.is_db_loc_set;
    }

    public boolean getuseDtenv() {
        return this.useDtenv;
    }

    public String getdbCentury() {
        return this.dbCentury;
    }

    public String getdbLocale() {
        return this.dbLocale;
    }

    public String getdbEncoding() {
        return this.dbEncoding;
    }

    public String getclLocale() {
        return this.clLocale;
    }

    protected void setLocale(String string) {
        this.clLocale = string;
        if (this.dbLocale == null) {
            this.dbLocale = this.clLocale;
        }
    }

    public String getclEncoding() {
        return this.clEncoding;
    }

    public String getJDBCTempDir() {
        if (this.tempdir == null) {
            this.tempdir = "";
        }
        return this.tempdir;
    }

    public boolean isANSI() {
        return this.AnsiDb;
    }

    public String getXnameByXid(int n) throws SQLException {
        this.setInternalQuery(true);
        String string = null;
        try {
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("select name from informix.sysxtdtypes where extended_id = " + n);
            if (resultSet.next()) {
                string = resultSet.getString(1).trim();
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            this.setInternalQuery(false);
            throw sQLException;
        }
        this.setInternalQuery(false);
        return string;
    }

    private void addLocale(String string, String string2) {
        this.IfxToJdkLocaleTable.put(string, string2);
    }

    private void addEncName(String string, String string2) {
        this.IfxToJdkEncodingTable.put(string, string2);
    }

    private void addEncNumber(String string, String string2) {
        this.IfxNoToJdkEncodingTable.put(string, string2);
    }

    private String getEncName(String string) {
        String string2 = null;
        if (this.IfxToJdkEncodingTable != null) {
            string2 = (String)this.IfxToJdkEncodingTable.get(string);
        }
        if (string2 == null) {
            string2 = IfxLocales.FromIfxNameToJdkName(string);
        }
        return string2;
    }

    private String getEncNo(String string) {
        String string2 = null;
        if (this.IfxNoToJdkEncodingTable != null) {
            string2 = (String)this.IfxNoToJdkEncodingTable.get(string);
        }
        if (string2 == null) {
            string2 = IfxLocales.FromIfxNoToJdkName(string);
        }
        return string2;
    }

    private String getLocale(String string) {
        String string2 = null;
        if (this.IfxToJdkLocaleTable != null) {
            string2 = (String)this.IfxToJdkLocaleTable.get(string.toLowerCase());
        }
        if (string2 == null) {
            string2 = IfxLocales.FromIfxToJdkLocale(string);
        }
        return string2;
    }

    private void set5ServerType() throws SQLException {
        try {
            String string = "select colmax from informix.syscolumns c, informix.systables t where c.tabid = t.tabid and t.tabname like 'syscolumns'";
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            this.onlineSer = true;
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -217) {
                this.onlineSer = false;
            }
            throw sQLException;
        }
    }

    public void xaSetSerWarnFlags(short s, String string) throws SQLException {
        boolean bl = false;
        Object var4_4 = null;
        this.dbName = string;
        int n = 0;
        int n2 = 0;
        this.startMetaDataQuery();
        try {
            Statement statement = this.createStatement();
            String string2 = "select is_ansi, is_logging from sysmaster:informix.sysdatabases where name=";
            string2 = string2 + "'" + this.dbName + "'";
            ResultSet resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
                n2 = resultSet.getInt(2);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            this.endMetaDataQuery();
            throw sQLException;
        }
        this.endMetaDataQuery();
        if (n == 1) {
            s = (short)(s | 2);
        }
        if (n2 == 1) {
            s = (short)(s | 1);
        }
        this.SerWarn = (short)(this.SerWarn | s);
        this.OpenDbInit();
    }

    public IfxProtocol getProto() {
        return this.proto;
    }

    public IfxProtocol createProto() {
        return new IfxSqli(this);
    }

    public int getFetchBufSize() {
        return this.fetchBufSize;
    }

    int getCorrectedFetchBufSize() {
        return Math.min(this.getMaxFetchBufSize(), this.fetchBufSize);
    }

    int getMaxFetchBufSize() {
        return this.isXPSVER8_40() ? 0x200000 : Short.MAX_VALUE;
    }

    public long getdbTodayDate() {
        return this.dbTodayDate;
    }

    public long getdbTodayStart() {
        return this.dbTodayStart;
    }

    void setDbName(String string) {
        this.dbName = string;
    }

    public boolean isXAConnection() {
        return false;
    }

    public boolean inXATransaction() {
        return false;
    }

    public int getFPCacheRoutineId(String string) {
        IfxSqliConnect$FPCacheInfo ifxSqliConnect$FPCacheInfo = null;
        ifxSqliConnect$FPCacheInfo = (IfxSqliConnect$FPCacheInfo)this.fpCache.get(string);
        if (ifxSqliConnect$FPCacheInfo != null) {
            return ifxSqliConnect$FPCacheInfo.routineId;
        }
        return -1;
    }

    public IfxFParam getFPCacheFParam(String string) {
        IfxSqliConnect$FPCacheInfo ifxSqliConnect$FPCacheInfo = null;
        ifxSqliConnect$FPCacheInfo = (IfxSqliConnect$FPCacheInfo)this.fpCache.get(string);
        if (ifxSqliConnect$FPCacheInfo != null) {
            return ifxSqliConnect$FPCacheInfo.fparam;
        }
        return null;
    }

    public void setFPCacheInfo(int n, String string, IfxFParam ifxFParam) {
        IfxSqliConnect$FPCacheInfo ifxSqliConnect$FPCacheInfo = new IfxSqliConnect$FPCacheInfo(this, n, ifxFParam);
        this.fpCache.put(string, ifxSqliConnect$FPCacheInfo);
    }

    private String strip(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n != 0 && n2 != 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private void addToStmtList(IfxStatement ifxStatement) {
        if (this.stmtList == null) {
            this.stmtList = new Vector(20);
        }
        if (ifxStatement != null) {
            this.stmtList.addElement(ifxStatement);
        }
    }

    protected void markCursorsToClosed(boolean bl) {
        IfxStatement ifxStatement = null;
        if (this.stmtList != null) {
            int n = 0;
            while (n < this.stmtList.size()) {
                ifxStatement = (IfxStatement)this.stmtList.elementAt(n);
                if (bl) {
                    if (ifxStatement.getStatementType() != 56) {
                        ifxStatement.cursorOpen = false;
                    }
                } else {
                    ifxStatement.cursorOpen = false;
                }
                ++n;
            }
        }
    }

    protected void removeFromStmtList(IfxStatement ifxStatement) {
        if (ifxStatement == null) {
            return;
        }
        if (this.stmtList != null && this.stmtList.size() > 0) {
            boolean bl = this.stmtList.removeElement(ifxStatement);
        }
    }

    public void addToBlobList(IfxSmartBlob ifxSmartBlob) {
        if (this.blobList == null) {
            this.blobList = new Vector(20);
        }
        if (ifxSmartBlob != null) {
            this.blobList.addElement(ifxSmartBlob);
        }
    }

    public boolean isInUserTransaction() {
        return this.TxState == 2;
    }

    public void setHoldability(int n) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:setSavepoint()", Locale.getDefault());
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:setSavepoint(String)", Locale.getDefault());
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:rollback(Savepoint)", Locale.getDefault());
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:releaseSavepoint(Savepoint)", Locale.getDefault());
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:createStatement(int,int,int)", Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:prepareStatement(String,int,int,int)", Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:prepareStatement(String,int)", Locale.getDefault());
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:prepareCall(String,int,int,int)", Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:prepareStatement(String,int[])", Locale.getDefault());
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxSqliConnection:prepareStatement(String,String[])", Locale.getDefault());
    }

    void setSQLStatementOffset(int n) {
        this.stmtErrorOffset = n;
    }

    public int getSQLStatementOffset() {
        return this.stmtErrorOffset;
    }

    protected void startMetaDataQuery() throws SQLException {
        if (!this.autoCommit && !this.isInUserTransaction()) {
            this.setAutoCommit(true);
            this.autoCommitModeChanged = true;
        }
    }

    protected void endMetaDataQuery() throws SQLException {
        if (this.autoCommitModeChanged) {
            this.setAutoCommit(false);
            this.autoCommitModeChanged = false;
        }
    }

    private void setLockModeWait(int n) throws SQLException {
        String string;
        switch (n) {
            case -1: {
                string = "set lock mode to wait ";
                break;
            }
            case 0: {
                string = "set lock mode to not wait ";
                break;
            }
            default: {
                string = "set lock mode to wait " + Integer.toString(n);
            }
        }
        Statement statement = this.createStatement();
        statement.execute(string);
        this.lockModeWaitChanged = true;
        this.newLockModeWaitStr = string;
        statement.close();
    }

    private void setIsolationLevel(String string) throws SQLException {
        int n;
        try {
            n = Integer.parseInt(string.substring(0, 1));
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        if (this.isDatabaseOpen && string != null) {
            String string2 = null;
            String string3 = "";
            boolean bl = true;
            this.transactionLevel = 0;
            if (string.length() > 1 && string.charAt(1) == 'U' && !this.useV5server) {
                string3 = " retain update locks";
            }
            switch (n) {
                case 1: {
                    string2 = "set isolation to Dirty Read" + string3;
                    this.transactionLevel = 1;
                    break;
                }
                case 2: {
                    string2 = "set isolation to Committed Read" + string3;
                    this.transactionLevel = 2;
                    break;
                }
                case 3: {
                    string2 = "set isolation to Cursor Stability" + string3;
                    this.transactionLevel = 2;
                    break;
                }
                case 4: {
                    string2 = "set isolation to Repeatable Read" + string3;
                    this.transactionLevel = 4;
                    break;
                }
                default: {
                    if (this.AnsiDb) {
                        string2 = "set isolation to Repeatable Read" + string3;
                        this.transactionLevel = 8;
                        break;
                    }
                    if (this.db_use_log) {
                        string2 = "set isolation to Committed Read" + string3;
                        this.transactionLevel = 2;
                        break;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Statement statement = this.createStatement();
                statement.execute(string2);
                this.isolationLevelChanged = true;
                this.newIsolationLevelStr = string2;
                this.newTxLevel = this.transactionLevel;
                statement.close();
            }
        }
    }

    private void enhancedProtocolMechanism() throws SQLException {
        this.proto.executeProtocols(this.clientProtocols);
        byte[] byArray = this.proto.getProtocols();
        int n = 0;
        while (n < byArray.length) {
            switch (n) {
                case 0: {
                    this.handleProtocolByte_1(byArray[n]);
                    break;
                }
                case 1: {
                    this.handleProtocolByte_2(byArray[n]);
                    break;
                }
                case 2: {
                    this.handleProtocolByte_3(byArray[n]);
                    break;
                }
                case 3: {
                    this.handleProtocolByte_4(byArray[n]);
                    break;
                }
                case 4: {
                    this.handleProtocolByte_5(byArray[n]);
                    break;
                }
                case 5: {
                    this.handleProtocolByte_6(byArray[n]);
                    break;
                }
            }
            ++n;
        }
    }

    private void handleProtocolByte_1(byte by) {
        if ((by & 0x80) > 0) {
            this.dbVersion.set(0);
        }
        if ((by & 0x40) > 0) {
            this.dbVersion.set(1);
        }
        if ((by & 0x20) > 0) {
            this.dbVersion.set(2);
        }
        if ((by & 0x10) > 0) {
            this.dbVersion.set(3);
        }
        if ((by & 8) > 0) {
            this.dbVersion.set(4);
        }
        if ((by & 4) > 0) {
            this.dbVersion.set(5);
        }
        if ((by & 2) > 0) {
            this.dbVersion.set(6);
        }
        if ((by & 1) > 0) {
            this.dbVersion.set(7);
        }
    }

    private void handleProtocolByte_2(byte by) {
        if ((by & 0x80) > 0) {
            this.dbVersion.set(8);
        }
        if ((by & 0x40) > 0) {
            this.dbVersion.set(9);
        }
        if ((by & 0x20) > 0) {
            this.dbVersion.set(10);
        }
        if ((by & 0x10) > 0) {
            this.dbVersion.set(11);
        }
        if ((by & 8) > 0) {
            this.dbVersion.set(12);
        }
        if ((by & 4) > 0) {
            this.dbVersion.set(13);
        }
        if ((by & 2) > 0) {
            this.dbVersion.set(14);
        }
        if ((by & 1) > 0) {
            this.dbVersion.set(15);
        }
    }

    private void handleProtocolByte_3(byte by) {
        if ((by & 0x80) > 0) {
            this.dbVersion.set(16);
        }
        if ((by & 0x40) > 0) {
            this.dbVersion.set(17);
        }
        if ((by & 0x20) > 0) {
            this.dbVersion.set(18);
        }
        if ((by & 0x10) > 0) {
            this.dbVersion.set(19);
        }
        if ((by & 8) > 0) {
            this.dbVersion.set(20);
        }
        if ((by & 4) > 0) {
            this.dbVersion.set(21);
        }
        if ((by & 2) > 0) {
            this.dbVersion.set(22);
        }
        if ((by & 1) > 0) {
            this.dbVersion.set(23);
        }
    }

    private void handleProtocolByte_4(byte by) {
        if ((by & 0x80) > 0) {
            this.dbVersion.set(24);
        }
        if ((by & 0x40) > 0) {
            this.dbVersion.set(25);
        }
        if ((by & 0x20) > 0) {
            this.dbVersion.set(26);
        }
        if ((by & 0x10) > 0) {
            this.dbVersion.set(27);
        }
        if ((by & 8) > 0) {
            this.dbVersion.set(28);
        }
        if ((by & 4) > 0) {
            this.dbVersion.set(29);
        }
        if ((by & 2) > 0) {
            this.dbVersion.set(30);
        }
        if ((by & 1) > 0) {
            this.dbVersion.set(31);
        }
    }

    private void handleProtocolByte_5(byte by) {
        if ((by & 0x80) > 0) {
            this.dbVersion.set(32);
        }
        if ((by & 0x40) > 0) {
            this.dbVersion.set(33);
        }
        if ((by & 0x20) > 0) {
            this.dbVersion.set(34);
        }
        if ((by & 0x10) > 0) {
            this.dbVersion.set(35);
        }
        if ((by & 8) > 0) {
            this.dbVersion.set(36);
        }
        if ((by & 4) > 0) {
            this.dbVersion.set(37);
        }
        if ((by & 2) > 0) {
            this.dbVersion.set(38);
        }
        if ((by & 1) > 0) {
            this.dbVersion.set(39);
        }
    }

    private void handleProtocolByte_6(byte by) {
        if ((by & 0x80) > 0) {
            this.dbVersion.set(40);
        }
        if ((by & 0x40) > 0) {
            this.dbVersion.set(41);
        }
        if ((by & 0x20) > 0) {
            this.dbVersion.set(42);
        }
        if ((by & 0x10) > 0) {
            this.dbVersion.set(43);
        }
        if ((by & 8) > 0) {
            this.dbVersion.set(44);
        }
    }

    private void clear_dbVersion() {
        int n = this.dbVersion.size();
        int n2 = 0;
        while (n2 < n) {
            this.dbVersion.clear(n2);
            ++n2;
        }
    }
}

